/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.awk4j.space.Lang;
import org.awk4j.space.T2TPL;
import org.awk4j.space.Template;
import org.awk4j.space.Tools;
import org.jetbrains.annotations.NotNull;

class Space {
    private static final Pattern LANGUAGE_START_TAG = Pattern.compile("<(?:script|style)[^>]+?>", 2);
    private static final Pattern CUT_LAST_SEMICOLON = Pattern.compile("[\\s]*;[\\s]*}[\\s]*");
    private String optCSS = " ,:>~+|()[]{}";
    private String optHTML = " ";
    private boolean isStateTransitionProhibited;
    private static final Pattern HTML_EXTRACT_TAGS = Pattern.compile("[\\s]*(</?([a-zA-Z]+[1-6]?)[^>]*?>)[\\s]*");
    private static final List<String> HTML_BLOCK_ELEMENT_LIST = Arrays.asList("address", "article", "aside", "blockquote", "br", "dd", "details", "dialog", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "main", "nav", "ol", "pre", "p", "section", "table", "td", "th", "tr", "title", "ul");
    private static final Set<String> HTML_BLOCK_ELEMENT_SET = new HashSet<String>(HTML_BLOCK_ELEMENT_LIST);
    private static final String SCRIPT_OPTIMIZE = " ;()[]{}<>=.,:?!|&^~+-*/%";
    private static final String CSS_SELECTOR = " ,:>~+|()[]{}";
    private static final String CSS_ATTRIBUTE_SELECTOR = " ()[=~|^$*]{}";
    private static final String CSS_ATTRIBUTE = " .,:;!#/(=<>)[]{}";
    private static final String CSS_MEDIA_QUERIES = " .,:;!#/(=<>)[]{}";
    private static final String HTML_OUTSIDE_TAG = " ";
    private static final String HTML_INSIDE_TAG = " =>";
    private static final String HTML_INSIDE_DEPRECATED = " =>\"'";

    Space() {
    }

    String space(String input, boolean deprecated) {
        Matcher m = LANGUAGE_START_TAG.matcher(input);
        if (m.find()) {
            this.optHTML = HTML_OUTSIDE_TAG;
            String tag = this.html(m.group(), deprecated);
            input = m.replaceFirst(tag);
            this.optHTML = HTML_OUTSIDE_TAG;
        }
        if (Lang.is(Lang.SCRIPT)) {
            return this.script(input);
        }
        if (Lang.is(Lang.CSS)) {
            return this.css(input);
        }
        return this.html(input, deprecated);
    }

    @NotNull
    private String script(@NotNull String input) {
        if (input == null) {
            Space.$$$reportNull$$$0(0);
        }
        int capacity = input.length() + 7;
        StringBuilder sb = new StringBuilder(capacity);
        T2TPL t2 = new Template().parse(input.trim());
        String src = t2.source();
        String tpl = t2.template();
        for (int i = 0; i < src.length(); ++i) {
            char t = tpl.charAt(i);
            char c = src.charAt(i);
            if ('\u007f' != t) {
                Space.optimizeSpace(sb, SCRIPT_OPTIMIZE, c);
                continue;
            }
            sb.append(c);
        }
        Matcher m = CUT_LAST_SEMICOLON.matcher(sb);
        if (m.find()) {
            String string = m.replaceAll("}");
            if (string == null) {
                Space.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = sb.toString();
        if (string == null) {
            Space.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String css(@NotNull String input) {
        if (input == null) {
            Space.$$$reportNull$$$0(3);
        }
        int capacity = input.length() + 7;
        StringBuilder sb = new StringBuilder(capacity);
        T2TPL t2 = new Template().parse(input.trim());
        String src = t2.source();
        String tpl = t2.template();
        for (int i = 0; i < src.length(); ++i) {
            char t = tpl.charAt(i);
            char c = src.charAt(i);
            if ('\u007f' != t) {
                if (!this.isStateTransitionProhibited) {
                    if ('[' == c) {
                        this.optCSS = CSS_ATTRIBUTE_SELECTOR;
                    } else if (']' == c) {
                        this.optCSS = CSS_SELECTOR;
                    } else if ('{' == c) {
                        this.optCSS = " .,:;!#/(=<>)[]{}";
                    } else if ('}' == c) {
                        this.optCSS = CSS_SELECTOR;
                    } else if ('@' == c) {
                        this.optCSS = " .,:;!#/(=<>)[]{}";
                    }
                }
                Space.optimizeSpace(sb, this.optCSS, c);
                continue;
            }
            sb.append(c);
        }
        Matcher m = CUT_LAST_SEMICOLON.matcher(sb);
        if (m.find()) {
            String string = m.replaceAll("}");
            if (string == null) {
                Space.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = sb.toString();
        if (string == null) {
            Space.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String html(@NotNull String input, boolean deprecated) {
        if (input == null) {
            Space.$$$reportNull$$$0(6);
        }
        int capacity = input.length() + 7;
        StringBuilder sb = new StringBuilder(capacity);
        StringBuilder type = new StringBuilder(capacity);
        T2TPL t2 = new Template().parse(input.trim());
        String src = t2.source() + "\r";
        String tpl = t2.template() + "\r";
        String save = this.optCSS;
        this.isStateTransitionProhibited = true;
        for (int i = 0; i < src.length(); ++i) {
            char t = tpl.charAt(i);
            char c = src.charAt(i);
            if ('\u007f' != t) {
                if (!type.isEmpty()) {
                    this.optCSS = " .,:;!#/(=<>)[]{}";
                    CharSequence seq = this.css(type.substring(1, type.length() - 1));
                    if (Tools.endsWith(seq, ';')) {
                        seq = seq.subSequence(0, seq.length() - 1);
                    }
                    char qt = type.charAt(0);
                    sb.append(qt).append(seq).append(qt);
                    type.setLength(0);
                }
                if ('<' == c) {
                    this.optHTML = deprecated ? HTML_INSIDE_DEPRECATED : HTML_INSIDE_TAG;
                }
                Space.optimizeSpace(sb, this.optHTML, c);
                if ('>' != c) continue;
                this.optHTML = HTML_OUTSIDE_TAG;
                continue;
            }
            type.append(c);
        }
        this.optCSS = save;
        this.isStateTransitionProhibited = false;
        return Space.cutSpace(Tools.rTrim(sb));
    }

    private static void optimizeSpace(@NotNull StringBuilder sb, String optimize, char ch) {
        if (sb == null) {
            Space.$$$reportNull$$$0(7);
        }
        char c = Tools.toWhiteSpace(ch);
        if (!sb.isEmpty() && 0 <= optimize.indexOf(c)) {
            char front = Tools.charAtLast(sb);
            if (0 <= optimize.indexOf(front) && ' ' == c) {
                return;
            }
            if (' ' == front) {
                if (' ' == c) {
                    return;
                }
                sb.setLength(sb.length() - 1);
            }
        }
        sb.append(c);
    }

    @NotNull
    static String cutSpace(@NotNull CharSequence s) {
        if (s == null) {
            Space.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder(s.length());
        Matcher m = HTML_EXTRACT_TAGS.matcher(s);
        while (m.find()) {
            String replacement;
            String tag = m.group(2).toLowerCase();
            if (HTML_BLOCK_ELEMENT_SET.contains(tag)) {
                replacement = m.group(1);
                Tools.rTrim(sb);
            } else {
                replacement = m.group();
            }
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        String string = sb.toString();
        if (string == null) {
            Space.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/awk4j/space/Space";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/awk4j/space/Space";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "script";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "css";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cutSpace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "script";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "css";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "html";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "optimizeSpace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cutSpace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 9 -> new IllegalStateException(string);
        };
    }
}

