/*
 * Decompiled with CFR 0.152.
 */
package plus.util;

import java.util.Arrays;

public final class Debug {
    public static void dumpThread() {
        Object[] arr = new Thread[Thread.activeCount()];
        Thread.enumerate((Thread[])arr);
        System.err.println(Arrays.deepToString(arr));
    }

    public static String objectOf(Object x) {
        StringBuilder buf = new StringBuilder();
        if (null == x) {
            buf.append("'null'");
        } else {
            buf.append(x.getClass().getName()).append(' ');
            if (x instanceof String) {
                String s = (String)x;
                if (s.isEmpty()) {
                    buf.append("\"\"");
                } else {
                    buf.append('\"').append(s).append("\" ");
                    int len = s.length();
                    for (int i = 0; len > i; ++i) {
                        buf.append(0 == i ? "" : ":");
                        buf.append(Integer.toHexString(s.charAt(i)));
                    }
                }
            } else if (x instanceof Object[]) {
                buf.append(Arrays.deepToString((Object[])x));
            } else {
                buf.append('`').append(x.toString()).append('`');
            }
        }
        return buf.toString();
    }
}

