/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import plus.lex.Advance;
import plus.lex.Flags;
import plus.lex.Keyword;
import plus.lex.LexArray;
import plus.lex.LexRegx;
import plus.lex.Node;
import plus.lex.PerseHelper;
import plus.lex.Symbols;
import plus.lex.Term;
import plus.lex.Type;
import plus.lex.TypeHelper;

abstract class Function
extends PerseHelper {
    static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Integer[] EMPTY_INT_ARRAY = new Integer[0];
    private static final Pattern RX_DOLLAR_SPLIT = Pattern.compile("[$]");
    private static final Pattern RX_DOT_SPLIT = Pattern.compile("[.]");
    private static final LexRegx rxENDLIST = new LexRegx("^[<|>;)}\n]");
    private static final Pattern RX_METHOD_NAME = Pattern.compile("[.][^.]+$");
    final Map<String, Integer[]> callMAP = new HashMap<String, Integer[]>();
    final List<Object> codeBuf = new LexArray<Object>();
    final Map<String, Node.Func> functionMap = new HashMap<String, Node.Func>();
    private final Map<String, Node.Func> builtinMAP = new HashMap<String, Node.Func>();
    int cCLOSURE;
    int cRETURN;
    String functionId = "";
    int lexlinenumber;
    private int varSequence;

    Function() {
    }

    abstract void action();

    private Integer[] applyCallMAP(String k) {
        Integer[] x = this.callMAP.get(k);
        return null == x ? EMPTY_INT_ARRAY : x;
    }

    private Object callArgExpr(Object op) {
        return "(".equals(op) ? this.expression() : this.term();
    }

    Object[] callArgments() {
        ArrayList<Object> buf = new ArrayList<Object>();
        while ("(".equals(this.tok) && !this.yyHasLEFTSPACE || "{".equals(this.tok)) {
            Object op = this.tok;
            this.eat(this.tok);
            if (!rxENDLIST.find(this.tok)) {
                buf.add(this.callArgExpr(op));
                while (",".equals(this.tok)) {
                    this.eat(this.tok);
                    buf.add(this.callArgExpr(op));
                }
            }
            if ((!"(".equals(op) || !")".equals(this.tok)) && (!"{".equals(op) || !"}".equals(this.tok))) continue;
            this.advance();
        }
        return buf.toArray();
    }

    Node.YyCall callStmt(String name) {
        return this.callStmtImpl(this.getFunctionId(name), this.callArgments());
    }

    Node.YyCall callStmtImpl(String id, Object[] args) {
        int typ;
        int rtyp;
        int parmlen;
        boolean hasVarArgs = false;
        int argslen = args.length;
        Node.Func x = this.functionMap.get(id);
        if (null != x) {
            parmlen = x.argsLength;
            rtyp = x.nType;
            if (0 < x.argsLength && Flags.isVarArgs(x.parm[x.argsLength - 1].nType)) {
                hasVarArgs = true;
            }
        } else {
            x = this.builtinMAP.get(id);
            if (null != x) {
                parmlen = x.argsLength;
                rtyp = x.nType;
                if (0 < x.argsLength && Flags.isVarArgs(x.parm[x.argsLength - 1].nType)) {
                    hasVarArgs = true;
                }
            } else {
                parmlen = argslen;
                rtyp = 524323;
            }
        }
        Integer[] cald = this.applyCallMAP(id);
        int caldlen = cald.length;
        Integer[] arr = new Integer[hasVarArgs ? parmlen : Math.max(argslen, caldlen)];
        int len = arr.length;
        for (int i = 0; len > i; ++i) {
            int t3;
            int t1 = caldlen > i ? cald[i] : 524323;
            int m1 = t1 & 0x1F;
            int t2 = argslen > i ? Type.getNodeType(args[i]) : t1;
            int m2 = t2 & 0x1F;
            int n = t3 = m1 == m2 ? t2 : Function.checkType(t2, t1);
            if (524323 == t1 && 524323 == t2) {
                t3 = 31;
            } else if (Flags.isArray(t3) && argslen > i) {
                if (args[i] instanceof Node.NAME) {
                    int typ2 = Symbols.getType(((Node.NAME)args[i]).name);
                    if (Flags.isArray(typ2)) {
                        t3 = typ2;
                    }
                } else {
                    t3 &= 0xFFFFFBFF;
                }
            }
            arr[i] = t3 & 0xFFFFBFFF;
        }
        if ("split".equals(id)) {
            typ = 17439;
            Function.updateType((Node.YyVariable)args[1], typ, typ);
        } else if (2 < args.length && ("gsub".equals(id) || "sub".equals(id))) {
            typ = 20480;
            Function.updateType((Node.YyVariable)args[2], typ, typ);
        }
        this.callMAP.put(id, arr);
        return new Node.Call(id, args, rtyp);
    }

    Node.Root functionDecl() {
        String fullname;
        boolean isAnonymous;
        String name;
        Object x;
        if (this.tok instanceof Node.NAME) {
            x = (Node.NAME)this.tok;
            this.advance();
            name = x.name;
            isAnonymous = false;
        } else if (this.tok instanceof Keyword) {
            x = (Keyword)((Object)this.tok);
            this.advance();
            name = Keyword.toName((Keyword)((Object)x));
            isAnonymous = false;
        } else {
            name = this.makeAnonymousName();
            isAnonymous = true;
        }
        this.functionId = fullname = Symbols.startLocal(this.makeFunctionId(name));
        Object[] backup = this.unloadBuffer();
        this.functionDeclImpl(fullname);
        this.restoreBuffer(backup);
        this.functionId = Symbols.endLocal(fullname);
        if (!fullname.equals(name)) {
            this.gen(new Node.FnI(fullname));
        }
        return isAnonymous ? new Node.Call(fullname, EMPTY_ARRAY, Symbols.getType(fullname)) : new Node.FnI(fullname);
    }

    private void functionDeclImpl(String name) {
        String[] anno = this.yyAnnotation.moveArray();
        LexArray<Node.FnP> parm = new LexArray<Node.FnP>();
        int linenumber = this.yyLexNumber;
        Symbols.setLocalDefMode(true);
        boolean hasLength = false;
        int callPrmlen = 0;
        while ("(".equals(this.tok)) {
            this.eat(this.tok);
            if (!rxENDLIST.find(this.tok)) {
                boolean hasNext = true;
                while (hasNext) {
                    Object o = this.term();
                    if (o instanceof Node.YyVariable) {
                        Node.YyVariable x = (Node.YyVariable)o;
                        TypeHelper.T4Types rr = this.optType(x.name, false);
                        int typ = rr.nType;
                        String sType = rr.sType;
                        parm.add(new Node.FnP(x.name, typ, sType));
                    }
                    if (",".equals(this.tok)) {
                        this.eat(this.tok);
                        continue;
                    }
                    hasNext = false;
                }
            }
            this.eat(")");
            if (hasLength) continue;
            hasLength = true;
            callPrmlen = parm.size();
        }
        TypeHelper.T4Types rr = this.optType(name, false);
        int typ = rr.nType;
        String sType = rr.sType;
        Symbols.setLocalDefMode(false);
        int parmlen = parm.size();
        int plen = hasLength ? callPrmlen : parmlen;
        String[] comment = this.getCommentArray();
        if (";".equals(this.tok)) {
            this.eat(this.tok);
            this.nl();
            Node.FnP[] fnp = parm.toArray(new Node.FnP[parmlen]);
            this.builtinMAP.put(name, new Node.Func(name, fnp, plen, typ, sType, comment, anno, EMPTY_ARRAY));
        } else {
            Object[] backup = this.unloadBuffer();
            int closureCount = this.cCLOSURE;
            int returnCount = this.cRETURN;
            this.action();
            for (int i = 0; parmlen > i; ++i) {
                Node.FnP x = (Node.FnP)parm.get(i);
                int t1 = Symbols.getType(x.name);
                int w = 524323 == x.nType ? t1 : x.nType;
                w = Function.checkType(w, t1);
                parm.set(i, new Node.FnP(x.name, w, x.sType));
            }
            Object[] stmt = this.unloadBuffer();
            this.restoreBuffer(backup);
            int x = Symbols.getType(name);
            int ntype = 524323 == x ? 16 : x;
            closureCount = this.cCLOSURE - closureCount;
            this.cCLOSURE -= closureCount;
            if (0 < closureCount) {
                ntype |= 0x10000;
            }
            returnCount = this.cRETURN - returnCount;
            this.cRETURN -= returnCount;
            if (1 < returnCount) {
                ntype |= 0x20000;
            }
            Advance.yyLineNumber(linenumber);
            Node.FnP[] fnp = parm.toArray(new Node.FnP[parmlen]);
            this.functionMap.put(name, new Node.Func(name, fnp, plen, ntype, sType, comment, anno, stmt));
        }
    }

    void gen(Object x) {
        this.codeBuf.add(x);
    }

    String getFunctionId(String name) {
        String k = this.makeFunctionId(name);
        if (name.equals(this.functionId) || k.equals(this.functionId) || this.functionMap.containsKey(k) || this.builtinMAP.containsKey(k)) {
            return k;
        }
        if (0 <= name.indexOf(46)) {
            return name;
        }
        String[] parts = RX_DOLLAR_SPLIT.split(this.functionId);
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part).append('$');
            String key = sb.append(name).toString();
            if (this.functionMap.containsKey(key)) {
                return key;
            }
            sb.setLength(sb.length() - name.length());
        }
        return name;
    }

    boolean hasFunction(String name) {
        String id = this.getFunctionId(name);
        return this.builtinMAP.containsKey(id) || this.functionMap.containsKey(id);
    }

    Node.Invoke invokeStmt(Keyword id, String name) {
        String method;
        Object obj;
        String[] parts = RX_DOT_SPLIT.split(name);
        parts[parts.length - 1] = this.getFunctionId(parts[parts.length - 1]);
        if (2 == parts.length && Symbols.findType(parts[0])) {
            if (Symbols.isClosure(parts[0])) {
                ++this.cCLOSURE;
            }
            obj = new Node.NAME(Keyword.SyyNAME, parts[0]);
            method = parts[1];
        } else if (1 < parts.length) {
            obj = new Term.BOXING(RX_METHOD_NAME.matcher(name).replaceFirst(""));
            method = parts[parts.length - 1];
        } else {
            obj = new Term.BOXING("");
            method = parts[parts.length - 1];
        }
        return this.invokeStmtImpl(id, obj, method);
    }

    Node.Invoke invokeStmtImpl(Keyword id, Object obj, String method) {
        String sType;
        int type;
        Object[] args = EMPTY_ARRAY;
        boolean isMethod = false;
        if ("(".equals(this.tok)) {
            args = this.parenlist();
            isMethod = true;
        }
        if (":".equals(this.tok) && this.yyText.startsWith(":")) {
            TypeHelper.T4Types rr = this.optType(obj + "." + method, false);
            type = rr.nType;
            sType = rr.sType;
        } else {
            type = 31;
            sType = "";
        }
        if (obj.toString().isEmpty()) {
            this.callStmtImpl(method, args);
        }
        return new Node.Invoke(id, obj, method, args, type, sType, isMethod);
    }

    private String makeAnonymousName() {
        return "_anon" + ++this.varSequence + "_";
    }

    private String makeFunctionId(String name) {
        if (this.functionId.isEmpty() || name.equals(this.functionId)) {
            return name;
        }
        String x = "$" + name;
        return this.functionId.endsWith(x) ? this.functionId : this.functionId + x;
    }

    void restoreBuffer(Object[] a) {
        this.codeBuf.clear();
        this.codeBuf.addAll(Arrays.asList(a));
        Advance.yyLineNumber(this.lexlinenumber);
    }

    abstract Object term();

    Object[] unloadBuffer() {
        Object[] x = this.codeBuf.toArray();
        this.codeBuf.clear();
        return x;
    }

    void updateFunctionDef() {
        for (Map.Entry<String, Node.Func> e : this.functionMap.entrySet()) {
            String k = e.getKey();
            Node.Func x = e.getValue();
            Advance.yyLineNumber(x.linenumber);
            this.yyLexColumn = 0;
            boolean hasCall = this.callMAP.containsKey(k);
            Integer[] cald = this.applyCallMAP(k);
            int caldlen = cald.length;
            int parmlen = x.parm.length;
            Node.FnP[] arr = new Node.FnP[parmlen];
            for (int i = 0; parmlen > i; ++i) {
                int typ;
                int t1 = caldlen > i ? cald[i] : 524323;
                int t2 = x.parm[i].nType;
                int n = typ = 524323 == t2 ? t1 : t2;
                if (524323 == typ && x.argsLength <= i) {
                    this.yyINFOMATION("uninitialized Function Parameter: " + k + "( " + x.parm[i].name + " )");
                }
                arr[i] = new Node.FnP(x.parm[i].name, typ, x.parm[i].sType);
            }
            int siz = parmlen == x.argsLength ? (hasCall && parmlen != caldlen ? caldlen : x.argsLength) : x.argsLength;
            this.functionMap.put(k, new Node.Func(k, arr, siz, x.nType, x.sType, x.comment, x.annotation, x.stmt));
            assert (parmlen >= caldlen);
        }
    }
}

