/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import plus.lex.Advance;
import plus.lex.Keyword;

public final class Node {
    public static final String BOOL_OP = "?";
    public static final String CONCAT_OP = "cat_";
    public static final String INDEX_OP = "INDEX";
    public static final String NOT_OP = "!";
    public static final String NUMBER_OP = "NUMBER";

    private Node() {
    }

    public static String mkString(Object x) {
        return x instanceof Object[] ? Arrays.toString((Object[])x) : x.toString();
    }

    public static abstract class YyeValue
    extends Root {
        public final String name;
        public final int nType;

        YyeValue(@NotNull String name, int type) {
            if (name == null) {
                YyeValue.$$$reportNull$$$0(0);
            }
            super(true);
            this.name = name;
            this.nType = type;
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$YyeValue", "<init>"));
        }
    }

    public static abstract class YyVariable
    extends Root {
        public final Keyword id;
        public final Object[] index;
        public String name;

        YyVariable(Keyword x, @NotNull String name, Object[] idx) {
            if (name == null) {
                YyVariable.$$$reportNull$$$0(0);
            }
            super(true);
            this.id = x;
            this.name = name;
            this.index = idx;
        }

        public String toString() {
            return 0 == this.index.length ? this.name : this.name + Arrays.toString(this.index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$YyVariable", "<init>"));
        }
    }

    public static abstract class YyStatement
    extends Root {
        public final Keyword id;

        YyStatement(Keyword x) {
            super(false);
            this.id = x;
        }
    }

    public static abstract class YyNop
    extends Root {
        public final String value;

        YyNop(String val) {
            super(true);
            this.value = val;
        }
    }

    public static abstract class YyCall
    extends Root {
        public final Object[] args;
        public final Keyword id;
        public final String name;
        public final int nType;

        YyCall(Keyword x, @NotNull String name, @NotNull Object[] args, int ntype) {
            if (name == null) {
                YyCall.$$$reportNull$$$0(0);
            }
            if (args == null) {
                YyCall.$$$reportNull$$$0(1);
            }
            super(true);
            this.id = x;
            this.name = name;
            this.args = args;
            this.nType = ntype;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "args";
                    break;
                }
            }
            objectArray[1] = "plus/lex/Node$YyCall";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class While
    extends YyStatement {
        public final Object cc;
        public final Object[] stmt;

        public While(Keyword x, Object c, Object[] statement) {
            super(x);
            this.cc = c;
            this.stmt = statement;
        }

        public final String toString() {
            return this.id + "(" + this.cc + "," + Arrays.toString(this.stmt) + ")";
        }
    }

    public static class Try
    extends YyStatement {
        public final Object[] e1;
        public final Catch[] e2;
        public final Object[] e3;

        public Try(Object[] ex1, Catch[] ex2, Object[] ex3) {
            super(Keyword.SymTRY);
            this.e1 = ex1;
            this.e2 = ex2;
            this.e3 = ex3;
        }

        public final String toString() {
            return "try(" + Arrays.toString(this.e1) + Arrays.toString(this.e2) + Arrays.toString(this.e3) + ")";
        }
    }

    public static class Throw
    extends YyStatement {
        public final Object expr;

        public Throw(Object expr) {
            super(Keyword.SymTHROW);
            this.expr = expr;
        }

        public final String toString() {
            return "throw(" + this.expr + ")";
        }
    }

    public static class Stmt
    extends YyStatement {
        public final Object e;
        public final int nType;

        public Stmt(Keyword x, Object expr, int ntype) {
            super(x);
            this.e = expr;
            this.nType = ntype;
        }

        public final String toString() {
            return this.id.name() + " " + this.e;
        }
    }

    public static abstract class Root {
        public final boolean isEexpression;
        public final int linenumber = Advance.yyLineNumber();

        Root(boolean b) {
            this.isEexpression = b;
        }
    }

    public static class Print
    extends YyStatement {
        public final String name;
        public final Object[] args;
        public final String rid;
        public final Object filename;

        public Print(@NotNull String name, Object[] args, String rId, Object fileName) {
            if (name == null) {
                Print.$$$reportNull$$$0(0);
            }
            super(Keyword.SyyCALL);
            this.name = name;
            this.args = args;
            this.rid = rId;
            this.filename = fileName;
        }

        public final String toString() {
            return this.name + "(" + Arrays.toString(this.args) + ": `" + this.rid + "`" + this.filename + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$Print", "<init>"));
        }
    }

    public static class NAME
    extends YyVariable {
        private static final Object[] EMPTY_INDEX = new Object[0];

        public NAME(Keyword type, String name) {
            super(type, name, EMPTY_INDEX);
        }

        @Override
        public final String toString() {
            return this.name;
        }
    }

    public static class Invoke
    extends YyCall {
        public final Object obj;
        public final String sType;
        public final boolean isMethod;

        public Invoke(Keyword id2, Object o, String name, Object[] args, int ntype, String stype, boolean isMethod) {
            super(id2, name, args, ntype);
            this.obj = o;
            this.sType = stype;
            this.isMethod = isMethod;
        }

        public final String toString() {
            Object x = this.obj instanceof Object[] ? Arrays.toString((Object[])this.obj) : this.obj;
            return this.id + " " + x + "." + this.name + Arrays.toString(this.args);
        }
    }

    public static class If
    extends YyStatement {
        public final Object cc;
        public final Object[] left;
        public final Object[] right;

        public If(Keyword x, Object c, Object[] left, Object[] right) {
            super(x);
            this.cc = c;
            this.left = left;
            this.right = right;
        }

        public final String toString() {
            String w = Keyword.SymIF == this.id ? "if(" + this.cc + ")" : "(" + this.cc + ")?";
            return w + Arrays.toString(this.left) + "," + Arrays.toString(this.right);
        }
    }

    public static class Getline
    extends YyCall {
        private static final Object[] $0 = new Object[]{new Arr("$", new Integer[]{0})};
        public final String rid;
        public final Object filename;

        public Getline(Object[] args, String rId, Object file) {
            super(Keyword.SyyCALL, "getline", 0 == args.length ? $0 : args, 33);
            this.rid = rId;
            this.filename = file;
        }

        public final String toString() {
            return this.name + "(" + Arrays.toString(this.args) + ": '" + this.rid + "'" + this.filename + ")";
        }
    }

    public static class ForIn
    extends YyStatement {
        public final YyVariable e1;
        public final Object e2;
        public final Object[] stmt;

        public ForIn(Keyword x, YyVariable expr1, Object expr2, Object[] statement) {
            super(x);
            this.e1 = expr1;
            this.e2 = expr2;
            this.stmt = statement;
        }

        public final String toString() {
            return this.id + "((" + this.e1 + " in " + this.e2 + ")" + Arrays.toString(this.stmt) + ")";
        }
    }

    public static class For
    extends YyStatement {
        public final Object e1;
        public final Object e2;
        public final Object e3;
        public final Object[] stmt;

        public For(Keyword x, Object expr1, Object expr2, Object expr3, Object[] statement) {
            super(x);
            this.e1 = expr1;
            this.e2 = expr2;
            this.e3 = expr3;
            this.stmt = statement;
        }

        public final String toString() {
            return this.id + "((" + this.e1 + ";" + this.e2 + ";" + this.e3 + ")" + Arrays.toString(this.stmt) + ")";
        }
    }

    public static class FnP
    extends YyStatement {
        public final String name;
        public final int nType;
        public final String sType;

        public FnP(@NotNull String name, int ntype, String stype) {
            if (name == null) {
                FnP.$$$reportNull$$$0(0);
            }
            super(Keyword.SyyFNP);
            this.name = name;
            this.nType = ntype;
            this.sType = stype;
        }

        public final String toString() {
            return this.name + ":" + (this.sType.isEmpty() ? Integer.toHexString(this.nType) : this.sType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$FnP", "<init>"));
        }
    }

    public static class FnI
    extends YyStatement {
        public final String name;

        public FnI(@NotNull String fullname) {
            if (fullname == null) {
                FnI.$$$reportNull$$$0(0);
            }
            super(Keyword.SyyFNI);
            this.name = fullname;
        }

        public final String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullname", "plus/lex/Node$FnI", "<init>"));
        }
    }

    public static class Func
    extends YyStatement {
        public final String[] comment;
        public final String[] annotation;
        public final String name;
        public final FnP[] parm;
        public final int argsLength;
        public final int nType;
        public final String sType;
        public final Object[] stmt;

        public Func(@NotNull String name, FnP[] param, int length, int ntype, String stype, String[] comm, String[] anno, Object[] statement) {
            if (name == null) {
                Func.$$$reportNull$$$0(0);
            }
            super(Keyword.SyyFN);
            this.name = name;
            this.parm = param;
            this.argsLength = length;
            this.nType = ntype;
            this.sType = stype;
            this.comment = comm;
            this.annotation = anno;
            this.stmt = statement;
        }

        public final String toString() {
            return this.name + "(" + Arrays.toString(this.parm) + "," + this.argsLength + "," + this.nType + "," + Arrays.toString(this.stmt) + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$Func", "<init>"));
        }
    }

    public static class Del
    extends YyStatement {
        public final YyVariable e;

        public Del(YyVariable expr) {
            super(Keyword.SymDELETE);
            this.e = expr;
        }

        public final String toString() {
            return "delete(" + this.e + ")";
        }
    }

    public static class Calc
    extends YyeValue {
        public final Object left;
        public final Object right;

        public Calc(String name, Object left, Object right) {
            super(name, 1);
            this.left = left;
            this.right = right;
        }

        @Override
        public final String toString() {
            return "(" + (this.left instanceof Object[] ? Arrays.toString((Object[])this.left) : this.left) + " " + this.name + " " + (this.right instanceof Object[] ? Arrays.toString((Object[])this.right) : this.right) + ")";
        }
    }

    public static class IncDec
    extends YyeValue {
        public final Object expr;

        public IncDec(String name, Object exp) {
            super(name, 1);
            this.expr = exp;
        }

        @Override
        public final String toString() {
            return this.name + "(" + this.expr + ")";
        }
    }

    public static class Catch
    extends YyStatement {
        public final String name;
        public final String[] claz;
        public final Object[] stmt;

        public Catch(@NotNull String name, String[] claz, Object[] statement) {
            if (name == null) {
                Catch.$$$reportNull$$$0(0);
            }
            super(Keyword.SymCATCH);
            this.name = name;
            this.claz = claz;
            this.stmt = statement;
        }

        public final String toString() {
            return "catch " + Arrays.toString(this.claz) + Arrays.toString(this.stmt);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "plus/lex/Node$Catch", "<init>"));
        }
    }

    public static class Call
    extends YyCall {
        public Call(String name, Object[] args, int ntype) {
            super(Keyword.SyyCALL, name, args, ntype);
        }

        public final String toString() {
            return this.name + Arrays.toString(this.args);
        }
    }

    public static class Comp
    extends YyeValue {
        public final Object left;
        public final Object right;

        public Comp(String name, Object left, Object right) {
            super(name, 17);
            this.left = left;
            this.right = right;
        }

        @Override
        public final String toString() {
            return "(" + this.left + " " + this.name + " " + this.right + ")";
        }
    }

    public static class B00l
    extends YyeValue {
        public final Object expr;

        public B00l(String name, Object exp) {
            super(name, 17);
            this.expr = exp;
        }

        @Override
        public final String toString() {
            return this.name + "(" + Node.mkString(this.expr) + ")";
        }
    }

    public static class Ass
    extends YyStatement {
        public final String sType;
        public final int nType;
        public final YyVariable left;
        public final Object right;
        public String name;

        public Ass(Keyword id, String op, YyVariable left, Object right, int ntype, String stype) {
            super(id);
            this.name = op;
            this.left = left;
            this.right = right;
            this.nType = ntype;
            this.sType = stype;
        }

        public final String toString() {
            return "(" + this.id + " " + this.left + " " + this.name + " " + this.right + ")";
        }
    }

    public static class Arr
    extends YyVariable {
        public Arr(String name, Object[] idx) {
            super(Keyword.SyyARRAY, name, idx);
        }

        @Override
        public final String toString() {
            return this.name + Arrays.toString(this.index);
        }
    }

    public static class Comment
    extends YyNop {
        public Comment(String val) {
            super(val);
        }
    }

    public static class Annotation
    extends YyNop {
        public Annotation(String val) {
            super(val);
        }

        public final String toString() {
            return this.value;
        }
    }
}

