/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.util;

import java.util.Arrays;

/**
 * [%helper%] Debug Helper.
 *
 * @author kunio himei.
 */
public final class Debug {

    /**
     * Thread dump.
     */
    public static void dumpThread() {
        Thread[] arr = new Thread[Thread.activeCount()];
        Thread.enumerate(arr);
        System.err.println(Arrays.deepToString(arr));
    }

    /**
     * オブジェクト属性の文字列を返す.
     */
    public static String objectOf(Object x) {
        StringBuilder buf = new StringBuilder();
        if (null == x) {
            buf.append("'null'");
        } else {
            buf.append(x.getClass().getName()).append(' ');
            if (x instanceof String s) {
                if (s.isEmpty()) {
                    buf.append("\"\"");
                } else {
                    buf.append('"').append(s).append("\" ");
                    for (int i = 0, len = s.length(); len > i; i++) {
                        buf.append((0 == i) ? "" : ":");
                        buf.append(Integer.toHexString(s.charAt(i)));
                    }
                }
            } else if (x instanceof Object[]) {
                buf.append(Arrays.deepToString((Object[]) x));
            } else {
                buf.append('`').append(x).append('`');
            }
        }
        return buf.toString();
    }
}