/*
 * Decompiled with CFR 0.152.
 */
package plus.variable;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import plus.concurrent.AtomicMap;
import plus.concurrent.AtomicNumber;
import plus.eval.EvalVar;
import plus.util.NumHelper;

public final class Frame {
    private static final Frame singleton = new Frame();
    private static final String EMPTY_VALUE = null;
    public static final AtomicMap GLOBALS = new AtomicMap();
    private static final ThreadLocal<AtomicMap> CLOSURE = ThreadLocal.withInitial(AtomicMap::new);
    private static final ThreadLocal<AtomicMap> LOCAL = ThreadLocal.withInitial(AtomicMap::new);
    private static final ThreadLocal<ArrayList<AtomicMap>> CLOSURESTACK = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<ArrayList<AtomicMap>> LOCALSTACK = ThreadLocal.withInitial(ArrayList::new);
    private final ReentrantLock Var = new ReentrantLock();
    private final ReentrantLock RefVar = new ReentrantLock();

    public static Frame getInstance() {
        return singleton;
    }

    private Frame() {
    }

    public static void cleanup() {
        CLOSURE.get().clear();
        LOCAL.get().clear();
        CLOSURESTACK.get().clear();
        LOCALSTACK.get().clear();
    }

    private static AtomicMap find(String name, AtomicMap undefined, AtomicMap ... container) {
        for (AtomicMap map : container) {
            if (!map.containsKey(name)) continue;
            return map;
        }
        return undefined;
    }

    private static Map<?, ?> getArray(String name, AtomicMap frame) {
        Object x = frame.get(name);
        if (x instanceof Map) {
            return (Map)x;
        }
        AtomicMap arr = new AtomicMap();
        frame.put(name, arr);
        return arr;
    }

    private static void updateStack(String name, Object x) {
        if (null == x) {
            throw new NullPointerException(name);
        }
        for (AtomicMap map : LOCALSTACK.get()) {
            if (null != map.replace(name, x)) break;
        }
        for (AtomicMap map : CLOSURESTACK.get()) {
            if (null != map.replace(name, x)) break;
        }
    }

    private static Object calculate(AtomicMap frame, Object index, String op, Object value) {
        String k = (String)frame.arrayKey(index);
        if ("=".equals(op)) {
            frame.put(k, value);
            return value;
        }
        Object x = frame.get(k);
        if (x == null || x.equals("")) {
            x = 0;
        }
        if (x instanceof Number && value instanceof Number) {
            if (!(x instanceof AtomicNumber)) {
                x = EvalVar._cloneAtom(x);
                frame.put(k, x);
            }
            return ((AtomicNumber)x).calculate(op, value);
        }
        throw new IllegalArgumentException(x + " " + op + " " + value);
    }

    public static Object _putLocalVar(String name, Object value) {
        Object x = Frame.modValue(value);
        LOCAL.get().put(name, x);
        return value;
    }

    private static Object modValue(Object value) {
        return value;
    }

    private static Object modGet(Map<?, ?> map, Object index) {
        if (map.containsKey(index)) {
            return map.get(index);
        }
        return null;
    }

    public static AtomicMap _cloneLocalContext() {
        return new AtomicMap(LOCAL.get());
    }

    public static void _endLocal() {
        AtomicMap closure = CLOSURE.get();
        closure.clear();
        closure.putAll(CLOSURESTACK.get().remove(0));
        AtomicMap local = LOCAL.get();
        local.clear();
        local.putAll(LOCALSTACK.get().remove(0));
    }

    public static void _startBlockContext() {
        CLOSURE.get().clear();
        CLOSURESTACK.get().clear();
        LOCAL.get().clear();
        LOCALSTACK.get().clear();
    }

    public static void _startNewContext(AtomicMap context) {
        CLOSURE.get().putAll(context);
    }

    public static void _startLocal() {
        AtomicMap closure = CLOSURE.get();
        CLOSURESTACK.get().add(0, new AtomicMap(closure));
        AtomicMap local = LOCAL.get();
        closure.putAll(local);
        LOCALSTACK.get().add(0, new AtomicMap(local));
        local.clear();
    }

    public Map<?, ?> _allocArray(String name) {
        AtomicMap frame = Frame.find(name, GLOBALS, LOCAL.get(), CLOSURE.get());
        assert (null != frame);
        return Frame.getArray(name, frame);
    }

    public void _allocLocalArray(String name, String oldkey) {
        Map<Object, Object> arr = null != oldkey ? this._allocArray(oldkey) : new AtomicMap();
        LOCAL.get().put(name, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _getAt(String name, Object index) {
        this.Var.lock();
        try {
            Object x = null;
            AtomicMap frame = Frame.find(name, null, LOCAL.get(), CLOSURE.get(), GLOBALS);
            if (null != frame) {
                x = Frame.modGet(frame, name);
                if (null != index) {
                    if (x instanceof Object[]) {
                        Object[] arr = (Object[])x;
                        int ix = NumHelper.intValue(index);
                        x = arr.length > ix ? arr[ix] : EMPTY_VALUE;
                    } else {
                        Map arr;
                        if (!(x instanceof AtomicMap)) {
                            x = this._allocArray(name);
                        }
                        x = (arr = (Map)x).containsKey(index) ? Frame.modGet(arr, index) : ("$".equals(name) ? EMPTY_VALUE : arr.get(index));
                    }
                }
            }
            Map<?, ?> map = x;
            return map;
        }
        finally {
            this.Var.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _putAt(String op, String name, Object index, Object value) {
        this.Var.lock();
        try {
            Object x;
            AtomicMap closure = CLOSURE.get();
            AtomicMap frame = Frame.find(name, GLOBALS, LOCAL.get(), closure);
            if (null == frame) {
                throw new IllegalStateException("NoSuchVariableException: " + name);
            }
            if (null != index) {
                Map<?, ?> arr = frame.getAt(name);
                if (!(arr instanceof AtomicMap)) {
                    arr = this._allocArray(name);
                }
                x = Frame.calculate((AtomicMap)arr, index, op, value);
            } else if ("=".equals(op) && !frame.containsKey(name)) {
                Object val = Frame.modValue(value);
                frame.put(name, val);
                x = value;
            } else {
                x = Frame.calculate(frame, name, op, value);
            }
            if (closure == frame) {
                assert (null != x);
                Frame.updateStack(name, x);
            }
            Object object = x;
            return object;
        }
        finally {
            this.Var.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _getRefVar(String name, Object index) {
        this.RefVar.lock();
        try {
            Object x;
            AtomicMap closure = CLOSURE.get();
            AtomicMap frame = Frame.find(name, null, closure, GLOBALS);
            if (null == frame) {
                throw new IllegalStateException("NoSuchVariableException: " + name);
            }
            if (null != index) {
                Map<?, ?> arr = Frame.getArray(name, frame);
                x = arr.get(index);
            } else {
                x = frame.getAt(name);
            }
            Object object = x;
            return object;
        }
        finally {
            this.RefVar.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _putRefVar(String name, Object index, Object value) {
        this.RefVar.lock();
        try {
            Object x;
            AtomicMap closure = CLOSURE.get();
            AtomicMap frame = Frame.find(name, null, closure, GLOBALS);
            if (null == frame) {
                throw new IllegalStateException("NoSuchVariableException: " + name);
            }
            if (null != index) {
                Map<?, ?> arr = Frame.getArray(name, frame);
                x = arr.put(index, value);
            } else {
                x = frame.put(name, value);
                if (closure == frame) {
                    assert (null != x);
                    Frame.updateStack(name, x);
                }
            }
            Object object = x;
            return object;
        }
        finally {
            this.RefVar.unlock();
        }
    }

    public void _remove(String name, Object index) {
        Map<?, ?> arr = this._allocArray(name);
        if (null != index) {
            arr.remove(index);
        } else {
            arr.clear();
        }
    }
}

