/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import plus.io.Device;
import plus.io.Io;
import plus.io.IoHelper;
import plus.spawn.Helper;
import plus.spawn.system.UtilInterface;

public final class Cat
extends FilterWriter
implements UtilInterface {
    private static final Pattern RX_TAB = Pattern.compile("\t");
    private static final String USAGE = "Usage: cat [OPTION] [FILE]...\nConcatenate FILE(s), or standard input, to standard output.\n\n  -b    number nonblank output lines\n  -n    number all output lines\n  -s    never more than one single blank line\n  -T    display TAB characters as ^I\n  -u    The output is not buffered.\n      --help      display this help and exit (should be alone)\n\nWith no FILE, or when FILE is -, read standard input.";
    private final boolean hasAutoFlush;
    private final AtomicBoolean hasBlankLine;
    private final AtomicInteger hasNumberLines;
    private final boolean hasNumberNonblank;
    private final boolean hasShowTab;
    private final ConcurrentLinkedQueue<String> inputFiles = new ConcurrentLinkedQueue();

    public Cat(String[] args, Writer output) {
        super(output);
        StringBuilder flags = new StringBuilder();
        for (String arg : args) {
            char c = arg.charAt(0);
            if ('-' == c) {
                if (1 == arg.length()) {
                    this.inputFiles.add("-");
                    continue;
                }
                flags.append(arg.substring(1));
                continue;
            }
            this.inputFiles.add(Helper.filename(arg));
        }
        this.hasNumberNonblank = 0 <= flags.indexOf("b");
        this.hasNumberLines = this.hasNumberNonblank || 0 <= flags.indexOf("n") ? new AtomicInteger() : null;
        this.hasBlankLine = 0 <= flags.indexOf("s") ? new AtomicBoolean(false) : null;
        this.hasShowTab = 0 <= flags.indexOf("T");
        boolean bl = this.hasAutoFlush = 0 > flags.indexOf("u");
        if (0 <= flags.indexOf("v")) {
            StringBuilder sb = new StringBuilder("`cat");
            if (0 < flags.length()) {
                sb.append(" -").append((CharSequence)flags);
            }
            if (!this.inputFiles.isEmpty()) {
                sb.append(' ').append(this.inputFiles);
            }
            System.err.println(sb.append('`'));
        }
    }

    public static void main(String[] args) throws IOException {
        if (0 != args.length && args[0].startsWith("--help")) {
            System.out.println(USAGE);
        } else {
            Cat me = new Cat(args, Device.openOutput("", "/dev/stdout"));
            if (me.hasInput()) {
                IoHelper.copyline("/dev/stdin", me);
            }
            me.close();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            String input = this.inputFiles.poll();
            while (null != input) {
                IoHelper.copyline(input, this);
                input = this.inputFiles.poll();
            }
        }
        catch (Throwable throwable) {
            Io.close(this.out);
            throw throwable;
        }
        Io.close(this.out);
    }

    @Override
    public int exitValue() {
        return 0;
    }

    @Override
    public boolean hasInput() {
        return this.inputFiles.isEmpty();
    }

    @Override
    public void write(@NotNull String x) throws IOException {
        String xx;
        if (x == null) {
            Cat.$$$reportNull$$$0(0);
        }
        String string = xx = this.hasShowTab ? RX_TAB.matcher(x).replaceAll("^I") : x;
        if (null == this.hasBlankLine && null == this.hasNumberLines) {
            super.write(xx);
            if (this.hasAutoFlush) {
                super.flush();
            }
        } else {
            String[] arr;
            for (String line : arr = Helper.split(xx)) {
                this.writeln(line);
            }
        }
    }

    private void writeln(String x) throws IOException {
        boolean hasSpace;
        boolean isSpace = x.isEmpty();
        boolean bl = hasSpace = null != this.hasBlankLine && this.hasBlankLine.getAndSet(isSpace);
        if (!isSpace || !hasSpace) {
            StringBuilder sb = new StringBuilder(x);
            if (!(null == this.hasNumberLines || isSpace && this.hasNumberNonblank)) {
                Integer lno = this.hasNumberLines.incrementAndGet();
                sb.insert(0, String.format("%6d\t", lno));
            }
            IoHelper.writeln(this.out, sb, this.hasAutoFlush);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "plus/spawn/Cat", "write"));
    }
}

