/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;
import plus.lex.Flags;

public final class Symbols {
    private static final Map<String, Integer> CLOSURE = new HashMap<String, Integer>();
    private static final int DEFAULT = 524323;
    private static final Integer DEFAULT_INT = 524323;
    private static final Map<String, Integer> FUNCTIONS = new HashMap<String, Integer>();
    private static final Map<String, Integer> GLOBAL = new HashMap<String, Integer>();
    private static final Map<String, Integer> LOCAL = new HashMap<String, Integer>();
    private static final Map<String, Integer> PREDEF = new HashMap<String, Integer>();
    private static final Stack<Map<String, Integer>> STACK_CLOSURE = new Stack();
    private static final Stack<String> STACK_FUNCTIONID = new Stack();
    private static final Stack<Map<String, Integer>> STACK_LOCAL = new Stack();
    private static boolean isLocalDefMode;

    private Symbols() {
    }

    public static Map<String, Integer> cleanGlobal() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (Map.Entry<String, Integer> e : GLOBAL.entrySet()) {
            Integer x = e.getValue();
            if (524323 == x) continue;
            map.put(e.getKey(), x);
        }
        return map;
    }

    public static void clearGlobal() {
        GLOBAL.clear();
    }

    public static void createType(String k) {
        if (isLocalDefMode) {
            if (!LOCAL.containsKey(k) && !PREDEF.containsKey(k)) {
                LOCAL.put(k, DEFAULT_INT);
            }
        } else if (!(GLOBAL.containsKey(k) || PREDEF.containsKey(k) || FUNCTIONS.containsKey(k))) {
            GLOBAL.put(k, DEFAULT_INT);
        }
    }

    public static void endBlock() {
        Symbols.endLocal();
    }

    private static void endLocal() {
        CLOSURE.clear();
        CLOSURE.putAll(STACK_CLOSURE.pop());
        LOCAL.clear();
        LOCAL.putAll(STACK_LOCAL.pop());
    }

    public static String endLocal(String name) {
        Symbols.endLocal();
        String x = STACK_FUNCTIONID.pop();
        assert (name.equals(x));
        return STACK_FUNCTIONID.isEmpty() ? "" : STACK_FUNCTIONID.peek();
    }

    @SafeVarargs
    @Nullable
    private static Map<String, Integer> find(String k, Map<String, Integer> ... con) {
        for (Map<String, Integer> x : con) {
            if (!x.containsKey(k)) continue;
            return x;
        }
        return null;
    }

    public static boolean findType(String k) {
        return -1 != Symbols.serch(k);
    }

    public static int getType(String k) {
        int x = Symbols.serch(k);
        if (-1 == x) {
            Symbols.dump();
            throw new IllegalStateException("UNDEFINED: '" + k + "'");
        }
        return x;
    }

    public static boolean isAtomic(String k) {
        Map<String, Integer> x = Symbols.find(k, LOCAL, CLOSURE, GLOBAL);
        return null != x && Flags.isAtomic(x.get(k));
    }

    public static boolean isClosure(String k) {
        return CLOSURE.containsKey(k) && !LOCAL.containsKey(k);
    }

    public static boolean isGlobal(String k) {
        return GLOBAL.containsKey(k);
    }

    public static boolean isIntPredefVar(String k) {
        return PREDEF.containsKey(k) && Flags.isInteger(PREDEF.get(k));
    }

    public static boolean isLocal(String k) {
        return LOCAL.containsKey(k);
    }

    public static boolean isPredef(String k) {
        return PREDEF.containsKey(k);
    }

    public static boolean isStringPredef(String k) {
        return PREDEF.containsKey(k) && Flags.isString(PREDEF.get(k));
    }

    public static void markGlobal(String k, int x) {
        GLOBAL.put(k, x);
    }

    public static void markLocal(String k, int x) {
        LOCAL.put(k, x);
    }

    public static void resetFunctionType(String k) {
        FUNCTIONS.put(k, DEFAULT_INT);
    }

    public static void resetLocalType(String k) {
        LOCAL.put(k, DEFAULT_INT);
    }

    private static int serch(String k) {
        Map<String, Integer> x = Symbols.find(k, FUNCTIONS, LOCAL, CLOSURE, GLOBAL, PREDEF);
        return null == x ? -1 : x.get(k);
    }

    public static void setLocalDefMode(boolean x) {
        isLocalDefMode = x;
    }

    public static int setType(String k, int typ, int orType) {
        if (FUNCTIONS.containsKey(k)) {
            return Symbols.setTypeImpl(k, typ, orType, FUNCTIONS);
        }
        if (LOCAL.containsKey(k)) {
            return Symbols.setTypeImpl(k, typ, orType, LOCAL);
        }
        if (GLOBAL.containsKey(k)) {
            return Symbols.setTypeImpl(k, typ, orType, GLOBAL);
        }
        return Symbols.getType(k);
    }

    private static int setTypeImpl(String k, int typ, int orType, Map<String, Integer> map) {
        int w;
        int x = map.get(k);
        int n = w = 524323 == x ? typ : x;
        if (524323 != w && x != (w |= orType)) {
            map.put(k, w);
        }
        return w;
    }

    public static void startBlock() {
        STACK_CLOSURE.push(new HashMap<String, Integer>(CLOSURE));
        CLOSURE.putAll(LOCAL);
        STACK_LOCAL.push(new HashMap<String, Integer>(LOCAL));
    }

    private static void startLocal() {
        STACK_CLOSURE.push(new HashMap<String, Integer>(CLOSURE));
        CLOSURE.putAll(LOCAL);
        STACK_LOCAL.push(new HashMap<String, Integer>(LOCAL));
        LOCAL.clear();
    }

    public static String startLocal(String name) {
        Symbols.startLocal();
        STACK_FUNCTIONID.push(name);
        if (!FUNCTIONS.containsKey(name)) {
            FUNCTIONS.put(name, DEFAULT_INT);
        }
        return name;
    }

    public static void dump() {
        System.err.println("## Symbols ##\n# FUNCTIONS." + FUNCTIONS + "\n# PREDEF." + PREDEF + "\n# GLOBAL." + GLOBAL + "\n# CLOSURE." + CLOSURE + "\n# LOCAL." + LOCAL);
        System.err.flush();
    }

    static {
        PREDEF.put("$", 1059);
        PREDEF.put("ARGC", 33);
        PREDEF.put("ARGIND", 33);
        PREDEF.put("ARGV", 1059);
        PREDEF.put("CONVFMT", 2);
        PREDEF.put("ENVIRON", 1026);
        PREDEF.put("ERRNO", 2);
        PREDEF.put("FIELDWIDTHS", 2);
        PREDEF.put("FILENAME", 35);
        PREDEF.put("FNR", 33);
        PREDEF.put("FS", 2);
        PREDEF.put("IGNORECASE", 33);
        PREDEF.put("NF", 33);
        PREDEF.put("NR", 33);
        PREDEF.put("OFMT", 2);
        PREDEF.put("OFS", 2);
        PREDEF.put("ORS", 2);
        PREDEF.put("RLENGTH", 33);
        PREDEF.put("RS", 2);
        PREDEF.put("RSTART", 33);
        PREDEF.put("RT", 2);
        PREDEF.put("SUBSEP", 2);
        PREDEF.put("PROCINFO", 1055);
        PREDEF.put("RESULT", 31);
        PREDEF.put("true", 17);
        PREDEF.put("false", 17);
        PREDEF.put("null", 31);
    }
}

