/*
 * Decompiled with CFR 0.152.
 */
package plus.concurrent;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class Futures {
    private static final ConcurrentHashMap<String, CyclicBarrier> BARRIER = new ConcurrentHashMap();

    private static Integer await(CyclicBarrier x) throws InterruptedException {
        try {
            return x.await();
        }
        catch (BrokenBarrierException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void await(String id) throws InterruptedException {
        CyclicBarrier lock = BARRIER.get(id);
        if (null != lock) {
            Futures.await(lock);
        }
    }

    public static boolean cancel(Object x) {
        boolean rs = false;
        for (Object o : Futures.toArray(x)) {
            if (!(o instanceof Future)) {
                throw new IllegalArgumentException(o.getClass().getName() + " " + o);
            }
            Future task = (Future)o;
            if (task.isDone() || task.isCancelled() || !task.cancel(true)) continue;
            rs = true;
        }
        return rs;
    }

    public static Object getValue(Object x) throws InterruptedException {
        if (x instanceof Future) {
            try {
                return ((Future)x).get();
            }
            catch (ExecutionException e) {
                Throwable ex = e;
                while (null != ex.getCause()) {
                    ex = ex.getCause();
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException(x.getClass().getName() + " " + x);
    }

    public static boolean isAlive(Object x) {
        for (Object o : Futures.toArray(x)) {
            if (o instanceof Future) {
                if (((Future)o).isDone()) continue;
                return true;
            }
            throw new IllegalArgumentException(o.getClass().getName() + " " + o);
        }
        return false;
    }

    public static boolean join(Object x) throws InterruptedException {
        boolean rs = false;
        for (Object o : Futures.toArray(x)) {
            if (o instanceof Future) {
                Futures.getValue(o);
                rs = true;
                continue;
            }
            if (o instanceof CyclicBarrier) {
                Futures.await((CyclicBarrier)o);
                rs = true;
                continue;
            }
            throw new IllegalArgumentException(o.getClass().getName() + " " + o);
        }
        return rs;
    }

    public static void pair(String id) {
        CyclicBarrier lock = BARRIER.get(id);
        if (null == lock) {
            CyclicBarrier x = new CyclicBarrier(2);
            BARRIER.putIfAbsent(id, x);
        }
    }

    private static Object[] toArray(Object x) {
        if (x instanceof Object[]) {
            return (Object[])x;
        }
        if (x instanceof Map) {
            return ((Map)x).values().toArray();
        }
        if (x instanceof List) {
            return ((List)x).toArray();
        }
        return new Object[]{x};
    }
}

