/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.ArrayList;
import plus.lex.Flags;
import plus.lex.Function;
import plus.lex.Keyword;
import plus.lex.LexRegx;
import plus.lex.Node;
import plus.lex.Symbols;
import plus.lex.T4Types;
import plus.lex.Term;
import plus.lex.Type;
import plus.util.NumHelper;

abstract class Expression
extends Function {
    private static final LexRegx rxADDOP = new LexRegx("^([-+])$");
    private static final LexRegx rxMULTIOP = new LexRegx("^([/%]|[*]{1,2})$");
    private static final LexRegx rxPOWEROP = new LexRegx("^([*]{2})$");
    private static final LexRegx rxRELATIVEOP = new LexRegx("^([!=]={1,2}|[<>]=?|[!]?~)$");
    private static final LexRegx rxANDOP = new LexRegx("^(&{1,2})$");
    private static final LexRegx rxOROP = new LexRegx("^([|]{1,2})$");
    private static final LexRegx rxREDIRECT = new LexRegx("^(<|>{1,2}|[|]&)");
    private static final LexRegx rxEXPR = new LexRegx("^(([-+/%]|[*]{1,2})|(<<|>{2,3})|[&|^]|`~|)=$");
    private static final LexRegx rxCONCATOP = new LexRegx("^([($]|[+][+]|--)$");
    private static final LexRegx rxHasGETLINE = new LexRegx("^\\s*getline");
    private static final LexRegx rxREADLINE = new LexRegx("^[<|>;)}\n]");
    private static final LexRegx rxUNARYOP = new LexRegx("^[-+!]$");
    int enableReAssign;
    boolean isGlobalDef;
    private int cPARENNEST;
    private boolean isGETLINESTAT;
    private boolean isPRINTSTAT;

    Expression() {
    }

    private static Object index(Object[] e) {
        if (0 == e.length) {
            return e;
        }
        if (1 < e.length) {
            return new Node.Call("INDEX", Type.castWrapArray(e), 2);
        }
        int typ = Type.getNodeType(e[0]);
        if (Flags.isNumber(typ) && !Flags.isStrNum(typ)) {
            Object object = e[0];
            if (object instanceof Term.NUMBER) {
                Term.NUMBER x = (Term.NUMBER)object;
                if (0.0 == x.doubleValue() - (double)((int)x.doubleValue())) {
                    return e;
                }
                return new Node.Call("INDEX", Type.castWrapArray(e), 2);
            }
            return new Node.Call("INDEX", Type.castWrapArray(e), 2);
        }
        return e;
    }

    private static boolean isEmptyNumber(Object[] a) {
        return 1 <= a.length && a[0] instanceof Term.NUMBER && ((Term.NUMBER)a[0]).id.isEmpty();
    }

    private Object addop() {
        Object e = this.multiop();
        while (rxADDOP.find(this.tok)) {
            String op = rxADDOP.group(1);
            this.eat(this.tok);
            Object x = this.multiop();
            if (x instanceof Term.NUMBER && "0".equals(((Term.NUMBER)x).id)) {
                if (Flags.isNumber(Type.getNodeType(e))) {
                    this.yyOPTIMIZE("addop: " + e + " (" + op + " 0)");
                    continue;
                }
                e = new Node.IncDec("NUMBER", e);
                continue;
            }
            if (e instanceof Term.NUMBER && "0".equals(((Term.NUMBER)e).id) && "+".equals(op)) {
                if (Flags.isNumber(Type.getNodeType(x))) {
                    this.yyOPTIMIZE("addop: (0 +) " + x);
                    e = x;
                    continue;
                }
                e = new Node.IncDec("NUMBER", x);
                continue;
            }
            e = new Node.Calc(op, e, x);
        }
        return e;
    }

    private Object andop() {
        Object e = this.relativeop();
        while (rxANDOP.find(this.tok)) {
            String op = rxANDOP.group(1);
            this.eat(this.tok);
            e = new Node.Comp(op, Expression.genCompare(e), Expression.genCompare(this.relativeop()));
        }
        return e;
    }

    private Node.Ass assignop(Keyword id, Node.YyVariable left, String sType) {
        String name = left.name;
        String op = "=".equals(this.tok) ? "=" : this.tok.toString().replaceFirst("=$", "");
        this.eat(this.tok);
        this.nl();
        if (this.tok instanceof Node.YyVariable && (Keyword.SymVAL == id || Keyword.SymVAR == id)) {
            if (!this.isGlobalDef) {
                Symbols.setLocalDefMode(true);
            }
            Symbols.createType(((Node.YyVariable)this.tok).name);
            if (!this.isGlobalDef) {
                Symbols.setLocalDefMode(false);
            }
        }
        Object ex = this.orop();
        if (Keyword.SymVAL != id) {
            int typ;
            if (Keyword.SymVAR == id && 0 != this.enableReAssign) {
                Symbols.resetLocalType(name);
            }
            if (524323 != (typ = Symbols.getType(name)) && 0 != (typ & 0x2000) && 0 == (typ & 0x8000)) {
                throw new IllegalStateException("ERROR: reassignment to val `" + name + "`");
            }
        }
        int vType = 0 != this.enableReAssign && Keyword.SymVAL == id ? 40960 : (0 != this.enableReAssign && Keyword.SymVAR == id ? 32768 : 0);
        Object right = this.assignType("VAR " + op, name, ex, 0x4000 | vType);
        if (rxEXPR.find(this.tok)) {
            return new Node.Ass(id, op, left, this.assignop(id, (Node.YyVariable)ex, sType), Symbols.getType(name), sType);
        }
        return new Node.Ass(id, op, left, right, Symbols.getType(name), sType);
    }

    private Object concatop() {
        Object e = this.addop();
        assert (null != this.tok);
        if ('|' == this.tok.toString().charAt(0) && rxHasGETLINE.find(this.yyText)) {
            String op = this.tok.toString();
            this.eat(this.tok);
            this.eat((Object)Keyword.SymGETLINE);
            e = this.getlineStmt(e, op);
        }
        if (!(e instanceof String) && this.isConcat()) {
            ArrayList<Object> buf = new ArrayList<Object>();
            if (!(e instanceof Term.STRING) || 0 != ((Term.STRING)e).id.length()) {
                buf.add(e);
            }
            while (this.isConcat()) {
                Object x = this.addop();
                if (x instanceof Term.STRING && 0 == ((Term.STRING)x).id.length()) continue;
                if ('|' == this.tok.toString().charAt(0) && rxHasGETLINE.find(this.yyText)) {
                    String op = this.tok.toString();
                    this.eat(this.tok);
                    this.eat((Object)Keyword.SymGETLINE);
                    buf.add(this.getlineStmt(x, op));
                    continue;
                }
                buf.add(x);
            }
            e = new Node.Call("cat_", buf.toArray(), 2);
        }
        return e;
    }

    private Object expr(boolean wantColon) {
        if (Keyword.SymVAR == this.tok || Keyword.SymVAL == this.tok) {
            if (!this.isGlobalDef) {
                Symbols.setLocalDefMode(true);
            }
            Keyword id = (Keyword)((Object)this.tok);
            this.eat(this.tok);
            Object e = this.term();
            if (!(e instanceof Node.YyVariable)) {
                throw new IllegalStateException("unmatch: " + e);
            }
            Node.YyVariable x = (Node.YyVariable)e;
            if (!this.isGlobalDef) {
                Symbols.setLocalDefMode(false);
            }
            T4Types rr = this.optType(x.name, false);
            int typ = rr.nType();
            String sType = rr.sType();
            if (!sType.isEmpty()) {
                Symbols.setType(x.name, typ, 0x4000 | (Keyword.SymVAL == id ? 8192 : 0));
            }
            return this.assignop(id, x, sType);
        }
        Object e = this.orop();
        if (e instanceof Node.YyVariable) {
            Node.YyVariable x = (Node.YyVariable)e;
            T4Types rr = this.optType(x.name, wantColon);
            int typ = rr.nType();
            String sType = rr.sType();
            if (rxEXPR.find(this.tok)) {
                if (!sType.isEmpty()) {
                    Symbols.setType(x.name, typ, "=".equals(this.tok) ? 16384 : 0);
                }
                return this.assignop(Keyword.SyyASSIGN, x, sType);
            }
            return x;
        }
        return e;
    }

    @Override
    Object expression() {
        if (Keyword.SymPRINT == this.tok) {
            return this.printStmt(Keyword.SymPRINT);
        }
        if (Keyword.SymPRINTF == this.tok) {
            return this.printStmt(Keyword.SymPRINTF);
        }
        return this.expr(false);
    }

    private Object factor(Node.NAME e) {
        String name = e.name;
        if ("$".equals(name)) {
            boolean gurdeINCDEC;
            if ("(".equals(this.tok)) {
                gurdeINCDEC = false;
            } else {
                ++this.yyPARENg;
                gurdeINCDEC = true;
            }
            Node.Arr ex = new Node.Arr(name, Type.castWrapArray(this.nonPostSimpExp()));
            if (gurdeINCDEC) {
                --this.yyPARENg;
            }
            return "++".equals(this.tok) || "--".equals(this.tok) ? this.optPostIncdec(ex) : ex;
        }
        if ("[".equals(this.tok)) {
            Node.YyVariable ex = Expression.arrayType(new Node.Arr(name, Type.castWrapArray(this.term())));
            return "++".equals(this.tok) || "--".equals(this.tok) ? this.optPostIncdec(ex) : ex;
        }
        if ("++".equals(this.tok) || "--".equals(this.tok)) {
            if (Symbols.isClosure(e.name)) {
                ++this.cCLOSURE;
            }
            return this.optPostIncdec(e);
        }
        if ("(".equals(this.tok) && !this.yyHasLEFTSPACE || this.hasFunction(name)) {
            return this.callStmt(name);
        }
        if (Symbols.isClosure(e.name)) {
            ++this.cCLOSURE;
        }
        return e;
    }

    private Node.YyCall functionValue(Keyword id) {
        if ("(".equals(this.tok) || "{".equals(this.tok)) {
            Node.Root e = this.functionDecl();
            if (e instanceof Node.Call) {
                Node.Call x = (Node.Call)e;
                System.err.println(x.name + ": \u7121\u540d\u95a2\u6570\u5024\u3000-- \u3053\u3053\u306b\u306f\u6765\u306a\u3044\u306f\u305a");
                this.callStmtImpl(this.getFunctionId(x.name), x.args);
                return new Node.Invoke(id, "", x.name, x.args, x.nType, "", true);
            }
            throw new IllegalStateException("unmatch: " + e);
        }
        String name = this.tok.toString();
        this.advance();
        return this.invokeStmt(id, name);
    }

    private Object invokeop() {
        Object e = this.term();
        while (".".equals(this.tok)) {
            this.advance();
            String methd = this.tok.toString();
            this.advance();
            e = this.invokeStmtImpl(Keyword.SymINVOKE, e, methd);
        }
        return e;
    }

    private boolean isConcat() {
        return null != this.tok && !(this.tok instanceof Keyword) && !"in".equals(this.tok) && !(this.tok instanceof String) || rxCONCATOP.find(this.tok);
    }

    private Object multiop() {
        Object e = this.unaryop();
        ++this.yyEnableANAREG;
        while (rxMULTIOP.find(this.tok)) {
            String op = rxMULTIOP.group(1);
            this.eat(this.tok);
            e = new Node.Calc(op, e, this.unaryop());
        }
        --this.yyEnableANAREG;
        return e;
    }

    private Node.YyCall newStmt() {
        Object e = this.tok;
        this.eat(this.tok);
        Term.BOXING obj = Expression.className(e);
        T4Types rr = this.optType(e.toString(), false);
        int typ = rr.nType();
        String sType = rr.sType();
        this.yyHasLEFTSPACE = false;
        return new Node.Invoke(Keyword.SyyNEW, obj, "", Type.castWrapArray(this.callArgments()), typ, sType, true);
    }

    private Object nonPostSimpExp() {
        int sign = 1;
        while ("-".equals(this.tok) || "+".equals(this.tok)) {
            if ("-".equals(this.tok)) {
                sign *= -1;
            }
            this.eat(this.tok);
        }
        Object e = this.term();
        if (0 > sign) {
            e = new Node.Calc("-", Term.NUMBER_ZERO, e);
        }
        return e;
    }

    private Object optPostIncdec(Object e) {
        if (this.yyPARENg <= this.yyPARENca && "++".equals(this.tok)) {
            this.advance();
            return new Node.IncDec("+-", Expression.incdecNegateType((Node.YyVariable)e));
        }
        if (this.yyPARENg <= this.yyPARENca && "--".equals(this.tok)) {
            this.advance();
            return new Node.IncDec("-+", Expression.incdecNegateType((Node.YyVariable)e));
        }
        return e;
    }

    private Object orop() {
        Object e = this.andop();
        if ("?".equals(this.tok)) {
            this.eat(this.tok);
            this.nl();
            Object e1 = this.expr(true);
            this.eat(":");
            this.nl();
            Object e2 = this.expr(true);
            int t1 = Expression.getMaskType(e1);
            int t2 = Expression.getMaskType(e2);
            if (31 != t1 && 31 != t2 && t1 != t2) {
                this.yyWARNING("TYPE UNMATCHED: ? " + e1 + ":<" + Integer.toHexString(t1) + "> " + e2 + ":<" + Integer.toHexString(t2) + ">");
            }
            e = new Node.If(Keyword.SyyQIF, Expression.genCompare(e), Type.castWrapArray(e1), Type.castWrapArray(e2));
        } else {
            while (rxOROP.find(this.tok)) {
                String op = rxOROP.group(1);
                this.eat(this.tok);
                e = new Node.Comp(op, Expression.genCompare(e), Expression.genCompare(this.andop()));
            }
        }
        return e;
    }

    private Object powerop() {
        Object e = this.invokeop();
        while (rxPOWEROP.find(this.tok)) {
            String op = rxPOWEROP.group(1);
            this.eat(this.tok);
            e = new Node.Calc(op, e, this.invokeop());
        }
        return e;
    }

    private Node.YyStatement printStmt(Keyword id) {
        this.cPARENNEST = this.yyPARENc;
        this.advance();
        boolean hasParen = "(".equals(this.tok);
        this.isPRINTSTAT = true;
        Object[] x = rxREADLINE.find(this.tok) ? Function.EMPTY_ARRAY : (hasParen ? this.commalist() : this.optparenlist());
        this.isPRINTSTAT = false;
        String rop = this.tok.toString();
        Object[] a = Type.castWrapArray(x);
        if ('>' == rop.charAt(0) || '|' == rop.charAt(0)) {
            this.eat(this.tok);
            return new Node.Print(Keyword.toName(id), a, rop, this.expr(false));
        }
        return new Node.Print(Keyword.toName(id), a, "", "");
    }

    private Node.Getline getlineStmt(Object command, String op) {
        Object f;
        String rid;
        this.isGETLINESTAT = true;
        Object v = rxREADLINE.find(this.tok) ? Function.EMPTY_ARRAY : this.term();
        this.isGETLINESTAT = false;
        if ("<".equals(this.tok) || "|&".equals(this.tok)) {
            rid = this.tok.toString();
            this.eat(this.tok);
            f = this.term();
        } else if (!"".equals(command)) {
            rid = op;
            f = command;
        } else {
            rid = "";
            f = "";
        }
        if (v instanceof Object[] && 0 == ((Object[])v).length) {
            return new Node.Getline(Function.EMPTY_ARRAY, rid, f);
        }
        if (v instanceof Node.Arr && "$".equals(((Node.Arr)v).name) && Expression.isEmptyNumber(((Node.Arr)v).index)) {
            return new Node.Getline(Function.EMPTY_ARRAY, rid, f);
        }
        if (v instanceof Node.YyVariable) {
            Node.YyVariable x = (Node.YyVariable)v;
            Expression.updateType(x, 2, 16384);
            if ("".equals(f)) {
                return new Node.Getline(Type.castWrapArray(x), "", "");
            }
            return new Node.Getline(Type.castWrapArray(x), rid, f);
        }
        throw new IllegalStateException("unmatch: " + v);
    }

    private Object relativeop() {
        Object e = this.concatop();
        if ("is".equals(this.tok) || "as".equals(this.tok)) {
            String id = this.tok.toString();
            this.eat(this.tok);
            Object ex = this.tok;
            this.eat(this.tok);
            Term.BOXING obj = Expression.className(ex);
            return new Node.Comp(id, Type.castWrapArray(e), obj);
        }
        if ("in".equals(this.tok)) {
            this.eat(this.tok);
            Object ex = this.concatop();
            if (e instanceof Node.Invoke) {
                Node.Invoke call = (Node.Invoke)e;
                return new Node.Invoke(Keyword.SymHAS, ex, call.name, call.args, -1, "", true);
            }
            if (Flags.isVarArgs(Type.getNodeType(ex))) {
                return new Node.Comp("in", e, ex);
            }
            return new Node.Comp("in", new Node.Call("INDEX", Type.castWrapArray(e), 2), ex);
        }
        Object ex = e;
        while (!(this.isGETLINESTAT || !rxRELATIVEOP.find(this.tok) || this.isPRINTSTAT && this.cPARENNEST >= this.yyPARENc && rxREDIRECT.find(this.tok))) {
            String op = rxRELATIVEOP.group(1);
            this.eat(this.tok);
            ex = new Node.Comp(op, ex, this.concatop());
        }
        return ex;
    }

    @Override
    Object term() {
        Object x = this.tok;
        if ("(".equals(x)) {
            return this.parenlist();
        }
        if ("[".equals(x)) {
            this.eat(this.tok);
            Object[] ex = this.optparenlist();
            this.eat("]");
            return Expression.index(ex);
        }
        if ("`~".equals(x)) {
            this.advance();
            return new Node.IncDec("~", Expression.incdecNegateType((Node.YyVariable)this.term()));
        }
        if ("++".equals(x)) {
            this.advance();
            return new Node.IncDec("++", Expression.incdecNegateType((Node.YyVariable)this.term()));
        }
        if ("--".equals(x)) {
            this.advance();
            return new Node.IncDec("--", Expression.incdecNegateType((Node.YyVariable)this.term()));
        }
        if (Keyword.SymGETLINE == x) {
            this.advance();
            return this.getlineStmt("", "");
        }
        if (Keyword.SymPRINT == x) {
            return this.printStmt(Keyword.SymPRINT);
        }
        if (Keyword.SymPRINTF == x) {
            return this.printStmt(Keyword.SymPRINTF);
        }
        if (x.toString().matches("^[.]{1,2}")) {
            Keyword id = 1 == x.toString().length() ? Keyword.SyyFVal : Keyword.SyyFValFuture;
            this.advance();
            return this.functionValue(id);
        }
        if (x instanceof Term.BOXING) {
            this.advance();
            return this.invokeStmt(Keyword.SymINVOKE, ((Term.BOXING)x).id);
        }
        if (x instanceof Node.NAME && "new".equals(((Node.NAME)x).name)) {
            this.advance();
            return this.newStmt();
        }
        if (x instanceof Node.NAME) {
            this.advance();
            return this.factor((Node.NAME)x);
        }
        this.advance();
        return x;
    }

    private Object unaryop() {
        if (rxUNARYOP.find(this.tok)) {
            String op = this.tok.toString();
            this.eat(this.tok);
            Object e = this.powerop();
            Object[] ea = Type.castWrapArray(e);
            if ("!".equals(op)) {
                return new Node.B00l("!", ea);
            }
            if (e instanceof Term.NUMBER) {
                double dd = 0.0 - ((Term.NUMBER)e).doubleValue();
                if (0.0 == dd || "+".equals(op)) {
                    return ea;
                }
                Number num = NumHelper.normalise(dd);
                return new Term.NUMBER(num.toString(), num);
            }
            if ("-".equals(op)) {
                return new Node.Calc(op, Term.NUMBER_ZERO, ea);
            }
            this.yyOPTIMIZE("unaryop: (" + op + ") " + Type.unWrapList(e));
            return ea;
        }
        return this.powerop();
    }
}

