/*
 * Decompiled with CFR 0.152.
 */
package plus.eval;

import plus.concurrent.AtomicInterface;
import plus.eval.EvalFunc;
import plus.lex.Keyword;
import plus.lex.Node;
import plus.lex.Term;
import plus.reflect.Listener;
import plus.reflect.Reflection;

abstract class EvalInvoke
extends EvalFunc {
    EvalInvoke() {
    }

    Object applyImport(Object obj) {
        if (!(obj instanceof String) || EvalInvoke.isNil(obj)) {
            return obj;
        }
        String claz = "." + obj;
        for (String path : this.sTree.userImport) {
            if (!path.endsWith(claz)) continue;
            return path;
        }
        for (String path : this.sTree.preImport) {
            if (!path.endsWith(claz)) continue;
            return path;
        }
        return obj;
    }

    Object invoke(Node.Invoke e) {
        Object[] args = this.evalArgs(e.args);
        if (Keyword.SymHAS == e.id) {
            Tuple2 rr = this.getClassInfo(e.obj);
            return EvalInvoke._has(rr.obj, e.name, args);
        }
        if (Keyword.SyyFVal == e.id || Keyword.SyyFValFuture == e.id) {
            Tuple2 rr = this.getClassInfo(e.obj);
            Object x = rr.isXX ? rr.obj : null;
            return Keyword.SyyFVal == e.id ? new EvalFunc.Function(x, e.name, args) : new EvalFunc.ConcurrentFunction(this, x, e.name, args);
        }
        if (Keyword.SymINVOKE == e.id) {
            return this.invokeImpl(e, args);
        }
        if (Keyword.SyyNEW == e.id) {
            Tuple2 rr = this.getClassInfo(e.obj);
            return Reflection.newInstance(rr.obj.toString(), args);
        }
        throw new IllegalStateException("unmatch: " + e);
    }

    private Object invokeImpl(Node.Invoke e, Object[] args) {
        Tuple2 rr = this.getClassInfo(e.obj);
        String name = e.name;
        Object rs = null;
        boolean hasNext = true;
        while (hasNext) {
            String strObj = rr.obj.toString();
            if (rr.isXX) {
                rs = rr.obj instanceof Listener && "apply".equals(name) ? ((Listener)rr.obj).apply(0 == args.length ? EMPTY_ARRAY : args) : EvalInvoke._invoke(rr.obj, name, args);
                hasNext = false;
                continue;
            }
            if (EvalInvoke._has(strObj)) {
                Class<?> clazz = EvalInvoke.classForName(strObj);
                rs = EvalInvoke._invoke(clazz, name, args);
                hasNext = false;
                continue;
            }
            int ix = strObj.lastIndexOf(46);
            if (0 <= ix) {
                rr.obj = strObj.substring(0, ix);
                name = strObj.substring(ix + 1);
                continue;
            }
            Object clazz = EvalInvoke._getValue(strObj, null);
            if (!EvalInvoke.isNil(clazz)) continue;
            clazz = strObj;
            rs = EvalInvoke._invoke(clazz, name, args);
            hasNext = false;
        }
        return rs;
    }

    private Tuple2 getClassInfo(Object e) {
        if (e instanceof AtomicInterface) {
            return new Tuple2(e, false);
        }
        if (e instanceof Term.YyValue) {
            Term.YyValue x = (Term.YyValue)e;
            Object obj = this.applyImport(x.value);
            return new Tuple2(obj, false);
        }
        if (e instanceof Node.YyVariable) {
            Node.YyVariable x = (Node.YyVariable)e;
            Object obj = this.applyImport(EvalInvoke._getValue(x.name, this.mkIndex(x.index)));
            return new Tuple2(obj, true);
        }
        Object obj = this.applyImport(this.eval(e));
        return new Tuple2(obj, true);
    }

    static class Tuple2 {
        final boolean isXX;
        Object obj;

        Tuple2(Object obj, boolean isXX) {
            this.obj = obj;
            this.isXX = isXX;
        }
    }
}

