/*
 * Copyright (C) 2010 awk4j - http://awk4j.sourceforge.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.io;

import java.io.OutputStream;

/**
 * [%device%] null 出力ストリーム.
 * <p>
 * The class to which this annotation is applied is immutable.
 *
 * @author kunio himei.
 */
public final class NullOutputStream extends OutputStream {

    /**
     * Singleton Object.
     */
    public static final NullOutputStream THIS = new NullOutputStream();

    /**
     * default constructor.
     */
    private NullOutputStream() {
        super();
    }

    /**
     * 何もしない.
     */
    @Override
    public void close() {
        // (何もしない)
    }

    /**
     * 何もしない.
     */
    @Override
    public void flush() {
        // (何もしない)
    }

    /**
     * @param b 何もしない (not used).
     */
    @Override
    public void write(final int b) {
        // (何もしない)
    }
}