/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import plus.lex.Comment;
import plus.lex.Keyword;
import plus.lex.LexRegx;
import plus.lex.Node;
import plus.lex.Operator;
import plus.lex.Symbols;
import plus.lex.Term;
import plus.util.Escape;
import plus.util.NumHelper;

abstract class Token
extends Comment {
    private static final String RXNAMEC = "[A-Za-z_][A-Za-z_0-9.$]*";
    private static final LexRegx rxName = new LexRegx("^(`[A-Za-z_][A-Za-z_0-9.$]*`|[A-Za-z_][A-Za-z_0-9.$]*|[$]).*");
    private static final LexRegx rxNumber = new LexRegx("^((?:0[Xx][0-9A-Fa-f_]+|0[Bb][01_]+|[0-9][0-9_]*[.]?[0-9_]*|[.][0-9_]+)(?:[eE][+-]?[0-9_]+)?).*");
    private static final LexRegx rxString_SingleQuote = new LexRegx("^('[^'\\\\]*(?:\\\\.[^'\\\\]*)*').*");
    private static final LexRegx rxString_DoubleQuote = new LexRegx("^(\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\").*");
    private static final LexRegx rxComment = new LexRegx("^(\\s*)(#.*|//.*|/\\*.*?\\*/)(.*)");
    private static final LexRegx rxAnnotation = new LexRegx("^(@[\\w]+([(].*?[)])?).*");
    private static final LexRegx rxTokens = new LexRegx("^([!]?~|[|]&|[!=]={1,2}|[<>]=?|&{1,2}|[|]{1,2}|[!^?]|[+][+]|--|([-+/%]|[*]{1,2})=?|(<<|>{2,3})=?|([&|^]|`~)=?|[.]{1,2}|.).*");

    Token() {
    }

    @Override
    Object nextToken() {
        if (rxAnnotation.find(this.yyText)) {
            String a = rxAnnotation.group(1);
            this.dropMatchToken(a);
            this.yyAnnotation.add(a);
            return new Node.Annotation(a);
        }
        if (rxComment.find(this.yyText)) {
            this.doComment();
            return this.yyText.isEmpty() ? "\n" : this.nextToken();
        }
        if (rxNumber.find(this.yyText)) {
            String a = rxNumber.group(1);
            this.dropMatchToken(a);
            String x = a.replace("_", "");
            return new Term.NUMBER(x, NumHelper.normalise(NumHelper.doubleValue(x)));
        }
        if (rxString_DoubleQuote.find(this.yyText)) {
            String a = rxString_DoubleQuote.group(1);
            this.dropMatchToken(a);
            String x = a.substring(1, a.length() - 1);
            return new Term.STRING(Escape.nopFilter(x));
        }
        if (rxString_SingleQuote.find(this.yyText)) {
            String a = rxString_SingleQuote.group(1);
            this.dropMatchToken(a);
            String x = a.substring(1, a.length() - 1);
            return new Term.STRING(Escape.encodeString(x, "\""));
        }
        if (rxName.find(this.yyText)) {
            String a = rxName.group(1);
            this.dropMatchToken(a);
            String x = Operator.changeOperator(a);
            if (1 < x.length() && (0 <= x.indexOf(46) || 0 <= x.indexOf(36))) {
                return new Term.BOXING(x);
            }
            if (Operator.isOperator(x)) {
                return x;
            }
            if (Keyword.contains(x)) {
                return Keyword.apply(x);
            }
            Symbols.createType(x);
            return new Node.NAME(Keyword.SyyNAME, x);
        }
        String a = LexRegx.isNativeRegexp(this.yyText);
        if (0 >= this.yyEnableANAREG && null != a) {
            this.dropMatchToken(a);
            String x = a.substring(1, a.length() - 1);
            return new Term.REGEXP(Escape.nopFilter(x));
        }
        if (rxTokens.find(this.yyText)) {
            String x = rxTokens.group(1);
            this.dropMatchToken(x);
            return Operator.changeOperator(x);
        }
        throw new IllegalStateException("Lex: " + this.yyText);
    }
}

