/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;
import plus.lex.Action;
import plus.lex.Advance;
import plus.lex.Keyword;
import plus.lex.LexArray;
import plus.lex.Node;
import plus.lex.Symbols;

public final class Parser
extends Action {
    private final SyntaxTree sTree = new SyntaxTree();
    private static final String PRE_IMPORT_FILE_NAME = "import.awk";
    private final List<String> annotation = new LexArray<String>();
    private boolean isDefinable = true;
    private final List<String> annoteMain = new LexArray<String>();
    private final List<Object> mainBlock = new LexArray<Object>();
    private BufferedReader reader;
    private final List<String> commentList = new LexArray<String>();
    private final List<Object> globalBlock = new LexArray<Object>();
    private final List<Object> beginBlock = new LexArray<Object>();
    private final List<Object> endBlock = new LexArray<Object>();
    private String[] scriptFiles;
    private int scriptIndex;

    public SyntaxTree parse(String[] scripts) throws Throwable {
        this.scriptFiles = scripts;
        try {
            this.advance();
            while (null != this.tok) {
                assert (!"\n".equals(this.tok));
                if (Keyword.SymPACKAGE == this.tok) {
                    this.eat(this.tok);
                    this.sTree.packageName = this.tok.toString().trim();
                    this.advance();
                    this.nl();
                    continue;
                }
                if (Keyword.SymIMPORT == this.tok) {
                    String path = this.yyText.trim().replaceFirst("^\\w+\\s+", "").replaceFirst("\\s+.*$", "");
                    if (this.yyScriptName.contains(PRE_IMPORT_FILE_NAME)) {
                        this.sTree.preImport.add(path);
                    } else {
                        this.sTree.userImport.add(path);
                    }
                    this.eat(this.tok);
                    this.eat(this.tok);
                    this.advance();
                    this.nl();
                    continue;
                }
                if (this.tok instanceof Node.Annotation) {
                    if (this.isDefinable && this.annotation.isEmpty()) {
                        this.annotation.addAll(this.yyAnnotation.moveList());
                    }
                    this.eat(this.tok);
                    this.advance();
                    this.nl();
                    continue;
                }
                if (Keyword.SymVAR == this.tok || Keyword.SymVAL == this.tok) {
                    if (this.isDefinable) {
                        this.annotation.addAll(this.yyAnnotation.moveList());
                        this.isDefinable = false;
                    }
                    this.isGlobalDef = true;
                    this.globalBlock.add(this.expression());
                    this.isGlobalDef = false;
                    this.nl();
                    continue;
                }
                if (Keyword.SymBEGIN == this.tok) {
                    if (this.hasComment()) {
                        this.commentList.addAll(this.getComment());
                    }
                    this.sTree.annotateBEGIN = this.yyAnnotation.moveArray();
                    this.eat(this.tok);
                    this.requireLeftBraces();
                    this.beginBlock.addAll(Arrays.asList(this.pattern(false)));
                    continue;
                }
                if (Keyword.SymEND == this.tok) {
                    if (this.hasComment()) {
                        this.commentList.addAll(this.getComment());
                    }
                    this.sTree.annotateEND = this.yyAnnotation.moveArray();
                    this.eat(this.tok);
                    this.requireLeftBraces();
                    this.endBlock.addAll(Arrays.asList(this.pattern(false)));
                    continue;
                }
                if (Keyword.SymFUNCTION == this.tok) {
                    this.eat(this.tok);
                    this.functionDecl();
                    continue;
                }
                if (this.hasComment()) {
                    this.commentList.addAll(this.getComment());
                }
                this.annoteMain.addAll(this.yyAnnotation);
                this.yyAnnotation.clear();
                this.mainBlock.addAll(Arrays.asList(this.pattern(true)));
            }
            this.updateFunctionDef();
            this.sTree.comment = this.commentList.toArray(new String[0]);
            this.sTree.annotation = this.annotation.toArray(new String[0]);
            this.sTree.annotateMAIN = this.annoteMain.toArray(new String[0]);
            this.sTree.global = this.globalBlock.toArray();
            this.sTree.begin = this.beginBlock.toArray();
            this.sTree.main = this.mainBlock.toArray();
            this.sTree.end = this.endBlock.toArray();
            this.sTree.globalValues = Symbols.cleanGlobal();
            this.sTree.func = new HashMap<String, Node.Func>(this.functionMap);
            this.sTree.call = new HashMap<String, Integer[]>(this.callMAP);
            this.functionMap.clear();
            this.callMAP.clear();
            return this.sTree;
        }
        catch (Throwable e) {
            this.dumpLog();
            Throwable cause = e;
            while (null != cause.getCause()) {
                cause = cause.getCause();
            }
            throw cause;
        }
    }

    @Override
    @Nullable
    String readline() {
        String line = null;
        while (null == line) {
            try {
                if (null == this.reader) {
                    if (this.scriptFiles.length <= this.scriptIndex) {
                        return null;
                    }
                    this.sTree.scriptName = this.yyScriptName = this.scriptFiles[this.scriptIndex];
                    ++this.scriptIndex;
                    this.commentList.clear();
                    this.reader = new File(this.sTree.scriptName).isFile() ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.yyScriptName), StandardCharsets.UTF_8)) : new BufferedReader(new StringReader(this.sTree.scriptName));
                }
                if (null != (line = this.reader.readLine())) continue;
                this.reader.close();
                this.reader = null;
                Advance.yyLineNumber(0);
                this.yyLexNumber = 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return line;
    }

    public static class SyntaxTree {
        public final Set<String> preImport = new TreeSet<String>();
        public final Set<String> userImport = new TreeSet<String>();
        public String packageName = "";
        public String[] comment;
        public String[] annotation;
        public String[] annotateBEGIN;
        public String[] annotateMAIN;
        public String[] annotateEND;
        public Object[] global;
        public Object[] begin;
        public Object[] main;
        public Object[] end;
        public Map<String, Integer> globalValues;
        public Map<String, Node.Func> func;
        public Map<String, Integer[]> call;
        public String scriptName;
    }
}

