/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import plus.lex.Advance;
import plus.lex.LexArray;
import plus.lex.LexRegx;

abstract class Comment
extends Advance {
    private static final LexRegx rxComment = new LexRegx("^(\\s*)(#.*|//.*|/\\*.*?\\*/)(.*)");
    private static final LexRegx rxCommentStart = new LexRegx("^(\\s*)(/\\*.*)");
    private static final LexRegx rxCommentEnd = new LexRegx("^(.*?\\*/)(.*)");
    private final LexArray<String> commentBuf = new LexArray();
    private boolean isEnableComment;
    private boolean isInComment;

    Comment() {
    }

    private void comment(String a, String b, int pre, int post) {
        String x = a.substring(pre, a.length() - post);
        this.yyLexColumn += pre;
        this.yyText = b;
        if (this.isEnableComment && !x.isEmpty()) {
            this.commentBuf.add(x);
        }
    }

    @Override
    void doComment() {
        boolean hasNext = true;
        while (hasNext && !this.yyText.isEmpty()) {
            if (rxComment.find(this.yyText)) {
                a = rxComment.group(2);
                b = rxComment.group(3);
                if (a.startsWith("##")) {
                    this.isEnableComment = true;
                    this.comment(a, "", 2, 0);
                } else if (a.startsWith("/*")) {
                    if (a.startsWith("/**")) {
                        this.isEnableComment = true;
                        this.comment(a, b, 3, 2);
                    } else {
                        this.comment(a, b, 2, 2);
                    }
                } else if (a.startsWith("#")) {
                    this.comment(a, "", 1, 0);
                } else if (a.startsWith("//")) {
                    this.comment(a, "", 2, 0);
                } else {
                    throw new IllegalArgumentException("Comment: " + a);
                }
                this.isEnableComment = false;
            } else if (rxCommentStart.find(this.yyText)) {
                a = rxCommentStart.group(2);
                if (this.isInComment) {
                    throw new IllegalArgumentException("Comment: " + a);
                }
                if (a.startsWith("/**")) {
                    this.isEnableComment = true;
                    this.comment(a, "", 3, 0);
                } else if (a.startsWith("/*")) {
                    this.comment(a, "", 2, 0);
                }
                this.isInComment = true;
            } else if (rxCommentEnd.find(this.yyText)) {
                a = rxCommentEnd.group(1);
                b = rxCommentEnd.group(2);
                if (this.isInComment) {
                    this.comment(a, b, 0, 2);
                    this.isInComment = false;
                    this.isEnableComment = false;
                } else {
                    hasNext = false;
                }
            } else {
                if (this.isInComment) {
                    this.comment(this.yyText, "", 0, 0);
                }
                hasNext = false;
            }
            this.lTrim();
            if (!this.yyText.isEmpty()) continue;
            hasNext = false;
        }
    }

    LexArray<String> getComment() {
        return this.commentBuf.moveList();
    }

    String[] getCommentArray() {
        return this.commentBuf.moveArray();
    }

    boolean hasComment() {
        return !this.isEnableComment && !this.commentBuf.isEmpty();
    }
}

