/*
 * Decompiled with CFR 0.152.
 */
package plus.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class NumHelper {
    private static final Integer C_INTEGER0 = 0;
    private static final Integer C_INTEGER1 = 1;
    private static final int TO_BIN = 2;
    private static final int TO_OCT = 8;
    private static final int TO_HEX = 16;
    private static final Pattern RX_DECIMAL_NUMBER = Pattern.compile("^([-+]?(?:\\d+[.]?\\d*|\\d+[.]|[.]\\d+)(?:[eE][-+]?\\d+)?)[dflDFL]?(.*)");
    private static final Pattern RX_HEX_NUMBER = Pattern.compile("^0[Xx]([0-9a-fA-F]+)(.*)");
    private static final Pattern RX_OCT_NUMBER = Pattern.compile("^0([0-7]+)(.*)");
    private static final Pattern RX_BIN_NUMBER = Pattern.compile("^0[Bb]([01]+)(.*)");
    private static final Pattern RX_HAS_NUMBER = Pattern.compile("\\d+");
    private static final Pattern RX_NUMBER = Pattern.compile("^([-+]?\\d*[.]?\\d*(?:[dflDFL][-+]?\\d+)?)$");

    public static boolean matchNumber(String x) {
        return RX_HAS_NUMBER.matcher(x).find() && RX_NUMBER.matcher(x).find();
    }

    public static Number parseNumber(CharSequence x) {
        return Objects.requireNonNull(NumHelper.parseNumberImpl(x, false));
    }

    public static Number parseNumberFull(CharSequence x) {
        return NumHelper.parseNumberImpl(x, true);
    }

    private static Number parseNumberImpl(CharSequence x, boolean isFull) {
        if (0 < x.length()) {
            Matcher m;
            if ('0' == x.charAt(0)) {
                m = RX_HEX_NUMBER.matcher(x);
                if (m.find() && (!isFull || m.group(2).isEmpty())) {
                    return Long.parseLong(m.group(1), 16);
                }
                m = RX_BIN_NUMBER.matcher(x);
                if (m.find() && (!isFull || m.group(2).isEmpty())) {
                    return Long.parseLong(m.group(1), 2);
                }
                m = RX_OCT_NUMBER.matcher(x);
                if (m.find() && (!isFull || m.group(2).isEmpty())) {
                    return Long.parseLong(m.group(1), 8);
                }
            }
            if ((m = RX_DECIMAL_NUMBER.matcher(x)).find() && (!isFull || m.group(2).isEmpty())) {
                return Double.parseDouble(m.group(1));
            }
        }
        return isFull ? null : C_INTEGER0;
    }

    public static Object toStringNumber(Object value) {
        String x = Objects.toString(value, "");
        if (NumHelper.matchNumber(x)) {
            try {
                return NumHelper.normalise(Double.parseDouble(x));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return x;
    }

    public static int intValue(Object x) {
        return (int)NumHelper.doubleValue(x);
    }

    public static double doubleValue(Object x) {
        if (x instanceof Number) {
            return ((Number)x).doubleValue();
        }
        return NumHelper.numberValue(x).doubleValue();
    }

    public static Number numberValue(Object x) {
        if (null == x) {
            return C_INTEGER0;
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? C_INTEGER1 : C_INTEGER0;
        }
        if (x instanceof Number) {
            return NumHelper.normalise((Number)x);
        }
        Number xx = NumHelper.parseNumberImpl(x.toString(), false);
        if (null == xx) {
            return C_INTEGER0;
        }
        return NumHelper.normalise(xx);
    }

    public static Number normalise(double d) {
        long ll = (long)d;
        int ii = (int)d;
        if (0.0 != d - (double)ll) {
            return d;
        }
        if (0L != ll - (long)ii) {
            return ll;
        }
        return ii;
    }

    @NotNull
    public static Number normalise(Number number) {
        Number number2 = NumHelper.normalise(number.doubleValue());
        if (number2 == null) {
            NumHelper.$$$reportNull$$$0(0);
        }
        return number2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "plus/util/NumHelper", "normalise"));
    }
}

