# -*- coding: utf-8 -*-

# GUIのメインフレームにおけるSkill2一覧Notebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers

class NoteBookSkill1View():
    u""" メインのフレームのスキル1一覧タブ """
    SEPARATER = u"/"
    def __init__(self, frame):
        self.frame = frame
        self._init_view()
        self._init_event()
        self._seed1, self._table_no, self._no = None, None, None

    def _init_view(self):
        # initialize view
        self.radiobox_tenun = xrc.XRCCTRL(self.frame, "RadioBoxSkill1Tenun")
        self.grid_skill1 = xrc.XRCCTRL(self.frame, "GridFirstSkill")
        self.ID_SKILL1_GRID = xrc.XRCID("GridFirstSkill")

        self.button_skill1_search = xrc.XRCCTRL(self.frame, "ButtonSeed1Skill1Search")
        self.button_skill1_clear = xrc.XRCCTRL(self.frame, "ButtonSeed1Skill1Clear")
        self.ID_BUTTON_SKILL1_SEARCH = xrc.XRCID("ButtonSeedSkill1Search")
        self.ID_BUTTON_SKILL1_CLEAR = xrc.XRCID("ButtonSeedSkill1Clear")

        # load skill1 grid value
        u"""Tableを結果TextCtrlで示し、No.をrowラベル、行にはseed1, 天運個数、
        1-7枠目の値を表示する。1-7枠目をお守りの種類とスキル名で分けると面倒なので
        合体させて1つの行で表示した方がいいかもしれない。この場合は行数は9となる"""
        self.grid_skill1.CreateGrid(constnumbers.NUM_SKILL1_GRID_ROW, constnumbers.NUM_SKILL1_GRID_COL)
        self.grid_skill1.SetColLabelValue(0, constnumbers.LABEL_FORMAT_SKILL1_GRID_COL1)
        self.grid_skill1.SetColLabelValue(1, constnumbers.LABEL_FORMAT_SKILL1_GRID_COL2)
        for i in range(2, constnumbers.NUM_SKILL1_GRID_COL):
            self.grid_skill1.SetColLabelValue(i, 
                    constnumbers.LABEL_FORMAT_SKILL1_GRID_COL_AFTER2.format(i-1))
        self.grid_skill1.DisableDragGridSize()
        self.grid_skill1.EnableEditing(False)

        # text ctrl
        self.text_ctrl_seed1_select = xrc.XRCCTRL(self.frame, "TextCtrlSeed1Select")
        self.text_ctrl_result = xrc.XRCCTRL(self.frame, "TextCtrlSkill1Result")

    def _init_event(self):
        u""" イベントの登録 """
        self.grid_skill1.Bind(wx.EVT_SIZE, self.OnGridSizeChanged)

    def OnGridSizeChanged(self, event):
        u""" Gridサイズの変更時 """
        width, height = self.grid_skill1.GetParent().GetSize()
        each_width = (width - 60) / (constnumbers.NUM_SKILL1_GRID_COL) # consider margin size
        self.grid_skill1.SetRowLabelSize(45)
        for col in range(constnumbers.NUM_SKILL1_GRID_COL):
            self.grid_skill1.SetColSize(col, each_width) 

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンへのイベント登録 """
        self.button_skill1_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンへのイベント登録 """
        self.button_skill1_clear.Bind(evt, event_func)

    def set_result_text(self, value):
        u""" 結果の表示TextCtrlのセット """
        self.text_ctrl_result.SetValue(value)
        self._seed1, self._table_no, self._no = None, None, None

    def clear_result_text(self):
        u""" 結果の表示TextCtrlのクリア """
        self.text_ctrl_result.SetValue(u"")
        self._seed1, self._table_no, self._no = None, None, None

    def set_text_result_by_seed1(self, seed1, table_no, no):
        u""" 結果を示すTextCtrlへの値のセット """
        if seed1 is not None and table_no is not None and no is not None:
            self.text_ctrl_result.SetValue(
                    u"Seed1: {0}, テーブルNo: {1}, 通し番号: {2}".format(seed1, table_no, no))
            self._seed1, self._table_no, self._no = seed1, table_no, no
        else:
            self.clear_text_result()

    def set_seed1_value(self, value):
        u""" TextCtrlに与えられた値をセットする"""
        self.text_ctrl_seed1_select.SetValue(u"{0}".format(value))

    def get_seed1_value(self):
        u""" TextCtrlから入力されたSeed1の値を得る。数値に変換できない時はNoneを返す"""
        seed = self.text_ctrl_seed1_select.GetValue()
        if seed.isdigit():
            return int(seed)
        else:
            return None

    def get_tenun_radio_key(self):
        u""" 天運の錬金で使用したお守りの種類を示すkeyを返す """
        idx = self.radiobox_tenun.GetSelection()
        if idx == 0:
            return constnumbers.KEY_TENUN555
        elif idx == 1:
            return constnumbers.KEY_TENUN888
        else:
            return None

    def set_tenun_radio_key(self, alchemy_key):
        u""" 天運の錬金で使用したお守りの種類を示すkeyにより、ラジオボックスの選択状態を変更 """
        if alchemy_key == constnumbers.KEY_TENUN555:
            self.radiobox_tenun.SetSelection(0)
        elif alchemy_key == constnumbers.KEY_TENUN888:
            self.radiobox_tenun.SetSelection(1)
        else:
            pass

    def clear_highlight(self):
        u""" セルの強調表示をクリアする """
        for row in range(self.grid_skill1.GetNumberRows()):
            for col in range(self.grid_skill1.GetNumberCols()):
                self.grid_skill1.SetCellBackgroundColour(row, col, wx.NullColor)

    def update_highlight(self, skill_names, color=u"Yellow"):
        u""" 指定されたスキル名に一致するセルを強調表示する """
        for row in range(self.grid_skill1.GetNumberRows()):
            for col in range(2, self.grid_skill1.GetNumberCols()):
                val = self.grid_skill1.GetCellValue(row, col)
                try:
                    amu_name, skill_name = val.split(self.SEPARATER)
                    if skill_name in skill_names:
                        self.grid_skill1.SetCellBackgroundColour(row, col, color)
                    else:
                        self.grid_skill1.SetCellBackgroundColour(row, col, wx.NullColor)
                except ValueError as e:
                    #cannot unpack
                    self.grid_skill1.SetCellBackgroundColour(row, col, wx.NullColor)


    def set_no2seed1s_dict(self, no2seed1s_dict, select_no=None):
        u""" 通し番号から(seed1, result_num, amulet_names, skill_names)への辞書を元に、
        noを列ラベルとする表を作成する
        select_noがNoneでなければ、対応する行を選択状態とする"""
        row_num = len(no2seed1s_dict)
        diff = row_num - self.grid_skill1.GetNumberRows()
        if diff > 0:
            self.grid_skill1.AppendRows(diff, False)
        elif diff < 0:
            self.grid_skill1.DeleteRows(0, -diff, False)

        for row, no in enumerate(sorted(no2seed1s_dict.keys())): # order by no
            seed1, result_num, amu_names, skill_names = no2seed1s_dict[no]
            self.grid_skill1.SetRowLabelValue(row, u"{0}".format(no))
            self.grid_skill1.SetCellValue(row, 0, "{0}".format(seed1))
            self.grid_skill1.SetCellValue(row, 1, "{0}".format(result_num))
            for col, amu_name, skill_name in zip(
                    range(2, constnumbers.NUM_SKILL1_GRID_COL), amu_names, skill_names):
                if ((amu_name is not None and amu_name is not u"") and 
                    (skill_name is not None and skill_name is not u"")):
                    val = u"{0}{1}{2}".format(
                        constnumbers.AMULET_NAME_TO_SHORT_NAME_DICT[amu_name], self.SEPARATER, skill_name)
                    self.grid_skill1.SetCellValue(row, col, val)
                else:
                    self.grid_skill1.SetCellValue(row, col, u"")
            if no == select_no:
                self.grid_skill1.MakeCellVisible(row, 0)
                self.grid_skill1.SelectRow(row)

    def clear_skill1_grid(self):
        u""" セルの内容をクリアする """
        for row in range(self.grid_skill1.GetNumberRows()):
            self.grid_skill1.SetRowLabelValue(row, u"")
            for col in range(self.grid_skill1.GetNumberCols()):
               self.grid_skill1.SetCellValue(row, col, u"")
