# -*- coding: utf-8 -*-

# GUIのメインフレームにおけるSeed1特定Notebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers


class NoteBookSeed1View():
    u""" メインのフレームのSeed1特定タブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()
        self._init_event()
        self._seed1, self._table_no, self._no = None, None, None

    def _init_view(self):
        # initialize view

        # buttons
        self.radiobox_tenun = xrc.XRCCTRL(self.frame, "RadioBoxTenun")
        self.button_search = xrc.XRCCTRL(self.frame, "ButtonSeed1Search")
        self.button_clear = xrc.XRCCTRL(self.frame, "ButtonSeed1Clear")
        self.button_skill1 = xrc.XRCCTRL(self.frame, "ButtonSkill1SearchFromSeed1")

        self.spin_ctrl_amulet_num = xrc.XRCCTRL(self.frame, "SpinCtrlSeed1AmuletNum")

        # load combo boxes
        self.combobox_amulet_list = [xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet1"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet2"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet3"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet4"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet5"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet6"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Amulet7")]
        self.combobox_skill_list = [xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill1"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill2"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill3"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill4"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill5"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill6"),
                xrc.XRCCTRL(self.frame, "ComboBoxSeed1Skill7")]

        # text ctrl
        u"""TableNoを結果TextCtrlで示す"""
        self.text_ctrl_result = xrc.XRCCTRL(self.frame, "TextCtrl1Seed1Result")

        # grid
        self.grid_seed1 = xrc.XRCCTRL(self.frame, "GridSeed1Table")


        self._amulet_names = []
        self._amuletname2skillnames_dict = {}

    def set_amuletname_skillnames_dict(self, amulet_names, amuletname2skillnames_dict):
        u"""お守り名とそのお守りに対応する第1スキルの辞書をセットする"""
        self._amulet_names = amulet_names
        self._amuletname2skillnames_dict = amuletname2skillnames_dict
        for amu_combo, skill_combo in zip(self.combobox_amulet_list, self.combobox_skill_list):
            amu_combo.SetItems(self._amulet_names)
            amu_combo.SetSelection(0)
            skill_combo.SetItems(self._amuletname2skillnames_dict[self._amulet_names[0]])
            skill_combo.SetSelection(0)

    def _init_event(self):
        u""" イベントの登録 """
        self.spin_ctrl_amulet_num.Bind(wx.EVT_SPINCTRL, self.OnSpinCtrlChanged)
        for amu_combo in self.combobox_amulet_list:
            amu_combo.Bind(wx.EVT_COMBOBOX, self.OnAmuletComboChanged)

    def OnSpinCtrlChanged(self, event):
        u""" SpinCtrlの値が変わった時のイベント。
        設定できるコンボボックスの数を調節する """
        val = self.spin_ctrl_amulet_num.GetValue()
        for combo1, combo2 in zip(self.combobox_amulet_list[:val], self.combobox_skill_list[:val]):
            combo1.Enable()
            combo2.Enable()
        for combo1, combo2 in zip(self.combobox_amulet_list[val:], self.combobox_skill_list[val:]):
            combo1.Disable()
            combo2.Disable()

    def OnAmuletComboChanged(self, event):
        u""" お守りの種類を選択するコンボボックス変更時 """
        obj = event.GetEventObject()
        for amu_combo, skill_combo in zip(self.combobox_amulet_list, self.combobox_skill_list):
            if obj == amu_combo:
                amu_name = amu_combo.GetStringSelection()
                if amu_name in self._amuletname2skillnames_dict:
                    skill_combo.SetItems(self._amuletname2skillnames_dict[amu_name])
                    skill_combo.SetSelection(0)
                break

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンへのイベント登録 """
        self.button_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンへのイベント登録 """
        self.button_clear.Bind(evt, event_func)

    def bind_button_skill1(self, event_func, evt=wx.EVT_BUTTON):
        u""" 対応第1スキルボタンへのイベント登録 """
        self.button_skill1.Bind(evt, event_func)

    def get_tenun_radio_key(self):
        u""" 天運の錬金で使用したお守りの種類を示すkeyを返す """
        idx = self.radiobox_tenun.GetSelection()
        if idx == 0:
            return constnumbers.KEY_TENUN555
        elif idx == 1:
            return constnumbers.KEY_TENUN888
        else:
            return None

    def get_selected_amulets_and_names(self):
        u"""選択されているお守りの種類名とスキル1の名前のペアをリストとして返す"""
        result_num = self.spin_ctrl_amulet_num.GetValue()
        result_list = []
        for i, amu_combo, skill_combo in zip(
                range(result_num), self.combobox_amulet_list, self.combobox_skill_list):
            amulet_name = amu_combo.GetStringSelection()
            skill_name = skill_combo.GetStringSelection()
            result_list.append((amulet_name, skill_name))
        return result_list

    def clear_combobox(self):
        u""" comboboxの選択されたインデックスを0にする """
        for amu_combo, skill_combo in zip(self.combobox_amulet_list, self.combobox_skill_list):
            amu_combo.SetSelection(0)
            skill_combo.SetSelection(0)

    def clear_text_result(self):
        u""" 結果を示すTextCtrlから値のクリア """
        self.text_ctrl_result.SetValue(u"")
        self._seed1, self._table_no, self._no = None, None, None

    def set_text_result(self, value):
        u""" 結果を示すTextCtrlへ値のセット """
        self.text_ctrl_result.SetValue(value)
        self._seed1, self._table_no, self._no = None, None, None

    def set_text_result_by_seed1(self, seed1, table_no, no):
        u""" 結果を示すTextCtrlへの値のセット """
        if seed1 is not None and table_no is not None and no is not None:
            self.text_ctrl_result.SetValue(
                    u"Seed1: {0}, テーブルNo: {1}, 通し番号: {2}".format(seed1, table_no, no))
            self._seed1, self._table_no, self._no = seed1, table_no, no
        else:
            self.clear_text_result()

    def get_result_seed1(self):
        u""" 現在の検索結果のSeed1を返す """
        return self._seed1

    def set_skill1_button_enable(self, value):
        u""" 対応スキル検索ボタンの有効・無効の切り替え """
        if value is True:
            self.button_skill1.Enable()
        else:
            self.button_skill1.Disable()
