
# -*- coding: utf-8 -*-

# GUIのメインフレームにおける錬金シミュレーターNotebookのview
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers

class NoteBookAlchemySimulatorView():
    u""" メインのフレームの錬金シミュレータータブ """
    def __init__(self, frame):
        self.frame = frame
        self._init_view()

    def _init_view(self):
        # initialize view
        self.grid_sim = xrc.XRCCTRL(self.frame, "GridSimulator")
        self.grid_sim.Bind(wx.EVT_SIZE, self.OnGridSizeChanged)

        self.button_search = xrc.XRCCTRL(self.frame, "ButtonSimulatorSearch")
        self.button_clear = xrc.XRCCTRL(self.frame, "ButtonSimulatorClear")

        self.radiobox_tenun = xrc.XRCCTRL(self.frame, "RadioBoxSimulatorTenun")

        # load simulator grid value
        self.grid_sim.CreateGrid(constnumbers.NUM_SIMULATOR_GRID_ROW, constnumbers.NUM_SIMULATOR_GRID_COL)
        self.grid_sim.SetColLabelValue(0, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL1)
        self.grid_sim.SetColLabelValue(1, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL2)
        self.grid_sim.SetColLabelValue(2, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL3)
        self.grid_sim.SetColLabelValue(3, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL4)
        self.grid_sim.SetColLabelValue(4, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL5)
        self.grid_sim.SetColLabelValue(5, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_COL6)

        self.grid_sim.SetRowLabelValue(0, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW1)
        self.grid_sim.SetRowLabelValue(1, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW2)
        self.grid_sim.SetRowLabelValue(2, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW3)
        self.grid_sim.SetRowLabelValue(3, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW4)
        self.grid_sim.SetRowLabelValue(4, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW5)
        self.grid_sim.SetRowLabelValue(5, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW6)
        self.grid_sim.SetRowLabelValue(6, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW7)
        self.grid_sim.SetRowLabelValue(7, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW8)
        self.grid_sim.SetRowLabelValue(8, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW9)
        self.grid_sim.SetRowLabelValue(9, constnumbers.LABEL_FORMAT_SIMULATOR_GRID_ROW10)
        self.grid_sim.DisableDragGridSize()
        self.grid_sim.EnableEditing(False)

        # text ctrl
        self.text_ctrl_seed1 = xrc.XRCCTRL(self.frame, "TextCtrlSimulatorSeed1")
        self.text_ctrl_seed2 = xrc.XRCCTRL(self.frame, "TextCtrlSimulatorSeed2")


    def OnGridSizeChanged(self, event):
        u""" Gridリサイズ時に親パネルのwidthに応じて自動で横に伸長する """
        width, height = self.grid_sim.GetParent().GetSize()
        each_width = (width - 130) / (constnumbers.NUM_SIMULATOR_GRID_COL) # consider margin size
        self.grid_sim.SetRowLabelSize(120)
        for col in range(constnumbers.NUM_SIMULATOR_GRID_COL):
            self.grid_sim.SetColSize(col, each_width)

    def bind_button_search(self, event_func, evt=wx.EVT_BUTTON):
        u""" 検索ボタンへのイベント登録 """
        self.button_search.Bind(evt, event_func)

    def bind_button_clear(self, event_func, evt=wx.EVT_BUTTON):
        u""" クリアボタンへのイベント登録 """
        self.button_clear.Bind(evt, event_func)

    def update_highlight(self, skill_names, color="Yellow"):
        u""" スキル名が一致するセルをハイライトする """
        for row in range(self.grid_sim.GetNumberRows()):
            for col in constnumbers.SIMULATOR_GRID_SKILL_NAME_COLS:
                skill_name = self.grid_sim.GetCellValue(row, col)
                if skill_name in skill_names:
                    self.grid_sim.SetCellBackgroundColour(row, col, color)
                else:
                    self.grid_sim.SetCellBackgroundColour(row, col, wx.NullColor)

    def clear_highlight(self):
        u""" セルの強調表示をクリアする """
        for row in range(self.grid_sim.GetNumberRows()):
            for col in range(self.grid_sim.GetNumberCols()):
                self.grid_sim.SetCellBackgroundColour(row, col, wx.NullColor)

    def clear_grid(self):
        u""" セルの内容をクリアする """
        for row in range(self.grid_sim.GetNumberRows()):
            for col in range(self.grid_sim.GetNumberCols()):
               self.grid_sim.SetCellValue(row, col, u"")

    def set_seed_values(self, seed1, seed2):
        u""" TextCtrlに与えられた値をセットする"""
        if seed1 is not None:
            self.text_ctrl_seed1.SetValue(u"{0}".format(seed1))
        else:
            self.text_ctrl_seed1.SetValue(u"")
        if seed2 is not None:
            self.text_ctrl_seed2.SetValue(u"{0}".format(seed2))
        else:
            self.text_ctrl_seed2.SetValue(u"")

    def clear_seed_values(self):
        u""" TextCtrlに与えられた値をセットする"""
        self.text_ctrl_seed1.SetValue(u"")
        self.text_ctrl_seed2.SetValue(u"")

    def get_seed_values(self):
        u""" TextCtrlから入力されたSeed1, Seed2の値を得る。数値に変換できない時はNoneを返す"""
        seed1 = self.text_ctrl_seed1.GetValue()
        seed2 = self.text_ctrl_seed2.GetValue()
        if seed1.isdigit() and seed2.isdigit():
            return int(seed1), int(seed2)
        else:
            return None

    def get_tenun_radio_key(self):
        u""" 天運の錬金で使用したお守りの種類を示すkeyを返す """
        idx = self.radiobox_tenun.GetSelection()
        if idx == 0:
            return constnumbers.KEY_TENUN555
        elif idx == 1:
            return constnumbers.KEY_TENUN888
        else:
            return None

    def set_tenun_radio_key(self, alchemy_key):
        u""" 天運の錬金で使用したお守りの種類を示すkeyにより、ラジオボックスの選択状態を変更 """
        if alchemy_key == constnumbers.KEY_TENUN555:
            self.radiobox_tenun.SetSelection(0)
        elif alchemy_key == constnumbers.KEY_TENUN888:
            self.radiobox_tenun.SetSelection(1)
        else:
            pass

    def set_tenun_values(self, values):
        u""" values: list of (skill_name1, skill_val1, skill_name2, skill_val2, slot_num, amulet_name)
        天運の錬金の対応する値のセット """
        rows = constnumbers.SIMULATOR_GRID_ROW_DICT[constnumbers.KEY_TENUN]

        for row in rows:
            for col in range(self.grid_sim.GetNumberCols()):
                self.grid_sim.SetCellValue(row, col, u"")

        for row, (skill1_name, skill1_val, skill2_name, skill2_val, slot_num, amulet_name) in zip(rows, values):
            self.grid_sim.SetCellValue(row, 0, amulet_name)
            self.grid_sim.SetCellValue(row, 1, skill1_name)
            self.grid_sim.SetCellValue(row, 2, u"{0}".format(skill1_val))
            if skill2_name != u"":
                self.grid_sim.SetCellValue(row, 3, skill2_name)
                self.grid_sim.SetCellValue(row, 4, u"{0}".format(skill2_val))
            else:
                self.grid_sim.SetCellValue(row, 3, u"")
                self.grid_sim.SetCellValue(row, 4, u"")
            self.grid_sim.SetCellValue(row, 5, u"{0}".format(slot_num))

    def set_values(self, alchemy_type, 
            skill1_name, skill1_val, skill2_name, skill2_val, slot_num, amulet_name):
        u""" なぞ・光明・いにしえの錬金の対応する値のセット """
        row = constnumbers.SIMULATOR_GRID_ROW_DICT[alchemy_type]
        self.grid_sim.SetCellValue(row, 0, amulet_name)
        self.grid_sim.SetCellValue(row, 1, skill1_name)
        self.grid_sim.SetCellValue(row, 2, u"{0}".format(skill1_val))
        if skill2_name != u"":
            self.grid_sim.SetCellValue(row, 3, skill2_name)
            self.grid_sim.SetCellValue(row, 4, u"{0}".format(skill2_val))
        else:
            self.grid_sim.SetCellValue(row, 3, u"")
            self.grid_sim.SetCellValue(row, 4, u"")
        self.grid_sim.SetCellValue(row, 5, u"{0}".format(slot_num))
