# -*- coding: utf-8 -*-

u"""
スキルIDとスキル名の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

#import singleton

# for skill table
NAME = u"skill_table"
COL_SKILL_ID = u"skill_id"
COL_SKILL_NAME = u"skill_name"
CREATE_SQL = u"""create table if not exists {table} 
    ({skill_id} integer primary key, {skill_name} varchar unique);""".format(
        table=NAME,
        skill_id=COL_SKILL_ID,
        skill_name=COL_SKILL_NAME)
INSERT_SQL = u"""insert into {table} 
    ({skill_id}, {skill_col}) values(?,?);""".format(
        table=NAME,
        skill_id=COL_SKILL_ID,
        skill_col=COL_SKILL_NAME)
SELECT_ID2SKILL_SQL = u"""select {skill_col} from {table} where {skill_id}='{{skill_id}}'""".format(
        skill_id=COL_SKILL_ID,
        skill_col=COL_SKILL_NAME,
        table=NAME)
SELECT_SKILL2ID_SQL = u"""select {skill_id} from {table} where {skill_col}='{{skill_name}}'""".format(
        skill_id=COL_SKILL_ID,
        skill_col=COL_SKILL_NAME,
        table=NAME)
SELECT_ALL_SQL = u"""select {skill_id}, {skill_col} from {table}""".format(
        skill_id=COL_SKILL_ID,
        skill_col=COL_SKILL_NAME,
        table=NAME)


class SkillTableGenerator(object):
    u""" スキルIDとスキル名の組み合わせテーブルを作成するクラス """
    def __init__(self):
        u""" コンストラクタ """
        pass

    def insert_data(self, db_cursor, csv_reader):
        u""" csv_readerからデータを読み込み、 db_cursorへデータを挿入する。"""
        db_cursor.execute(CREATE_SQL)

        csv_reader.next()   # skip header row
        for row in csv_reader:  # (id, name)
            skill_id, skill_name = int(row[0].strip()), row[1].strip()
            try:
                db_cursor.execute(INSERT_SQL, (skill_id, skill_name))
            except sqlite3.IntegrityError, e:
                print "not unique:", skill_name.decode("utf-8")
                raise e


class SkillTableAccessor(object):
    u""" スキルIDとスキル名の組み合わせテーブルへのアクセス用クラス """
    #__metaclass__ = singleton.Singleton
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor
        self._id2name_dict, self._name2id_dict = self._get_dict()

    def _get_dict(self):
        u""" スキルIDからスキル名への変換辞書を得る。
        return (id2name_dict, name2id_dict)"""
        self._cursor.execute(SELECT_ALL_SQL)
        id2name_dict, name2id_dict = {}, {}
        for row in self._cursor.fetchall(): #(id, name)
            skill_id, skill_name = row[0], row[1]
            #if not isinstance(skill_name, unicode):
            #    skill_name = unicode(skill_name, u"utf-8")
            id2name_dict[skill_id] = skill_name
            name2id_dict[skill_name] = skill_id

        return (id2name_dict, name2id_dict)

    def get_dict(self, copied=False):
        u""" スキルIDからスキル名への変換辞書を得る。
        return (id2name_dict, name2id_dict)"""
        if copied is True:
            return (self._id2name_dict.copy(), self._name2id_dict.copy())
        else:
            return (self._id2name_dict, self._name2id_dict)

    def get_id_sorted_names(self, is_desc=False):
        u""" Id順でソートされたスキル名のタプルを返す
        is_desc=Trueで降順にする。"""
        ls = []
        for skill_id, name in sorted(self._id2name_dict.items(), key = lambda x: x[0], reverse=is_desc):
            ls.append(name)
        return tuple(ls)

    def get_skill_name(self, skill_id):
        u""" スキルIDからスキル名を得る 
        存在しない場合はNoneを返す"""
        if skill_id in self._id2name_dict[skill_id]:
            return self._id2name_dict[skill_id]
        else:
            None

    def get_skill_id(self, skill_name):
        u""" スキル名からスキルIdを得る 
        存在しない場合はNoneを返す"""
        if skill_name in self._name2id_dict[skill_name]:
            return self._name2id_dict[skill_name]
        else:
            None


