# -*- coding: utf-8 -*-

u"""
Seed2とテーブルNo.&通し番号の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

# table no of seed2
u""" Seed2とテーブル、No.の表 """
NAME = u"seed2_table_no"
COL_SEED2 = u"seed2"
COL_TABLE_NUMBER = u"table_no"
COL_NUMBER = u"no"
CREATE_SQL = u"""create table if not exists {table_name}
    ({no} integer primary key, {seed} integer unique, {table} integer);""".format(
        table_name=NAME,
        seed=COL_SEED2,
        no=COL_NUMBER,
        table=COL_TABLE_NUMBER)
INSERT_SQL = u"""insert into {table_name}
    ({no}, {seed}, {table}) values(?,?,?);""".format(
        table_name=NAME,
        seed=COL_SEED2,
        no=COL_NUMBER,
        table=COL_TABLE_NUMBER)
SELECT_FROM_SEED2_SQL = u"""select {table_no}, {no} from {table_name}
    where {seed2}={{seed2}}""".format(
        table_name=NAME,
        table_no=COL_TABLE_NUMBER,
        no=COL_NUMBER,
        seed2=COL_SEED2)

class Seed2TableNumberTableGenerator(object):
    u""" Seed2とテーブルNo.&通し番号の組み合わせテーブルの作成するクラス """
    def __init__(self):
        u""" コンストラクタ """
        pass

    def insert_data(self, db_cursor, csv_reader):
        u""" csv_readerからデータを読み込み、 db_cursorへデータを挿入する。"""
        db_cursor.execute(CREATE_SQL)

        csv_reader.next()   # skip header row
        for row in csv_reader:  # (seed2, table_no, no)
            vals = [int(r.strip()) for r in row]
            seed, table_no, no = vals[0], vals[1], vals[2]
            db_cursor.execute(INSERT_SQL, (no, seed, table_no))

class Seed2TableNumberTableAccessor(object):
    u""" Seed2とテーブルNo.&通し番号の組み合わせテーブルへのアクセス用クラス """
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor

    def get_table_nos_from_seed2s(self, seed2s):
        u""" 与えられたSeed2に対応するテーブルNo.と通しNo.を辞書として返す
        rerutn {seed2:(table_no, no)}"""
        result_dict = {}
        for seed2 in seed2s:
            self._cursor.execute(SELECT_FROM_SEED2_SQL.format(seed2=seed2))
            table_no, no = self._cursor.fetchone()
            result_dict[seed2] = (table_no, no)
        return result_dict

    def get_table_no_from_seed2(self, seed2):
        u""" 与えられたSeed2に対応するテーブルNo.と通しNo.を返す
        rerutn (table_no, no)"""
        self._cursor.execute(SELECT_FROM_SEED2_SQL.format(seed2=seed2))
        table_no, no = self._cursor.fetchone()
        return (table_no, no)




