# -*- coding: utf-8 -*-

u"""
SEED2とスキル名の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

import amulettable
import skilltable
#import singleton

# for Seed2 to skill2
u""" SEED2から各お守りの第2スキルへのテーブル """
MASTER_NAME = u"seed2_skill2_master"
NAME = u"seed2_skill2_{amulet_id}"
COL_AMULET_ID = u"amulet_id"
COL_SEED2_SKILL2_TABLE_NAME = u"seed2_skill2_table_name"
COL_SEED2 = u"seed2"
COL_SKILL2_ID1 = u"skill2_id1"
COL_SKILL2_ID2 = u"skill2_id2"
COL_SKILL2_ID3 = u"skill2_id3"
COL_SKILL2_ID4 = u"skill2_id4"
COL_SKILL2_ID5 = u"skill2_id5"
COL_SKILL2_ID6 = u"skill2_id6"
COL_SKILL2_ID7 = u"skill2_id7"
COL_SKILL2_LIST = [COL_SKILL2_ID1, COL_SKILL2_ID2, COL_SKILL2_ID3, COL_SKILL2_ID4, COL_SKILL2_ID5, COL_SKILL2_ID6, COL_SKILL2_ID7]
CREATE_MASTER_SQL = u"""create table if not exists {master}
    (id integer primary key, {amulet_id} integer, {table_name} varchar,
    foreign key(amulet_id) references {amulet_table}(id));""".format(
        master=MASTER_NAME,
        amulet_id=COL_AMULET_ID,
        amulet_table=amulettable.NAME,
        table_name=COL_SEED2_SKILL2_TABLE_NAME)
CREATE_SQL = u"""create table if not exists {{table_name}} 
    (id integer primary key, {seed} integer unique, 
    {skill_id1} integer, {skill_id2} integer, {skill_id3} integer, 
    {skill_id4} integer, {skill_id5} integer, {skill_id6} integer, {skill_id7} integer, 
    foreign key({skill_id1}) references {skill_table}(id),
    foreign key({skill_id2}) references {skill_table}(id),
    foreign key({skill_id3}) references {skill_table}(id),
    foreign key({skill_id4}) references {skill_table}(id),
    foreign key({skill_id5}) references {skill_table}(id),
    foreign key({skill_id6}) references {skill_table}(id),
    foreign key({skill_id7}) references {skill_table}(id));""".format(
        seed=COL_SEED2,
        skill_id1=COL_SKILL2_ID1,
        skill_id2=COL_SKILL2_ID2,
        skill_id3=COL_SKILL2_ID3,
        skill_id4=COL_SKILL2_ID4,
        skill_id5=COL_SKILL2_ID5,
        skill_id6=COL_SKILL2_ID6,
        skill_id7=COL_SKILL2_ID7,
        skill_table=skilltable.NAME)
INSERT_MASTER_SQL = u"""insert into {table}
    ({amulet_col}, {table_col}) values(?,?);""".format(
        table=MASTER_NAME,
        table_col=COL_SEED2_SKILL2_TABLE_NAME,
        amulet_col=COL_AMULET_ID)
INSERT_SQL = u"""insert into {{table_name}}
    ({seed}, {skill_id1}, {skill_id2}, {skill_id3}, 
    {skill_id4}, {skill_id5}, {skill_id6}, {skill_id7}) values(?,?,?,?,?,?,?,?)""".format(
        seed=COL_SEED2,
        skill_id1=COL_SKILL2_ID1,
        skill_id2=COL_SKILL2_ID2,
        skill_id3=COL_SKILL2_ID3,
        skill_id4=COL_SKILL2_ID4,
        skill_id5=COL_SKILL2_ID5,
        skill_id6=COL_SKILL2_ID6,
        skill_id7=COL_SKILL2_ID7)
SELECT_MASTER_ALL_SQL = u"""select {amu_id}, {table_col} from {table}""".format(
        amu_id=COL_AMULET_ID,
        table_col=COL_SEED2_SKILL2_TABLE_NAME,
        table=MASTER_NAME)
SELECT_SEED2_SQL = u"""select {seed} from {{table_name}} """.format(
        seed=COL_SEED2)
SELECT_ALL_SQL = u"""select {seed}, {skill_id1}, {skill_id2}, 
    {skill_id3}, {skill_id4}, {skill_id5}, {skill_id6}, {skill_id7} from {{table_name}} """.format(
        seed=COL_SEED2,
        skill_id1=COL_SKILL2_ID1,
        skill_id2=COL_SKILL2_ID2,
        skill_id3=COL_SKILL2_ID3,
        skill_id4=COL_SKILL2_ID4,
        skill_id5=COL_SKILL2_ID5,
        skill_id6=COL_SKILL2_ID6,
        skill_id7=COL_SKILL2_ID7)
SELECT_ALL_FROM_SEED2_SQL = u"""select {skill_id1}, {skill_id2}, 
    {skill_id3}, {skill_id4}, {skill_id5}, {skill_id6}, {skill_id7} from {{table_name}} where {seed}={{seed2}}""".format(
        seed=COL_SEED2,
        skill_id1=COL_SKILL2_ID1,
        skill_id2=COL_SKILL2_ID2,
        skill_id3=COL_SKILL2_ID3,
        skill_id4=COL_SKILL2_ID4,
        skill_id5=COL_SKILL2_ID5,
        skill_id6=COL_SKILL2_ID6,
        skill_id7=COL_SKILL2_ID7)
COUNT_SKILL2_POS_SQL = u"""select count({seed2}) from {{table_name}} 
where {seed2}={{seed2}} and {{skill_pos}}={{skill2_id}}""".format(
        seed2=COL_SEED2)
SELECT_SEED2_FROM_SKILL2_SQL = u"""select {seed2} from {{table_name}} where
    {skill_id1} = {{skill2_id}} or
    {skill_id2} = {{skill2_id}} or
    {skill_id3} = {{skill2_id}} or
    {skill_id4} = {{skill2_id}} or
    {skill_id5} = {{skill2_id}} or
    {skill_id6} = {{skill2_id}} or
    {skill_id7} = {{skill2_id}} """.format(
        seed2=COL_SEED2,
        skill_id1=COL_SKILL2_ID1,
        skill_id2=COL_SKILL2_ID2,
        skill_id3=COL_SKILL2_ID3,
        skill_id4=COL_SKILL2_ID4,
        skill_id5=COL_SKILL2_ID5,
        skill_id6=COL_SKILL2_ID6,
        skill_id7=COL_SKILL2_ID7)

class Seed2Skill2TableGenerator(object):
    u""" Seed2とスキル名の組み合わせテーブルを作成するクラス """
    def __init__(self):
        u""" コンストラクタ """
        self._amulet_id2skill2_filename_dict = {}

    def insert_master_data(self, db_cursor, csv_reader):
        u""" マスターテーブルを作成する。
        """
        db_cursor.execute(CREATE_MASTER_SQL)
        accessor = amulettable.AmuletTableAccessor(db_cursor)
        amu_id2name, amu_name2id = accessor.get_dict()

        csv_reader.next()   # skip header row
        for row in csv_reader:
            amulet_name = row[0].strip()
            #if not isinstance(amulet_name, unicode):
            #    amulet_name = unicode(amulet_name, u"utf-8")
            skill2_file = row[1].strip()
            amulet_id = amu_name2id[amulet_name]
            table_name = NAME.format(amulet_id=amulet_id)
            self._amulet_id2skill2_filename_dict[amulet_id] = skill2_file
            db_cursor.execute(INSERT_MASTER_SQL, (amulet_id, table_name))

    def get_skill_filenames(self):
        u""" 出現するスキル2が記載されたファイル名をお守りIDに関連付けて返す
        return {amulet_id: skill2_filename}"""
        result_dict = {}
        for amu_id in self._amulet_id2skill2_filename_dict.keys():
            result_dict[amu_id] = self._amulet_id2skill2_filename_dict[amu_id]
        return result_dict

    def insert_data(self, db_cursor, amulet_id2csv_reader_dict):
        u""" お守りIDと関連付けられたcsv_reader(skill2)からデータを読み込み、
        db_cursorへデータを挿入する。
        ammulet_id2csv_readers_dict:{amulet_id:csv_reader_skill2}"""
        accessor = skilltable.SkillTableAccessor(db_cursor)
        skill_id2name, skill_name2id = accessor.get_dict()

        for amulet_id, reader in amulet_id2csv_reader_dict.items():
            table_name = NAME.format(amulet_id=amulet_id)
            db_cursor.execute(CREATE_SQL.format(table_name=table_name))
            insert_values = {}

            reader.next()   # skip header row
            for row in reader:
                seed2 = int(row[0].strip())
                skill_ids = []
                for skill_name in row[1:]:
                    skill_name = skill_name.strip()
                    #if not isinstance(skill_name, unicode):
                    #    skill_name = unicode(skill_name, u"utf-8")
                    skill_ids.append(skill_name2id[skill_name])

                sql = INSERT_SQL.format(table_name=table_name)
                db_cursor.execute(sql, tuple([seed2] + skill_ids))

class Seed2Skill2TableAccessor(object):
    u""" Seed2とスキル名の組み合わせテーブルへのアクセス用クラス """
    #__metaclass__ = singleton.Singleton
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor
        amu_accessor = amulettable.AmuletTableAccessor(db_cursor)
        skill_accessor = skilltable.SkillTableAccessor(db_cursor)
        self._amu_id2name, self._amu_name2id = amu_accessor.get_dict()
        self._skill_id2name, self._skill_name2id = skill_accessor.get_dict()
        self._amu_id2table_name = {}

        self._cursor.execute(SELECT_MASTER_ALL_SQL)
        for row in self._cursor.fetchall():
            amu_id, table_name = row
            self._amu_id2table_name[amu_id] = table_name

    def get_amulet_id2table_name_dict(self, copied=False):
        u""" お守りIDからスキル2テーブル名への変換辞書を返す """
        if copied is True:
            return self._amu_id2table_name.copy()
        else:
            return self._amu_id2table_name

    def select_seed2s_by_ids(self, amu_id2skill_ids):
        u""" お守りIdとスキルIdのリストの辞書からSeed2を特定する 
        skill_ids: (skill_id1, skill_id2, ...., skill_id7)
        不明であればNoneあるいはNO_DATAを入れておくものとする。
        """
        result_set = set()
        for amulet_id, skill_ids in amu_id2skill_ids.items():
            table_name = self._amu_id2table_name[amulet_id]
            where_list = ["{0}={1}".format(col, skill_id) 
                    for col, skill_id in zip(COL_SKILL2_LIST, skill_ids) 
                    if skill_id in self._skill_id2name]
            if len(where_list) == 0:
                continue

            where_sql = " where " + " and ".join(where_list)
            sql = SELECT_SEED2_SQL.format(table_name=table_name) + where_sql
            self._cursor.execute(sql)
            seed2s = set([x[0] for x in self._cursor.fetchall()])
            if len(seed2s) == 0:
                continue

            if len(result_set) != 0:
                result_set &= seed2s
            else:
                result_set = seed2s

        return result_set

    def select_seed2s_by_name(self, amu_name2skill_names):
        u""" お守り名とスキル名のリストの辞書からSeed2を特定する 
        skill_names: (skill_name1, skill_name2, ...., skill_name7)
        不明であればNoneあるいはNO_DATAを入れておくものとする。
        """
        amu_id2skill_ids = {}
        for amu_name, skill_names in amu_name2skill_names.items():
            if amu_name in self._amu_name2id:
                amu_id = self._amu_name2id[amu_name]
            else:
                print u"{0} is not found!".format(amu_name)
                continue
            skill_ids = [self._skill_name2id[name] if name in self._skill_name2id else None
                    for name in skill_names]
            amu_id2skill_ids[amu_id] = skill_ids

        if len(amu_id2skill_ids) > 0:
            return self.select_seed2s_by_ids(amu_id2skill_ids)
        else:
            return set()

    def select_skill_ids_by_seed2(self, seed2):
        u""" seed2から対応するお守りIdごとの第2スキルId(1-7枠)を返す
        return {amulet_id:(skill2_id1, skill2_id2, ..., skill2_id7)}"""
        result_dict = {}
        for amu_id, table_name in self._amu_id2table_name.items():
            sql = SELECT_ALL_FROM_SEED2_SQL.format(table_name=table_name, seed2=seed2)
            self._cursor.execute(sql)
            id1, id2, id3, id4, id5, id6, id7 = self._cursor.fetchone()
            result_dict[amu_id] = (id1, id2, id3, id4, id5, id6, id7)
        return result_dict

    def select_skill_names_by_seed2(self, seed2):
        u""" seed2から対応するお守り名ごとの第2スキル名(1-7枠)を返す
        return {amulet_name:(skill2_name1, skill2_name2, ..., skill2_name7)}"""
        result_dict = {}
        for amu_id, table_name in self._amu_id2table_name.items():
            sql = SELECT_ALL_FROM_SEED2_SQL.format(table_name=table_name, seed2=seed2)
            self._cursor.execute(sql)
            names = [self._skill_id2name[x] for x in self._cursor.fetchone()]
            result_dict[self._amu_id2name[amu_id]] = tuple(names)
        return result_dict

    def select_skill_position_from_seed2_ids(self, amulet_id, seed2, skill2_id):
        u""" 与えられたお守りIdおよびSeed2において、
        指定されたスキルIdが何枠目で発生するのかを返す
        return tuple of index"""
        result_list = []
        table_name = self._amu_id2table_name[amulet_id]
        for i, col in enumerate(COL_SKILL2_LIST):
            sql = COUNT_SKILL2_POS_SQL.format(
                    seed2=seed2,
                    table_name=table_name,
                    skill2_id=skill2_id,
                    skill_pos=col)
            self._cursor.execute(sql)
            count = self._cursor.fetchone()[0]
            if count > 0:
                result_list.append(i)
        return tuple(result_list)

    def select_skill_position_from_seed2_names(self, amulet_name, seed2, skill2_name):
        u""" 与えられたお守り名およびSeed2において、
        指定されたスキル名が何枠目で発生するのかを返す
        return tuple of index"""
        if amulet_name in self._amu_name2id and skill2_name in self._skill_name2id:
            amulet_id = self._amu_name2id[amulet_name]
            skill2_id = self._skill_name2id[skill2_name]
            return self.select_skill_position_from_seed2_ids(amulet_id, seed2, skill2_name)
        else:
            return tuple()

    def select_seed2s_from_skill2_id(self, amulet_id, skill2_id):
        u""" 指定されたお守りIdで指定されたスキルIdを持つSeed2を返す """
        table_name = self._amu_id2table_name[amulet_id]
        sql = SELECT_SEED2_FROM_SKILL2_SQL.format(table_name=table_name,
                skill2_id=skill2_id)
        self._cursor.execute(sql)
        return set([x[0] for x in self._cursor.fetchall()])
