# -*- coding: utf-8 -*-

# constant numbers of MH4
# MH4特有の定数値について
# 2013/12/18 written by kei9 

# no data
NO_DATA = -1

# amulet type
NAME_AMULET0 = u"謎のお守り"
NAME_AMULET1 = u"光るお守り"
NAME_AMULET2 = u"古びたお守り"
NAME_AMULET3 = u"歪んだお守り"
KEY_AMULET0 = u"nazo"
KEY_AMULET1 = u"hika"
KEY_AMULET2 = u"huru"
KEY_AMULET3 = u"yuga"

# flag to dicide which seed2 or seed1 to use to calc threshold
SEED_DECIDE_FLAG = 128

# slot point for decision to amulet type
SLOT_POINT0 = 0
SLOT_POINT1 = 2
SLOT_POINT2 = 4
SLOT_POINT3 = 6

# -- archamy type --
# tenun555
KEY_TENUN555 = u"tenun555"
TENUN555_MIN = 3
TENUN555_MAX = 6
TENUN555_DIVISOR = 85

# tenun888
KEY_TENUN888 = u"tenun888"
TENUN888_MIN = 5
TENUN888_MAX = 7
TENUN888_DIVISOR = 100

# alchemy: tenun nazo
TENUN_NAZO_LOOPTIME = 1147

# alchemy: tenun hikaru
TENUN_HIKA_LOOPTIME = 1108
TENUN_HIKA_BORDER = 35
TENUN_HIKA_MODE = 4

# alchemy: tenun huru
TENUN_YUGA_LOOPTIME = 1723

# alchemy: tenun yuga
TENUN_YUGA_LOOPTIME = 1189

# alchemy: inishie
KEY_INISHIE = u"inishie"
INISHIE_LOOPTIME = 1723

# alchemy: koumyou
KEY_KOUMYOU = u"koumyou"
KOUMYOU_LOOPTIME = 1108

# alchemy: nazo
KEY_NAZO = u"nazo"
NAZO_LOOPTIME = 1147

# skill2 border
SKILL2_BORDER_DICT = {}
SKILL2_BORDER_DICT[NAME_AMULET0] = 100   # nazo
SKILL2_BORDER_DICT[NAME_AMULET1] = 35   # hika
SKILL2_BORDER_DICT[NAME_AMULET2] = 25   # huru
SKILL2_BORDER_DICT[NAME_AMULET3] = 20   # yuga


# amulet
INISHIE_AMULET = u"古びたお守り"
TENUN888_AMULET = u"歪んだお守り"

# type
TYPE_SHINPI = u"神秘の護石"
TYPE_MICHI = u"未知の護石"
TYPE_RYU = u"龍の護石"
TYPE_OU = u"王の護石"
TYPE_JOUOU = u"女王の護石"
TYPE_JOUSAI = u"城塞の護石"
TYPE_KISHI = u"騎士の護石"
TYPE_TOUSHI = u"闘士の護石"
TYPE_HEISHI = u"兵士の護石"

# type border
TYPE_BORDER_DICT = {}
TYPE_BORDER_DICT[NAME_AMULET0] = ((0, TYPE_HEISHI), (8, TYPE_TOUSHI), (8, TYPE_TOUSHI))
TYPE_BORDER_DICT[NAME_AMULET1] = ((0, TYPE_KISHI), (8, TYPE_JOUSAI), (8, TYPE_JOUSAI))
TYPE_BORDER_DICT[NAME_AMULET2] = ((0, TYPE_JOUOU), (8, TYPE_OU), (13, TYPE_RYU))
TYPE_BORDER_DICT[NAME_AMULET3] = ((0, TYPE_MICHI), (16, TYPE_SHINPI), (16, TYPE_SHINPI))
