# -*- coding:utf-8 -*-

# generate pyinstaller's spec file & modify .spec file
# 2013/12/07 written by kei9

import subprocess
import tempfile
import os
import os.path
import sys
import shutil

import convertcoding
func = lambda path_list: os.path.join(convertcoding.convert_unicode(
    os.path.dirname(os.path.abspath(__file__))), *path_list)
BUNDLE_RESOURCES = [(ur"view/mainframe.xrc", func([u"view", u"mainframe.xrc"])),
       (ur"view/gaugedialog.xrc", func([u"view", u"gaugedialog.xrc"])),
       (ur"view/memodialog.xrc", func([u"view", u"memodialog.xrc"]))]
MOVE_FILES = [u"data.zip", u"readme.txt", u"license.txt"]

SCRIPTFILE = u"amulettool.py"
APPNAME = u"AmuletToolsMH4"

MAKESPEC = u"pyi-makespec"
PYINSTALLER = u"pyinstaller"
ICONFILE_WIN = u"icon/amulettoolsmh4.ico"
ICONFILE_MAC = u"icon/amulettoolsmh4.icns"

SPECOPTIONS_WIN = [u"--onefile", u"--windowed", u"--icon=" + ICONFILE_WIN, u"--name=" + APPNAME]
SPECOPTIONS_MAC = [u"--onefile", u"--windowed", u"--icon=" + ICONFILE_MAC, u"--name=" + APPNAME]
SPECOPTIONS_LINUX = [u"--onefile", u"--windowed", u"--name=" + APPNAME]

def get_insert_lines():
    result = []
    for item in BUNDLE_RESOURCES:
        result.append(ur'a.datas += [("{0}", r"{1}", "DATA")]'.format(item[0], item[1]) + "\n")
    return result

if __name__ == "__main__":
    print u"file path: ", os.path.dirname(os.path.abspath(__file__))

    if sys.platform.startswith(u"win"):
        cmd = [MAKESPEC] + SPECOPTIONS_WIN + [SCRIPTFILE]
    elif sys.platform.startswith(u"linux"):
        cmd = [MAKESPEC] + SPECOPTIONS_LINUX + [SCRIPTFILE]
    elif sys.platform.startswith(u"darwin"):
        cmd = [MAKESPEC] + SPECOPTIONS_MAC + [SCRIPTFILE]
    else:
        raise OSError(u"this operating system is not supported!")
    print " ".join(cmd)
    out = subprocess.check_output(cmd)
    print out


    # insert bundle data line to .spec
    print "insert bundle resources to .spec file"
    specfile = APPNAME + ".spec"
    with tempfile.NamedTemporaryFile(delete=False) as tmp_file:
        tmpname = tmp_file.name
        with open(specfile, "r") as f:
            for line in f:
                if line.startswith("pyz"):
                    for l in get_insert_lines():
                        tmp_file.write(l)
                tmp_file.write(line)

    os.remove(specfile)
    os.rename(tmpname, specfile)


    # conduct pyinstall
    cmd = [PYINSTALLER, specfile]
    print " ".join(cmd)
    out = subprocess.check_output(cmd)
    print out

    # copy file to dist 
    file_dir = os.path.dirname(os.path.abspath(__file__))
    for f in MOVE_FILES:
        abs_path = os.path.abspath(f)
        relative_path = os.path.relpath(abs_path, file_dir)
        shutil.copy(abs_path, os.path.join("dist", relative_path))

    print "Finished"
