# -*- coding: utf-8 -*-

u"""
    Conversion Function str to unicode
    2013/12/14 written by kei9
"""

codecs = [u'utf-8',u'cp932',u'shift_jis',u'euc_jp',
        u'euc_jis_2004',u'euc_jisx0213',u'iso2022_jp',u'iso2022_jp_1',
        u'iso2022_jp_2',u'iso2022_jp_2004',u'iso2022_jp_3',u'iso2022_jp_ext',
        u'shift_jis_2004',u'shift_jisx0213',u'utf_16',u'utf_16_be',
        u'utf_16_le',u'utf_7',u'utf_8_sig'];

def convert_unicode(data):
    u""" str型の引数をunicodeへの変換を試みる。
    変換が可能であれば変換後のunicode文字列と、引数のcodecを返す。
    変換ができない場合はNoneを返す
    return:
        when data is unicode
            data
        when data can decode to unicode
            uni_str
        cannot decode
            None
    """
    if isinstance(data, basestring):
        if isinstance(data, unicode):
            # when data isunicode
            return data

        f = lambda d, enc: d.decode(enc);
        for codec in codecs:
            try:
                return f(data, codec);
            except: continue;
        return None;
    else:
        # data isn't string
        return None
