# -*- coding: utf-8 -*-

# メモ入力用ダイアログ
# 2013/12/20 written by kei9
import wx
from wx import xrc

import constnumbers
import singleton

class MemoDialogView(object):
    u""" メモ入力用ダイアログ """
    __metaclass__ = singleton.Singleton
    def __init__(self, filename):
        self.res = wx.xrc.XmlResource(filename)
        self._init_dialog()

    def _init_dialog(self):
        # load controls
        self.dialog = self.res.LoadDialog(None, "MemoDialog")
        self.text = xrc.XRCCTRL(self.dialog, "TextCtrlMemo")
        self.button = xrc.XRCCTRL(self.dialog, "wxID_OK")

        self.ID_BUTTON_OK = xrc.XRCID("wxID_OK")
        # "self.ID_BUTTON_OK" same as "wx.ID_OK"

    def Show(self):
        self.ret_code = self.dialog.Show()
        return self.ret_code

    def Hide(self):
        self.dialog.Hide()

    def ShowModal(self):
        self.ret_code = self.dialog.ShowModal()
        return self.ret_code

    def Destroy(self):
        self.dialog.Destroy()

