# -*- coding: utf-8 -*-

u"""
充足値から判定値の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

import amulettable
#import singleton

# for sufficient value for slots
MASTER_NAME = u"sufficient_master"
NAME = u"sufficient_{amulet_id}"
COL_AMULET_ID = u"amulet_id"
COL_NAME = u"sufficient_table_name"
COL_SUFFICIENT_VALUE = u"sufficient_value"
COL_SLOT1_THRESHOLD = u"slot1_threshold"
COL_SLOT2_THRESHOLD = u"slot2_threshold"
COL_SLOT3_THRESHOLD = u"slot3_threshold"
CREATE_MASTER_SQL = u"""create table if not exists {master}
    (id integer primary key, {amulet_id} integer, {table_name} varchar, 
    foreign key({amulet_id}) references {amulet_table}(id));""".format(
        master=MASTER_NAME,
        amulet_id=COL_AMULET_ID,
        amulet_table=amulettable.NAME,
        table_name=COL_NAME)
CREATE_SQL = u"""create table if not exists {{table_name}} 
    (id integer primary key, {sufficient_val} integer unique, 
    {slot1_val} integer, {slot2_val} integer, {slot3_val} integer) ;""".format(
        sufficient_val=COL_SUFFICIENT_VALUE,
        slot1_val=COL_SLOT1_THRESHOLD,
        slot2_val=COL_SLOT2_THRESHOLD,
        slot3_val=COL_SLOT3_THRESHOLD)
INSERT_MASTER_SQL = u"""insert into {table}
    ({amulet_col}, {table_col}) values(?,?);""".format(
        table=MASTER_NAME,
        table_col=COL_NAME,
        amulet_col=COL_AMULET_ID)
INSERT_SQL = u"""insert into {{table_name}}
    ({sufficient_val}, {slot1_val}, {slot2_val}, {slot3_val})
    values(?,?,?,?);""".format(
        sufficient_val=COL_SUFFICIENT_VALUE,
        slot1_val=COL_SLOT1_THRESHOLD,
        slot2_val=COL_SLOT2_THRESHOLD,
        slot3_val=COL_SLOT3_THRESHOLD)
SELECT_MASTER_ALL_SQL = u"""select {amu_id}, {table_col} from {table}""".format(
        amu_id=COL_AMULET_ID,
        table_col=COL_NAME,
        table=MASTER_NAME)
SELECT_ALL_SQL = u"""select {sufficient_val}, {slot1_val}, {slot2_val}, {slot3_val} from {{table_name}}""".format(
        sufficient_val=COL_SUFFICIENT_VALUE,
        slot1_val=COL_SLOT1_THRESHOLD,
        slot2_val=COL_SLOT2_THRESHOLD,
        slot3_val=COL_SLOT3_THRESHOLD)
SELECT_THRESHOLD_SQL = u"""select {slot1_val}, {slot2_val}, {slot3_val} from {{table_name}}
    where {sufficient_val}={{sufficient_val}}""".format(
        sufficient_val=COL_SUFFICIENT_VALUE,
        slot1_val=COL_SLOT1_THRESHOLD,
        slot2_val=COL_SLOT2_THRESHOLD,
        slot3_val=COL_SLOT3_THRESHOLD)

class SufficientTableGenerator(object):
    u"""充足値から判定値の組み合わせテーブルの作成をするクラス"""
    def __init__(self):
        u""" コンストラクタ """
        self._amulet_id2suff_filename_dict = {}

    def insert_master_data(self, db_cursor, csv_reader):
        u""" マスターテーブルを作成する。
        """
        db_cursor.execute(CREATE_MASTER_SQL)
        accessor = amulettable.AmuletTableAccessor(db_cursor)
        amu_id2name, amu_name2id = accessor.get_dict()

        csv_reader.next()   # skip header row
        for row in csv_reader: # (omamori_name, filename of sufficient values)
            amulet_name = row[0].strip()
            #if not isinstance(amulet_name, unicode):
            #    amulet_name = unicode(amulet_name, u"utf-8")
            suff_file = row[1].strip()
            amulet_id = amu_name2id[amulet_name]
            table_name = NAME.format(amulet_id=amulet_id)
            self._amulet_id2suff_filename_dict[amulet_id] = suff_file
            db_cursor.execute(INSERT_MASTER_SQL, (amulet_id, table_name))

    def get_skill_filenames(self):
        u""" スキル1, スキル2の最大最小が記載されたファイル名をお守りIDに関連付けて返す
        return {amulet_id:(skill1_filename, skill2_filename)}"""
        result_dict = {}
        for amu_id in self._amulet_id2suff_filename_dict.keys():
            result_dict[amu_id] = self._amulet_id2suff_filename_dict[amu_id]
        return result_dict

    def insert_data(self, db_cursor, amulet_id2csv_reader_dict):
        u""" お守りIDと関連付けられたcsv_reader(sufficient)からデータを読み込み、
        db_cursorへデータを挿入する。
        ammulet_id2csv_reader_dict:{amulet_id:csv_reader_sufficient}"""
        for amulet_id, reader in amulet_id2csv_reader_dict.items():
            table_name = NAME.format(amulet_id=amulet_id)
            db_cursor.execute(CREATE_SQL.format(table_name=table_name))

            reader.next()  # skip header
            insert_sql = INSERT_SQL.format(table_name=table_name)
            for row_vals in reader:
                val_tup = tuple([int(x.strip()) for x in row_vals])
                db_cursor.execute(insert_sql, val_tup)

class SufficientTableAccessor(object):
    u"""充足値から判定値の組み合わせテーブルへのアクセスをするクラス"""
    #__metaclass__ = singleton.Singleton
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor
        accessor = amulettable.AmuletTableAccessor(db_cursor)
        self._amu_id2name, self._amu_name2id = accessor.get_dict()
        self._amu_id2table_name = {}

        self._cursor.execute(SELECT_MASTER_ALL_SQL)
        for row in self._cursor.fetchall():
            amu_id, table_name = row
            self._amu_id2table_name[amu_id] = table_name

    def select_thresholds_by_id(self, amulet_id, sufficient_val):
        u""" お守りIdと充足値から、スロットごとの判定値を得る """
        table_name = self._amu_id2table_name[amulet_id]
        sql = SELECT_THRESHOLD_SQL.format(table_name=table_name, sufficient_val=sufficient_val)
        self._cursor.execute(sql)
        th_slot1, th_slot2, th_slot3 = self._cursor.fetchone()
        return (th_slot1, th_slot2, th_slot3)

    def select_thresholds_by_name(self, amulet_name, sufficient_val):
        u""" お守り名と充足値から、スロットごとの判定値を得る """
        amulet_id = self._amu_name2id[amulet_name]
        return self.select_thresholds_by_id(amulet_id, sufficient_val)
