# -*- coding: utf-8 -*-

u"""
Seed2と判定値の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

#import singleton

# for seed2 to threshold1
u""" SEED2から判定値1へのテーブル """
NAME = u"seed2_threshold{index}"
COL_SEED2 = u"seed2"
COL_THRESHOLD1 = u"threshold1"
COL_THRESHOLD2 = u"threshold2"
COL_THRESHOLD3 = u"threshold3"
COL_THRESHOLD4 = u"threshold4"
COL_THRESHOLD5 = u"threshold5"
COL_THRESHOLD6 = u"threshold6"
COL_THRESHOLD7 = u"threshold7"
COL_THRESHOLD_LIST = [COL_THRESHOLD1, COL_THRESHOLD2, COL_THRESHOLD3, COL_THRESHOLD4, COL_THRESHOLD5, COL_THRESHOLD6, COL_THRESHOLD7]
CREATE_SQL = u"""create table if not exists {{table_name}}
    (id integer primary key, {seed} integer unique,
    {threshold1} integer, {threshold2} integer, {threshold3} integer,
    {threshold4} integer, {threshold5} integer, {threshold6} integer, {threshold7} integer);""".format(
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        threshold3=COL_THRESHOLD3,
        threshold4=COL_THRESHOLD4,
        threshold5=COL_THRESHOLD5,
        threshold6=COL_THRESHOLD6,
        threshold7=COL_THRESHOLD7)
INSERT_SQL = u"""insert into {{table_name}}
    ({seed}, {threshold1}, {threshold2}, {threshold3}, {threshold4}, {threshold5}, {threshold6}, {threshold7})
    values(?,?,?,?,?,?,?,?);""".format(
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        threshold3=COL_THRESHOLD3,
        threshold4=COL_THRESHOLD4,
        threshold5=COL_THRESHOLD5,
        threshold6=COL_THRESHOLD6,
        threshold7=COL_THRESHOLD7)
SELECT_ALL_SQL = u"""select {seed}, {threshold1}, {threshold2},
    {threshold3}, {threshold4}, {threshold5}, {threshold6}, {threshold7} from {{table_name}} """.format(
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        threshold3=COL_THRESHOLD3,
        threshold4=COL_THRESHOLD4,
        threshold5=COL_THRESHOLD5,
        threshold6=COL_THRESHOLD6,
        threshold7=COL_THRESHOLD7)
SELECT_SEEDS_FROM_THRESHOLD_SQL = u"""
    select {seed} from {{table_name}} 
    where {threshold1} >= {{threshold}} or 
    {threshold2} >= {{threshold}} or 
    {threshold3} >= {{threshold}} or 
    {threshold4} >= {{threshold}} or 
    {threshold5} >= {{threshold}} or 
    {threshold6} >= {{threshold}} or 
    {threshold7} >= {{threshold}}
    """.format(
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        threshold3=COL_THRESHOLD3,
        threshold4=COL_THRESHOLD4,
        threshold5=COL_THRESHOLD5,
        threshold6=COL_THRESHOLD6,
        threshold7=COL_THRESHOLD7)
SELECT_SEEDS_FROM_THRESHOLD_COL_SQL = u"""
    select {seed} from {{table_name}} 
    where {{threshold_col}} >= {{threshold}}
    """.format(seed=COL_SEED2)
SELECT_THRESHOLDS_FROM_SEED2_SQL = u""" select
    {threshold1}, {threshold2}, {threshold3}, 
    {threshold4}, {threshold5}, {threshold6}, {threshold7} 
    from {{table_name}} where {seed}={{seed2}}
    """.format(
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        threshold3=COL_THRESHOLD3,
        threshold4=COL_THRESHOLD4,
        threshold5=COL_THRESHOLD5,
        threshold6=COL_THRESHOLD6,
        threshold7=COL_THRESHOLD7)

class Seed2ThresholdTableGenerator(object):
    u""" Seed2と判定値の組み合わせテーブルの作成するクラス """
    def __init__(self):
        u""" コンストラクタ。"""
        pass

    def insert_data(self, db_cursor, csv_reader, index):
        u""" csv_readerからデータを読み込み、 db_cursorへデータを挿入する。
        indexでどの判定値についてのものかを決定する """
        table_name = NAME.format(index=index)
        db_cursor.execute(CREATE_SQL.format(table_name=table_name))

        csv_reader.next()   # skip header row
        for row in csv_reader:  #(seed2, threshold1, threshold2, ..., threshold7)
            vals = [int(r.strip()) for r in row]
            db_cursor.execute(INSERT_SQL.format(table_name=table_name), tuple(vals))

class Seed2ThresholdTableAccessor(object):
    u""" Seed2と判定値の組み合わせテーブルへのアクセス用クラス """
    #__metaclass__ = singleton.Singleton
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor

    def select_thresholds_from_seed2(self, seed2, index):
        u""" 指定されたindexの表からのseed2から判定値1-7を返す """
        table_name = NAME.format(index=index)
        sql = SELECT_THRESHOLDS_FROM_SEED2_SQL.format(
                table_name=table_name, seed2=seed2)
        self._cursor.execute(sql)
        th1, th2, th3, th4, th5, th6, th7 = self._cursor.fetchone()
        return (th1, th2, th3, th4, th5, th6, th7)

    def select_seed2s_from_all_threshold(self, threshold, index):
        u""" 指定された値以上の判定値を一つでも持つseed2を返す """
        table_name = NAME.format(index=index)
        sql = SELECT_SEEDS_FROM_THRESHOLD_SQL.format(
                table_name=table_name, threshold=threshold)
        self._cursor.execute(sql)
        seeds = set([x[0] for x in self._cursor.fetchall()])
        return seeds

    def select_seed2s_from_theshold_index(self, threshold, index, amulet_pos):
        u""" 指定された枠(amulet_pos)に、
        指定値以上の判定値を一つでも持つseed2を返す """
        table_name = NAME.format(index=index)
        sql = SELECT_SEEDS_FROM_THRESHOLD_SQL.format(
                table_name=table_name, threshold=threshold,
                threshold_col=COL_THRESHOLD_LIST[amulet_pos])
        self._cursor.execute(sql)
        seeds = set([x[0] for x in self._cursor.fetchall()])
        return seeds
