# -*- coding: utf-8 -*-

u"""
Seed2と古の錬金結果の組合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

import skilltable

# seed2 -> inishie table
u""" 古の錬金テーブル """
NAME = u"seed2_inishie"
COL_SEED2 = u"seed2"
COL_SKILL2_ID = u"skill2_id"
COL_THRESHOLD1 = u"treshold1"
COL_THRESHOLD2 = u"treshold2"
CREATE_SQL = u"""create table if not exists {table_name} 
    (id integer primary key, {seed} integer unique, 
    {skill_id} integer, {threshold1} integer, {threshold2} integer,
    foreign key({skill_id}) references {skill_table}(id));""".format(
        table_name=NAME,
        seed=COL_SEED2,
        skill_id=COL_SKILL2_ID,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        skill_table=skilltable.NAME)
INSERT_SQL = u"""insert into {table_name}
    ({seed}, {skill_id}, {threshold1}, {threshold2}) values(?,?,?,?)""".format(
        table_name=NAME,
        seed=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        skill_id=COL_SKILL2_ID)
SELECT_FROM_SEED2_SQL = u"""select {skill_id}, {threshold1}, {threshold2}
    from {table_name} where {seed2}={{seed2}}""".format(
        table_name=NAME,
        seed2=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        skill_id=COL_SKILL2_ID)
SELECT_SEED2_FROM_SKILL2_THRESHOLD_SQL = u"""select {seed2}
    from {table_name} where {skill_id}={{skill2_id}} and 
    ({threshold1}>={{threshold}} or {threshold2}>={{threshold}})""".format(
        table_name=NAME,
        seed2=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2,
        skill_id=COL_SKILL2_ID)
SELECT_SEED2_FROM_THRESHOLD_SQL = u"""select {seed2}
    from {table_name} where {threshold1}>={{threshold}} or {threshold2}>={{threshold}}""".format(
        table_name=NAME,
        seed2=COL_SEED2,
        threshold1=COL_THRESHOLD1,
        threshold2=COL_THRESHOLD2)

class Seed2InishieTableGenerator(object):
    u""" Seed2とテーブルNo.&通し番号の組み合わせテーブルの作成するクラス """
    def __init__(self):
        u""" コンストラクタ """
        pass

    def insert_data(self, db_cursor, csv_reader):
        u""" csv_readerからデータを読み込み、 db_cursorへデータを挿入する。"""
        db_cursor.execute(CREATE_SQL)
        accessor = skilltable.SkillTableAccessor(db_cursor)
        skill_id2name, skill_name2id = accessor.get_dict()

        csv_reader.next()   # skip header row
        for row in csv_reader:  # (seed2, skill_name, th1, th2)
            skill_name = row[1].strip()
            #if not isinstance(skill_name, unicode):
            #    skill_name = unicode(skill_name, u"utf-8")
            skill_id = skill_name2id[skill_name]
            seed2, th1, th2 = int(row[0].strip()), int(row[2].strip()), int(row[3].strip())
            db_cursor.execute(INSERT_SQL, (seed2, skill_id, th1, th2))


class Seed2InishieTableAccessor(object):
    u"""Seed2と古の錬金結果の組合わせテーブルへのアクセスをするクラス"""
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor
        accessor = skilltable.SkillTableAccessor(db_cursor)
        self._skill_id2name, self._skill_name2id = accessor.get_dict()

    def select_ids_from_seed2(self, seed2):
        u""" Seed2に対応するスキルId、判定値1, 判定値2を返す """
        sql = SELECT_FROM_SEED2_SQL.format(seed2=seed2)
        self._cursor.execute(sql)
        skill_id, th1, th2 = self._cursor.fetchone()
        return (skill_id, th1, th2)

    def select_names_from_seed2(self, seed2):
        u""" Seed2に対応するスキル名、判定値1, 判定値2を返す """
        sql = SELECT_FROM_SEED2_SQL.format(seed2=seed2)
        self._cursor.execute(sql)
        skill_id, th1, th2 = self._cursor.fetchone()
        return (self._skill_id2name[skill_id], th1, th2)


