# -*- coding: utf-8 -*-

# random generator for MH4
# データベース関連の定数値など
# 2013/12/18 written by kei9 

# import modules
import mh4constnumbers

class RandomGenerator():
    u""" MH4での乱数生成器 """
    COEFFICIENT = 176
    DIVISOR = 65363

    def __init__(self, seed):
        self._first_seed = seed
        self._next_seed = seed

    def get_next(self):
        u""" 前回の乱数値より次の乱数値を計算する """
        self._next_seed = self._get_next_rand(self._next_seed)
        return self._next_seed

    def _get_next_rand(self, seed):
        u""" 指定されたseedから乱数を生成する """
        return seed * self.COEFFICIENT % self.DIVISOR


