# -*- coding: utf-8 -*-

u"""
IDとお守り名の組み合わせテーブルの作成・アクセスをするモジュール
2013/12/19 written by kei9
"""

import sqlite3
import csv

#import singleton

# for amulet table
NAME = u"amulet_table"
COL_AMULET_NAME = u"amulet_name"
CREATE_SQL = u"""create table if not exists {table} 
    (id integer primary key, {amulet_name} varchar unique);""".format(
        table=NAME, 
        amulet_name=COL_AMULET_NAME)
INSERT_SQL = u"""insert into {table}
    ({amulet_col}) values(?);""".format(
        table=NAME,
        amulet_col=COL_AMULET_NAME)
SELECT_ID2NAME_SQL = u"""select {amulet_col} from {table} where id='{{id}}'""".format(
        amulet_col=COL_AMULET_NAME,
        table=NAME)
SELECT_NAME2ID_SQL = u"""select id from {table} where {amulet_col}='{{amulet_name}}'""".format(
        amulet_col=COL_AMULET_NAME,
        table=NAME)
SELECT_ALL_SQL = u"""select id, {amulet_col} from {table}""".format(
        amulet_col=COL_AMULET_NAME,
        table=NAME)

class AmuletTableGenerator(object):
    u""" IDとお守り名の組み合わせテーブルを作成するクラス """
    def __init__(self):
        u""" コンストラクタ """
        pass

    def insert_data(self, db_cursor, csv_reader):
        u""" csv_readerからデータを読み込み、 db_cursorへデータを挿入する。"""
        db_cursor.execute(CREATE_SQL)

        csv_reader.next()   # skip header row
        for row in csv_reader:  # (name)
            amulet_name = row[0].strip()
            try:
                db_cursor.execute(INSERT_SQL, (amulet_name,))
            except sqlite3.IntegrityError, e:
                print "not unique:", amulet_name.decode("utf-8")
                raise e


class AmuletTableAccessor(object):
    u""" お守りIDとお守り名の組み合わせテーブルへのアクセス用クラス """
    #__metaclass__ = singleton.Singleton
    def __init__(self, db_cursor):
        u""" db_cursor: cursor of sqlite3 database """
        self._cursor = db_cursor
        self._id2name_dict, self._name2id_dict = self._get_dict()

    def _get_dict(self, unicodeing=False):
        u""" お守りIDからお守り名への変換辞書を得る。
        return (id2name_dict, name2id_dict)"""
        self._cursor.execute(SELECT_ALL_SQL)
        id2name_dict, name2id_dict = {}, {}
        for row in self._cursor.fetchall(): #(id, name)
            amulet_id, amulet_name = row[0], row[1]
            #if not isinstance(amulet_name, unicode):
            #    amulet_name = unicode(amulet_name, u"utf-8")
            id2name_dict[amulet_id] = amulet_name
            name2id_dict[amulet_name] = amulet_id

        return (id2name_dict, name2id_dict)

    def get_dict(self, copied=False):
        u""" お守りIDからお守り名への変換辞書を得る。
        return (id2name_dict, name2id_dict)"""
        if copied is True:
            return (self._id2name_dict.copy(), self._name2id_dict.copy())
        else:
            return (self._id2name_dict, self._name2id_dict)

    def get_id_sorted_names(self, is_desc=False):
        u""" Id順でソートされたお守り名のタプルを返す
        is_desc=Trueで降順にする。"""
        ls = []
        for amu_id, name in sorted(self._id2name_dict.items(), key = lambda x: x[0], reverse=is_desc):
            ls.append(name)
        return tuple(ls)

    def get_amulet_name(self, skill_id):
        u""" お守りIDからお守り名を得る 
        存在しない場合はNoneを返す"""
        if skill_id in self._id2name_dict[skill_id]:
            return self._id2name_dict[skill_id]
        else:
            None

    def get_amulet_id(self, skill_name):
        u""" お守り名からお守りIdを得る 
        存在しない場合はNoneを返す"""
        if skill_name in self._name2id_dict[skill_name]:
            return self._name2id_dict[skill_name]
        else:
            None


