/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.custom.tree2.TreeNode;
import org.apache.myfaces.custom.tree2.TreeWalker;
import org.apache.myfaces.custom.tree2.UITreeData;

public class TreeWalkerBase
implements TreeWalker {
    private String ROOT_NODE_ID = "0";
    private String TREE_NODE_SEPARATOR = ":";
    private UITreeData tree;
    private Stack nodeStack = new Stack();
    private Stack idStack = new Stack();
    private boolean checkState = true;
    private boolean startedWalking = false;

    public void setTree(UITreeData tree) {
        this.tree = tree;
    }

    public boolean isCheckState() {
        return this.checkState;
    }

    public void setCheckState(boolean checkState) {
        this.checkState = checkState;
    }

    public boolean next() {
        if (!this.startedWalking) {
            this.idStack.push(this.ROOT_NODE_ID);
            this.tree.setNodeId(this.ROOT_NODE_ID);
            this.nodeStack.push(this.tree.getNode());
            this.startedWalking = true;
            return true;
        }
        if (this.nodeStack.isEmpty()) {
            return false;
        }
        TreeNode prevNode = (TreeNode)this.nodeStack.peek();
        String prevNodeId = (String)this.idStack.peek();
        if (prevNode.isLeaf()) {
            this.nodeStack.pop();
            this.idStack.pop();
            return this.next();
        }
        TreeNode nextNode = null;
        String nextNodeId = null;
        if (prevNodeId.equals(this.tree.getNodeId())) {
            nextNodeId = prevNodeId + this.TREE_NODE_SEPARATOR + "0";
            if (this.checkState && !this.tree.getDataModel().getTreeState().isNodeExpanded(prevNodeId)) {
                this.nodeStack.pop();
                this.idStack.pop();
                return this.next();
            }
        } else {
            String currentNodeId = this.tree.getNodeId();
            String parentNodeId = StringUtils.substringBeforeLast((String)currentNodeId, (String)this.TREE_NODE_SEPARATOR);
            this.tree.setNodeId(parentNodeId);
            TreeNode parentNode = this.tree.getNode();
            int siblingCount = Integer.parseInt(currentNodeId.substring(parentNodeId.length() + 1));
            if (++siblingCount == parentNode.getChildCount()) {
                this.nodeStack.pop();
                this.idStack.pop();
                return this.next();
            }
            nextNodeId = parentNodeId + this.TREE_NODE_SEPARATOR + siblingCount;
        }
        this.tree.setNodeId(nextNodeId);
        nextNode = this.tree.getNode();
        this.nodeStack.push(nextNode);
        this.idStack.push(nextNodeId);
        return true;
    }

    public String getRootNodeId() {
        return this.ROOT_NODE_ID;
    }

    public void reset() {
        this.nodeStack.empty();
        this.idStack.empty();
        this.startedWalking = false;
    }
}

