/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.util.ArrayList;
import org.apache.myfaces.shared_impl.util.ArrayUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isFloatNoExponent(String str) {
        int i;
        int len = str.length();
        if (len == 0) {
            return false;
        }
        char c = str.charAt(0);
        int n = i = c == '-' || c == '+' ? 1 : 0;
        if (i >= len) {
            return false;
        }
        boolean decimalPointFound = false;
        do {
            if ((c = str.charAt(i)) == '.') {
                if (decimalPointFound) {
                    return false;
                }
                decimalPointFound = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        } while (++i < len);
        return true;
    }

    public static boolean isFloatWithOptionalExponent(String str) {
        int i;
        int len = str.length();
        if (len == 0) {
            return false;
        }
        char c = str.charAt(0);
        int n = i = c == '-' || c == '+' ? 1 : 0;
        if (i >= len) {
            return false;
        }
        boolean exponentFound = false;
        boolean decimalPointFound = false;
        block4: do {
            c = str.charAt(i);
            switch (c) {
                case '.': {
                    if (decimalPointFound || exponentFound) {
                        return false;
                    }
                    decimalPointFound = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (exponentFound) {
                        return false;
                    }
                    exponentFound = true;
                    c = str.charAt(i + 1);
                    if (c != '-' && c != '+') continue block4;
                    ++i;
                    break;
                }
                default: {
                    if (Character.isDigit(c)) continue block4;
                    return false;
                }
            }
        } while (++i < len);
        return true;
    }

    public static boolean isInteger(String str) {
        int i;
        int len = str.length();
        if (len == 0) {
            return false;
        }
        char c = str.charAt(0);
        int n = i = c == '-' || c == '+' ? 1 : 0;
        if (i >= len) {
            return false;
        }
        do {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        } while (++i < len);
        return true;
    }

    public static boolean isUnsignedInteger(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String dequote(String str, char quote) {
        if (str == null) {
            return null;
        }
        return StringUtils.dequote(str, 0, str.length(), quote);
    }

    public static String dequote(String str, int begin, int end, char quote) {
        if (begin == end) {
            return "";
        }
        int end_ = str.indexOf(quote, begin);
        if (end_ < 0) {
            return str.substring(begin, end);
        }
        StringBuffer sb = new StringBuffer(end - begin);
        int begin_ = begin;
        while (end_ >= 0 && end_ < end) {
            if (end_ + 1 >= end || str.charAt(end_ + 1) != quote) {
                throw new IllegalArgumentException("Internal quote not doubled in string '" + str.substring(begin, end) + "'");
            }
            sb.append(StringUtils.substring(str, begin_, end_)).append(quote);
            begin_ = end_ + 2;
            end_ = str.indexOf(quote, begin_);
        }
        return sb.append(StringUtils.substring(str, begin_, end)).toString();
    }

    public static String dequoteFull(String str, char quote) {
        if (str == null) {
            return null;
        }
        return StringUtils.dequoteFull(str, 0, str.length(), quote);
    }

    public static String dequoteFull(String str, int begin, int end, char quote) {
        if (begin == end) {
            return "";
        }
        if (str.charAt(begin) != quote) {
            return str.substring(begin, end);
        }
        int _end = end - 1;
        if (str.length() < 2 || str.charAt(_end) != quote) {
            throw new IllegalArgumentException("Closing quote missing in string '" + StringUtils.substring(str, begin, end) + "'");
        }
        return StringUtils.dequote(str, begin + 1, _end, quote);
    }

    public static String replace(String str, String repl, String with) {
        int lastindex = 0;
        int pos = str.indexOf(repl);
        if (pos < 0) {
            return str;
        }
        int len = repl.length();
        int lendiff = with.length() - repl.length();
        StringBuffer out = new StringBuffer(lendiff <= 0 ? str.length() : str.length() + 10 * lendiff);
        while (pos >= 0) {
            out.append(StringUtils.substring(str, lastindex, pos)).append(with);
            lastindex = pos + len;
            pos = str.indexOf(repl, lastindex);
        }
        return out.append(StringUtils.substring(str, lastindex, str.length())).toString();
    }

    public static String replace(String str, char repl, String with) {
        int pos = str.indexOf(repl);
        if (pos < 0) {
            return str;
        }
        int len = str.length();
        int lendiff = with.length() - 1;
        StringBuffer out = new StringBuffer(lendiff <= 0 ? str.length() : str.length() + 10 * lendiff);
        int lastindex = 0;
        while (pos >= 0) {
            out.append(StringUtils.substring(str, lastindex, pos)).append(with);
            lastindex = pos + 1;
            pos = str.indexOf(repl, lastindex);
        }
        return out.append(StringUtils.substring(str, lastindex, len)).toString();
    }

    public static StringBuffer replace(StringBuffer out, String s, String repl, String with) {
        int lastindex = 0;
        int len = repl.length();
        int index = s.indexOf(repl);
        while (index >= 0) {
            out.append(StringUtils.substring(s, lastindex, index)).append(with);
            lastindex = index + len;
            index = s.indexOf(repl, lastindex);
        }
        return out.append(StringUtils.substring(s, lastindex, len));
    }

    public static String[] splitLongString(String str, char separator) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int oldPos = 0;
        ArrayList<String> list = new ArrayList<String>();
        int pos = str.indexOf(separator);
        while (pos >= 0) {
            list.add(StringUtils.substring(str, oldPos, pos));
            oldPos = pos + 1;
            pos = str.indexOf(separator, oldPos);
        }
        list.add(StringUtils.substring(str, oldPos, len));
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitLongString(String str, char separator, char quote) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int oldPos = 0;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < len) {
            boolean quoted;
            while (pos < len && str.charAt(pos) == quote) {
                if ((pos = str.indexOf(quote, pos + 1) + 1) != 0) continue;
                throw new IllegalArgumentException("Closing quote missing in string '" + str + "'");
            }
            if (pos != oldPos) {
                quoted = true;
                if (pos < len && str.charAt(pos) != separator) {
                    throw new IllegalArgumentException("Separator must follow closing quote in string '" + str + "'");
                }
            } else {
                quoted = false;
                if ((pos = str.indexOf(separator, pos)) < 0) {
                    pos = len;
                }
            }
            list.add(quoted ? StringUtils.dequote(str, oldPos + 1, pos - 1, quote) : StringUtils.substring(str, oldPos, pos));
            oldPos = ++pos;
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitShortString(String str, char separator) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int lastTokenIndex = 0;
        int pos = str.indexOf(separator);
        while (pos >= 0) {
            ++lastTokenIndex;
            pos = str.indexOf(separator, pos + 1);
        }
        String[] list = new String[lastTokenIndex + 1];
        int oldPos = 0;
        int pos2 = str.indexOf(separator);
        int i = 0;
        while (pos2 >= 0) {
            list[i++] = StringUtils.substring(str, oldPos, pos2);
            oldPos = pos2 + 1;
            pos2 = str.indexOf(separator, oldPos);
        }
        list[lastTokenIndex] = StringUtils.substring(str, oldPos, len);
        return list;
    }

    public static String[] splitShortString(String str, char separator, char quote) {
        int oldPos;
        int len;
        if (str == null || (len = str.length()) == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int tokenCount = 0;
        for (int pos = 0; pos < len; ++pos) {
            ++tokenCount;
            oldPos = pos;
            while (pos < len && str.charAt(pos) == quote) {
                if ((pos = str.indexOf(quote, pos + 1) + 1) != 0) continue;
                throw new IllegalArgumentException("Closing quote missing in string '" + str + "'");
            }
            if (pos != oldPos) {
                if (pos >= len || str.charAt(pos) == separator) continue;
                throw new IllegalArgumentException("Separator must follow closing quote in strng '" + str + "'");
            }
            if ((pos = str.indexOf(separator, pos)) < 0) break;
        }
        if (str.charAt(len - 1) == separator) {
            ++tokenCount;
        }
        String[] list = new String[tokenCount];
        --tokenCount;
        oldPos = 0;
        int pos = 0;
        for (int i = 0; i < tokenCount; ++i) {
            boolean quoted;
            while (str.charAt(pos) == quote) {
                pos = str.indexOf(quote, pos + 1) + 1;
            }
            if (pos != oldPos) {
                quoted = true;
                if (str.charAt(pos) != separator) {
                    throw new IllegalArgumentException("Separator must follow closing quote in strng '" + str + "'");
                }
            } else {
                quoted = false;
                pos = str.indexOf(separator, pos);
            }
            list[i] = quoted ? StringUtils.dequote(str, oldPos + 1, pos - 1, quote) : StringUtils.substring(str, oldPos, pos);
            oldPos = ++pos;
        }
        list[tokenCount] = StringUtils.dequoteFull(str, oldPos, len, quote);
        return list;
    }

    public static String substring(String str, int begin, int end) {
        if (begin == end) {
            return "";
        }
        return str.substring(begin, end);
    }

    public static String[] trim(String[] strings) {
        if (strings == null) {
            return null;
        }
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static int minIndex(int a, int b) {
        return a < 0 ? b : (b < 0 ? a : (a < b ? a : b));
    }
}

