/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;

public class UIData
extends UIComponentBase
implements NamingContainer {
    private static final int STATE_SIZE = 5;
    private static final int SUPER_STATE_INDEX = 0;
    private static final int FIRST_STATE_INDEX = 1;
    private static final int ROWS_STATE_INDEX = 2;
    private static final int VALUE_STATE_INDEX = 3;
    private static final int VAR_STATE_INDEX = 4;
    private static final String FOOTER_FACET_NAME = "footer";
    private static final String HEADER_FACET_NAME = "header";
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private int _rowIndex = -1;
    private String _var = null;
    private Map _rowStates = new HashMap();
    private Map _dataModelMap = new HashMap();
    private boolean _isValidChilds = true;
    private Object _initialDescendantComponentState = null;
    private static final DataModel EMPTY_DATA_MODEL = new DataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IllegalArgumentException();
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };
    public static final String COMPONENT_TYPE = "javax.faces.Data";
    public static final String COMPONENT_FAMILY = "javax.faces.Data";
    private static final String DEFAULT_RENDERER_TYPE = "javax.faces.Table";
    private static final int DEFAULT_FIRST = 0;
    private static final int DEFAULT_ROWS = 0;
    private Integer _first = null;
    private Integer _rows = null;
    private Object _value = null;

    public void setFooter(UIComponent footer) {
        this.getFacets().put(FOOTER_FACET_NAME, footer);
    }

    public UIComponent getFooter() {
        return (UIComponent)this.getFacets().get(FOOTER_FACET_NAME);
    }

    public void setHeader(UIComponent header) {
        this.getFacets().put(HEADER_FACET_NAME, header);
    }

    public UIComponent getHeader() {
        return (UIComponent)this.getFacets().get(HEADER_FACET_NAME);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this._rowIndex == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._rowIndex == -1) {
            if (this._initialDescendantComponentState == null) {
                this._initialDescendantComponentState = this.saveDescendantComponentStates(this.getChildren().iterator(), false);
            }
        } else {
            this._rowStates.put(this.getClientId(facesContext), this.saveDescendantComponentStates(this.getChildren().iterator(), false));
        }
        this._rowIndex = rowIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(rowIndex);
        String var = this.getVar();
        if (rowIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this._rowIndex == -1) {
            this.restoreDescendantComponentStates(this.getChildren().iterator(), this._initialDescendantComponentState, false);
        } else {
            Object rowState = this._rowStates.get(this.getClientId(facesContext));
            if (rowState == null) {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), this._initialDescendantComponentState, false);
            } else {
                this.restoreDescendantComponentStates(this.getChildren().iterator(), rowState, false);
            }
        }
    }

    private void restoreDescendantComponentStates(Iterator childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = (UIComponent)childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            if (component instanceof EditableValueHolder) {
                ((EditableValueHolderState)childState).restoreState((EditableValueHolder)((Object)component));
            }
            Iterator childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreDescendantComponentStates(childsIterator, descendantState, true);
        }
    }

    private Object saveDescendantComponentStates(Iterator childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = (UIComponent)childIterator.next()).isTransient()) continue;
            Iterator childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Object descendantState = this.saveDescendantComponentStates(childsIterator, true);
            EditableValueHolderState state = null;
            if (child instanceof EditableValueHolder) {
                state = new EditableValueHolderState((EditableValueHolder)((Object)child));
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    public void setRows(int rows) {
        this._rows = new Integer(rows);
        if (rows < 0) {
            throw new IllegalArgumentException("rows: " + rows);
        }
    }

    public void setVar(String var) {
        this._var = var;
    }

    public String getVar() {
        return this._var;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("You can never set the 'rowIndex' or the 'var' attribute as a value-binding. Set the property directly instead. Name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + ':' + rowIndex;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent(new FacesEventWrapper(event, this.getRowIndex(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof FacesEventWrapper) {
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            int eventRowIndex = ((FacesEventWrapper)event).getRowIndex();
            int currentRowIndex = this.getRowIndex();
            this.setRowIndex(eventRowIndex);
            try {
                originalEvent.getComponent().broadcast(originalEvent);
            }
            finally {
                this.setRowIndex(currentRowIndex);
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this._initialDescendantComponentState = null;
        if (this._isValidChilds && !this.hasErrorMessages(context)) {
            this._dataModelMap.clear();
            this._rowStates.clear();
        }
        super.encodeBegin(context);
    }

    private boolean hasErrorMessages(FacesContext context) {
        Iterator iter = context.getMessages();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.compareTo(message.getSeverity()) > 0) continue;
            return true;
        }
        return false;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.setRowIndex(-1);
        super.encodeEnd(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 1);
        this.processColumnFacets(context, 1);
        this.processColumnChildren(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 2);
        this.processColumnFacets(context, 2);
        this.processColumnChildren(context, 2);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processFacets(context, 3);
        this.processColumnFacets(context, 3);
        this.processColumnChildren(context, 3);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    private void processFacets(FacesContext context, int processAction) {
        Iterator it = this.getFacets().values().iterator();
        while (it.hasNext()) {
            UIComponent facet = (UIComponent)it.next();
            this.process(context, facet, processAction);
        }
    }

    private void processColumnFacets(FacesContext context, int processAction) {
        Iterator childIter = this.getChildren().iterator();
        while (childIter.hasNext()) {
            UIComponent child = (UIComponent)childIter.next();
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            Iterator facetsIter = child.getFacets().values().iterator();
            while (facetsIter.hasNext()) {
                UIComponent facet = (UIComponent)facetsIter.next();
                this.process(context, facet, processAction);
            }
        }
    }

    private void processColumnChildren(FacesContext context, int processAction) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; last == -1 || rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                Iterator columnChildIter = child.getChildren().iterator();
                while (columnChildIter.hasNext()) {
                    UIComponent columnChild = (UIComponent)columnChildIter.next();
                    this.process(context, columnChild, processAction);
                }
            }
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    private DataModel getDataModel() {
        DataModel dataModel = null;
        String clientID = "";
        UIComponent parent = this.getParent();
        if (parent != null) {
            clientID = parent.getClientId(this.getFacesContext());
        }
        if ((dataModel = (DataModel)this._dataModelMap.get(clientID)) == null) {
            dataModel = this.createDataModel();
            this._dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    private DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    public void setValue(Object value) {
        this._value = value;
        this._dataModelMap.clear();
        this._rowStates.clear();
        this._isValidChilds = true;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._first, this._rows, this._value, this._var};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._first = (Integer)values[1];
        this._rows = (Integer)values[2];
        this._value = values[3];
        this._var = (String)values[4];
    }

    public UIData() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Data";
    }

    public void setFirst(int first) {
        if (first < 0) {
            throw new IllegalArgumentException("Illegal value for first row: " + first);
        }
        this._first = new Integer(first);
    }

    public int getFirst() {
        if (this._first != null) {
            return this._first;
        }
        ValueBinding vb = this.getValueBinding("first");
        Number v = vb != null ? (Number)((Number)vb.getValue(this.getFacesContext())) : (Number)null;
        return v != null ? v.intValue() : 0;
    }

    public int getRows() {
        if (this._rows != null) {
            return this._rows;
        }
        ValueBinding vb = this.getValueBinding("rows");
        Number v = vb != null ? (Number)((Number)vb.getValue(this.getFacesContext())) : (Number)null;
        return v != null ? v.intValue() : 0;
    }

    public Object getValue() {
        if (this._value != null) {
            return this._value;
        }
        ValueBinding vb = this.getValueBinding("value");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    private class EditableValueHolderState {
        private final Object _value;
        private final boolean _localValueSet;
        private final boolean _valid;
        private final Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._localValueSet = evh.isLocalValueSet();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setLocalValueSet(this._localValueSet);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
        }
    }

    private static class FacesEventWrapper
    extends FacesEvent {
        private static final long serialVersionUID = 6648047974065628773L;
        private FacesEvent _wrappedFacesEvent;
        private int _rowIndex;

        public FacesEventWrapper(FacesEvent facesEvent, int rowIndex, UIData redirectComponent) {
            super(redirectComponent);
            this._wrappedFacesEvent = facesEvent;
            this._rowIndex = rowIndex;
        }

        public PhaseId getPhaseId() {
            return this._wrappedFacesEvent.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this._wrappedFacesEvent.setPhaseId(phaseId);
        }

        public void queue() {
            this._wrappedFacesEvent.queue();
        }

        public String toString() {
            return this._wrappedFacesEvent.toString();
        }

        public boolean isAppropriateListener(FacesListener faceslistener) {
            return this._wrappedFacesEvent.isAppropriateListener(faceslistener);
        }

        public void processListener(FacesListener faceslistener) {
            this._wrappedFacesEvent.processListener(faceslistener);
        }

        public FacesEvent getWrappedFacesEvent() {
            return this._wrappedFacesEvent;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }
    }
}

