/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ArrayDataModel
extends DataModel {
    private int _rowIndex = -1;
    private Object[] _data;

    public ArrayDataModel() {
    }

    public ArrayDataModel(Object[] array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        this.setWrappedData(array);
    }

    public int getRowCount() {
        if (this._data == null) {
            return -1;
        }
        return this._data.length;
    }

    public Object getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data[this._rowIndex];
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public Object getWrappedData() {
        return this._data;
    }

    public boolean isRowAvailable() {
        if (this._data == null) {
            return false;
        }
        return this._rowIndex >= 0 && this._rowIndex < this._data.length;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            int i = 0;
            while (i < listeners.length) {
                listeners[i].rowSelected(event);
                ++i;
            }
        }
    }

    public void setWrappedData(Object data) {
        this._data = (Object[])data;
        int rowIndex = this._data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }
}

