#!/usr/bin/env ruby

# = iftest
# epcb-csv.{rb,exe}̃R}hCC^tF[X̃eXgB
#
# VERSION:: $Id$
#
require 'optparse'
require 'fileutils'
require 'epcb/csv/all-generator'

$KCODE = "SJIS"

parent_dir = File.expand_path(File.dirname($0)) 
$data_dir = File.join(File.dirname(File.dirname(parent_dir)), "test/data")
$program = "ruby epcb-csv.rb"
$remove_std = false
$tmp_dir = "c:/tmp"
# Windowsȏꍇ
if /^Windows/i =~ ENV["OS"]
  $tmp_dir = ENV["TMP"] if FileTest.directory?(ENV["TMP"])
else
  $tmp_dir = "/tmp"
end
$tmp_dir = "." unless FileTest.directory?($tmp_dir)

ARGV.options do |opts|
  opts.banner = <<BANNER
Usage: #{File.basename($0)} [options]
BANNER
  opts.separator("")
  opts.separator("options are:")
  # --datadir
  opts.on("-d", "--data-dir DIR", String,
          "specify test data directory. (default: \"#{$data_dir}\")") do |d|
    $data_dir = d
  end
  # --program
  opts.on("-p", "--program FILE", String,
          "sepcify a program of epcb-csv to run. (default: \"#{$program}\")") do |p|
    $program = p
  end
  # --remove
  opts.on("-r", "--remove",
          "remove temporarily redirected \"stdout\" and \"stderr\".") do |r|
    $remove_std = r
  end
  # --tmpdir
  opts.on("-t", "--tmp-dir DIR",
          "specify temporary directory.") do |t|
    $tmp_dir = t
  end
  # --help
  opts.on_tail("-h", "--help",
               "print this message and exit.") do
    puts opts
    exit(0)
  end

  opts.parse!
end

dir = File.expand_path($tmp_dir)
$out = File.open("#{dir}/stdout", "w")
$err = File.open("#{dir}/stderr", "w")

at_exit do
  [ $out, $err ].each do |io|
    begin
      io.close
    rescue IOError
      # Ignore
    ensure
      begin
        FileUtils.rm(io.path) if File.exists?(io.path) && rm_redirected_files
      rescue
        # Ignore
      end
    end
  end
end

module EPCB
  module Test
    class ProcessUtil
      def initialize(rm_redirected_files = false)
        @redirect_map = Hash.new
      end

      def set_redirection(redirect_io, type)
        @redirect_map[type] = redirect_io
      end

      def quiet_run(command, file = nil, line = nil)
        stdout = @redirect_map["stdout"]
        stderr = @redirect_map["stderr"]
        if stdout.nil? || stderr.nil?
          raise(Exception, "You must set redirection by \"set_redirection\".")
        end
        redirect_run(command, stdout, stderr, file, line)
      end

      def redirect_run(command, out, err, file = nil, line = nil)
        stdout_save = STDOUT.dup
        stderr_save = STDERR.dup
        list = [ STDOUT, STDERR ]
        begin
          STDOUT.reopen(out)
          STDERR.reopen(err)
          list.each do |io|
            f = ""
            f = File.basename(file) if file != nil
            io.puts "FILE:#{f} LINE:#{line}"
            io.puts "$ #{command}"
          end
          system(command)
        ensure
          list.each { |io| io.puts "" }
          begin
            list.each { |io| io.flush }
          rescue
            # Ignore
          end
          STDOUT.reopen(stdout_save)
          STDERR.reopen(stderr_save)
        end
      end

      def exit_status
        return $? >> 8
      end
    end #ProcessUtil#

    module Interface ; end
  end #Test#
end #EPCB#

# test/unitat_exitgp̂ŁArequire
require 'test/unit'

#
# epcb-csvTestCase̊NX
#
module EPCB::Test::Interface::TestCaseUtil

  # TuR}h+genall+sAꂽExcelPettyCashBook̃f[^؂B
  # === ARGS
  # name:: t@C(gq͊܂߂Ȃ)
  # template:: ڍso[W̃ev[gt@C
  # outfile:: o͐t@CpX
  # data_array:: ؂Ŏgpf[^̔z
  # validate_proc:: ؂ۂɎsubN
  def genall_and_validate_excel(name, template, outfile,
                                data_array, &validate_proc)
    run_command("genall", name, "-t #{$data_dir}/#{template} -o #{outfile}")
    assert(FileTest.exist?(outfile))

    dest_path = File.file_system.getAbsolutePathName(outfile)
    sheet_names = get_sheet_names(data_array)
    begin
      workbook = @eutil.open_workbook_and_activate(dest_path)
      start_index = 1
      for i in (6 .. workbook.worksheets.count) # 6: f[^V[g̎n܂
        sheet = workbook.worksheets(i)
        assert_equal(sheet_names[i-6], sheet.name)
        sheet.activate
        @eutil.initialize_on_active_sheet

        # data_arrayeV[gƂ̃f[^2z쐬
        sheet_data = Array.new
        for j in (start_index .. data_array.size - 1)
          if data_array[j].size == 1
            start_index = j + 1
            break
          end
          sheet_data << data_array[j].dup
        end
        puts "sheet_data = #{sheet_data.inspect}"

        # ݂Ȃ͂̃f[^sV[gɂȂmF
        7.times { |j| assert_nil(@eutil.get_offset(sheet_data.size, j).value) }

        # eV[gƂ̃f[^gpāÃubNs
        sheet_data.size.times do |line|
          7.times do |column|
            validate_proc.call(sheet_data, line, column)
          end
        end
      end
    ensure
      @eutil.destroy_excel
    end
  end #genall_and_validate_excel#

  # V[gi[z擾B
  # === ARGS
  # array:: ؂Ŏgpf[^z
  # === RETURNS
  # V[gi[z
  def get_sheet_names(array)
    sheet_names = Array.new
    array.size.times do |i|
      if array[i].size == 1
        name = array[i][0]
        # 擪$$폜Ă
        sheet_names << name.sub(/^\$\$/, "")
      end
    end
    return sheet_names
  end

  # TuR}h+gencsv+sAꂽCSVt@C؂B
  # === ARGS
  # name:: CSVt@C(gq͊܂߂Ȃ)
  # data:: ؗpf[^z
  # opt:: R}hɓnIvV
  def gencsv_and_validate_csv(name, data, opt = nil)
    out_file = "#{$tmp_dir}/#{name}.csv"
    opt = "" if opt.nil?
    opt += "#{opt} -o #{out_file}"
    run_command("gencsv", name, opt)
    validate_csv(out_file, data)
  end

  # +subcommand+sAexit_status 0 ł邱ƂmFB
  # === ARGS
  # subcommand:: TuR}h(gencsv, genall̂ꂩ)
  # name:: ڍsExcelPettyCashBook
  # opt:: R}hɓnIvV
  def run_command(subcommand, name, opt = nil)
    cmd = "#{$program} #{subcommand} #{$data_dir}/#{name}.xls"
    cmd += " #{opt}" unless opt.nil?
    @putil.quiet_run(cmd)
    assert_equal(0, @putil.exit_status)
  end

  # CSVt@C؂
  # === ARGS
  # file_path:: CSVt@CpX
  # data:: CSVt@C̃f[^Ɣr邽߂̌؃f[^z
  def validate_csv(file_path, data)
    assert(File.exist?(file_path))
    File.open(file_path, "rb") do |file|
      i = 0
      file.each do |line|
        row = CSV.parse_line(line, ?,, EPCB::CSV_LINE_SEP)
        assert_equal(data[i].size, row.size,
                     "L#{i+1}: CSṼJs")
        data[i].size.times do |j|
          assert_equal(data[i][j], row[j].to_s,
                       "L#{i+1} C#{j+1}: J̃f[^s")
        end
        i = i + 1
      end
    end
  end
end #TestCaseUtil#

#
# 1.0 -> 1.1̃eXgP[XB
#
class EPCB::Test::Interface::TestEPCBCSV_1_0 < Test::Unit::TestCase
  include EPCB::Test::Interface::TestCaseUtil

  def initialize(name)
    super
    @_1_0_simple_data = [
      ["$$2004N10"],
      ["2004/10/1","y","-14000",""],
      ["","H","-105",""],
      ["","","-270",""],
      ["2004/10/2","y","-2800",""],
      ["","H","-270",""],
      ["","","-270",""],
      ["2004/10/3","","-270",""],
      ["","H","-545",""],
      ["","H","-130",""],
      ["","","-8820",""],
      ["","pi","-1029",""],
      ["","H","-377",""],
      ["","","-270",""],
    ]

    @_1_0_simple_master_data = [
      "pr}X^","H","ʔ","۔","핞","y",""
    ]

    @_1_0_3sheets_data = [
      ["$$2004N8"],
      ["2004/8/1","y","-1279",""],
      ["","H","-315",""],
      ["","핞","-4095",""],
      ["","핞","-945",""],
      ["","","-270",""],
      ["","ϕi","-1525",""],
      ["2004/8/2","H","-204",""],
      ["","H","-147",""],
      ["","","-270",""],

      ["$$2004N9"],
      ["2004/9/1","","-540",""],
      ["","H","-100",""],
      ["","H","-1300",""],
      ["2004/9/2","H","-520",""],
      ["","H","-262",""],

      ["$$2004N10"],
      ["2004/10/1","y","-14000",""],
      ["","H","-105",""],
      ["","","-270",""],
      ["2004/10/2","y","-2800",""],
      ["","H","-270",""],
      ["","","-270",""],
    ]

    @_1_1_0_2sheets_data = [
      ["$$2005N2"],
      ["2005/2/1","y","-1500","2/1̔l"],
      ["","","-270",""],
      ["","i","-853",""],
      ["2005/2/2","H","-231",""],
      ["","","-270",""],
      ["","ʔ","-500","i<->l"],
      ["2003/2/3","Ɠdi","-40000",""],
      ["","ʔ","-320",""],
      ["","","-5250",""],

      ["$$2005N3"],
      ["2005/3/15","{EG","-1500",""],
      ["","y","-3000",""],
    ]

    @putil = EPCB::Test::ProcessUtil.new($remove_std)
    @putil.set_redirection($out, "stdout")
    @putil.set_redirection($err, "stderr")
    @eutil = EPCB::ExcelUtil.new
  end #initialize#

  def test_arg_error
    expected = 110
    # TuR}hȂ
    @putil.quiet_run($program, __FILE__, __LINE__)
    assert_equal(expected, @putil.exit_status)
    # sȃTuR}h
    @putil.quiet_run("#{$program} hoge", __FILE__, __LINE__)
    assert_equal(expected, @putil.exit_status)
    # src_fileȂ
    @putil.quiet_run("#{$program} gencsv", __FILE__, __LINE__)
    assert_equal(expected, @putil.exit_status)
  end

  def test_gencsv_error
    # src_fileȂ
    @putil.quiet_run("#{$program} gencsv not_found.xls", __FILE__, __LINE__)
    assert_equal(121, @putil.exit_status)
    # src_filefBNg
    @putil.quiet_run("#{$program} gencsv #{File.dirname($0)}", __FILE__, __LINE__)
    assert_equal(123, @putil.exit_status)
    # -S̃o[Ws
    @putil.quiet_run("#{$program} gencsv -S 10.10.10 #{$data_dir}/nodata.xls",
                     __FILE__, __LINE__)
    assert_equal(110, @putil.exit_status)
  end

  #
  # V[g1̃f[^(1_0_simple.xls)
  #
  def test_gencsv_1_0_simple
    gencsv_and_validate_csv("1_0_simple", @_1_0_simple_data)

    # }X^V[gCSVɏo͂ꍇ̃eXg
    expected = @_1_0_simple_data.dup
    expected.unshift(@_1_0_simple_master_data.dup)
    expected.unshift(["$$}X^"])
    gencsv_and_validate_csv("1_0_simple", expected, "-m")
  end

  #
  # V[g3̃f[^(1_0_3sheets.xls)
  #
  def test_gencsv_1_0_3sheets
    gencsv_and_validate_csv("1_0_3sheets", @_1_0_3sheets_data)
  end

  #
  # genall̃eXg
  #
  def test_genall_1_0_to_1_1
    _1_0_validate_proc = Proc.new do |data, line, column|
      puts "L#{line} C#{column}: #{@eutil.get_offset(line, column).value.inspect}"
      # dataexcelł́AL̂悤2Ԗڈȍ~̃ItZbgقȂ邽߁A
      # column2ȏ̂̂͂炷Ă
      # data : [ t,       pr, z  ]
      # excel: [ t, j, pr, z, l ] 

      # t
      if column == 0
        next if data[line][column] == ""
        value = @eutil.get_offset(line, column).value.to_s
        date = EPCB::ExcelUtil.to_yyyymmdd_format(value)
        assert_equal(data[line][column], date)
      # pr
      elsif column == 2
        assert_equal(data[line][column-1],
                     @eutil.get_offset(line, column).value.to_s)
      # z
      elsif column == 3
        assert_equal(data[line][column-1].to_i,
                     @eutil.get_offset(line, column).value.to_i)
      # l(1.0ڍsꍇKnilȂ͂)
      elsif column == 6
        assert_nil(@eutil.get_offset(line, column).value)
      end
    end
    
    name = "1_0_simple"
    template = "ExcelPettyCashBook-1.1.0.xls"
    outfile = "#{$tmp_dir}/#{name}_NEW.xls"
    genall_and_validate_excel(name, template, outfile,
                              @_1_0_simple_data, &_1_0_validate_proc)

    # -m ꍇ̃eXg
    run_command("genall", name, "-t #{$data_dir}/#{template} -o #{outfile} -m")
    assert(FileTest.exist?(outfile))
    dest_path = File.file_system.getAbsolutePathName(outfile)
    begin
      workbook = @eutil.open_workbook_and_activate(dest_path)
      master = workbook.worksheets(3)
      for i in 0 .. @_1_0_simple_master_data.size - 1
        assert_equal(@_1_0_simple_master_data[i], master.cells(i + 1, 1).value.to_s)
      end
      assert_nil(master.cells(@_1_0_simple_master_data.size + 1, 1).value)
    ensure
      @eutil.destroy_excel
    end
    
    name = "1_0_3sheets"
    outfile = "#{$tmp_dir}/#{name}_NEW.xls"
    genall_and_validate_excel(name, template, outfile,
                              @_1_0_3sheets_data, &_1_0_validate_proc)
  end #test_genall_1_0_to_1_1#

  #
  # 1.1.0->1.1.1genall̃eXg
  #
  def test_genall_1_1_0_to_1_1_1
    _1_1_validate_proc = Proc.new do |data, line, column|
      puts "L#{line} C#{column}: #{@eutil.get_offset(line, column).value.inspect}"
      # dataexcelł́AL̂悤2Ԗڈȍ~̃ItZbgقȂ邽߁A
      # column2ȏ̂̂͂炷Ă
      # data : [ t,       pr, z  ]
      # excel: [ t, j, pr, z, l ] 

      # t
      if column == 0
        #next if data[line][column] == ""
        value = @eutil.get_offset(line, column).value.to_s
        date = EPCB::ExcelUtil.to_yyyymmdd_format(value)
        assert_equal(data[line][column], date)
      # pr
      elsif column == 2
        assert_equal(data[line][column-1],
                     @eutil.get_offset(line, column).value.to_s)
      # z
      elsif column == 3
        assert_equal(data[line][column-1].to_i,
                     @eutil.get_offset(line, column).value.to_i)
      # l
      elsif column == 6
        assert_equal(data[line][column-1],
                     @eutil.get_offset(line, column).value.to_s)
      end
    end
    
    name = "1_1_0_2sheets"
    template = "ExcelPettyCashBook-1.1.1.xls"
    outfile = "#{$tmp_dir}/#{name}_NEW.xls"
    genall_and_validate_excel(name, template, outfile,
                              @_1_1_0_2sheets_data, &_1_1_validate_proc)

  end #test_genall_1_1_to_1_1#

end
