#
# == epcb/csv/excel-generator
# ExcelPettyCashBook𐶐@\񋟂B
#
# Revision:: $Id$
#
require 'fileutils'
require 'cli'
require 'epcb/csv/csv-parser'

module EPCB
  #
  # SheetDataExcelPettyCashBook̃V[gƂďo͂SerializerB
  #
  class ExcelSerializer
    # RXgN^B
    # === ARGS
    # workbook:: V[go͂ExcelPettyCashBook̃[NubN
    # eutil:: ExcelUtilCX^X
    def initialize(workbook, eutil)
      @workbook = workbook
      @eutil = eutil
      ver = @eutil.version_from_workbook
      ver = EPCB::TARGET_VERSION if ver.nil?
      ver = EPCB::truncate_minor2(ver)
      ver.gsub!(/\./, "_")
      Log::voutln("output version = #{ver}")
      @feature = EPCB::new_feature(@eutil, ver)
      @offsets = [
        @feature.const_of("DATE_OFFSET").to_i,
        @feature.const_of("USE_OFFSET").to_i,
        @feature.const_of("AMOUNT_OF_MONEY_OFFSET").to_i,
        @feature.const_of("NOTE_OFFSET").to_i,
      ]
    end

    #  +sheet_data+ RXgN^ŗ^ꂽ[NubNɏo͂B
    # === ARGS
    # sheet_data:: o͂V[g̃f[^
    def serialize(sheet_data)
      Log::voutln("Serializing sheet \"#{sheet_data.name}\"")
      if sheet_data.master?
        serialize_master(sheet_data)
      else
        serialize_data(sheet_data)
      end
      Log::voutln("Finished to serialize sheet \"#{sheet_data.name}\"\n")
    end

    protected
    def serialize_data(sheet_data)
      # o͐̃V[g쐬
      sheet = @eutil.excel.run("CreateNewDataSheet", sheet_data.name, false)
      if sheet.nil?
        Log::eoutln("Couldn't create sheet \"#{sheet_data.name}\"." \
                    " but the process will go on.")
        return
      end

      Log::voutln("Created sheet \"#{sheet.name}\"")
      # V[gANeBuɂInitialize}NĂ
      sheet.activate
      @eutil.initialize_on_active_sheet
      
      line_pos = 0
      # f[^sSĒׂ
      sheet_data.each do |data|
        # JSĒׂ
        i = 0
        data.to_a.each do |value|
          if value.nil?
            i += 1
            next
          end
          Log::voutln("get_offset(#{line_pos}, #{@offsets[i]}) = #{value} ")
          @eutil.get_offset(line_pos, @offsets[i]).value = value
          i += 1
        end
        line_pos += 1
        Log::voutln("")
      end
    end

    def serialize_master(sheet_data)
      sheet = master_sheet(@workbook)
      # ExcelPettyCashBookɃ}X^V[gȂꍇ
      if sheet.nil?
        Log::voutln("Master sheet not found.")
        next
      end

      for i in 0 .. sheet_data.use.size - 1
        #Log::vout("cells(#{i+1}, 1) ")
        sheet.cells(i + 1, 1).value = sheet_data.use[i]
      end
      Log::voutln
      # ڍst@C̃}X^f[^󕶎ŏ㏑
      for i in sheet_data.use.size + 1 .. @feature.const_of("MAX_DATA_LINE")
        sheet.cells(i, 1).value = ""
      end
      Log::voutln("Updated master \"#{sheet_data.name}\".")
    end

    private
    def master_sheet(workbook)
      for i in 1 .. workbook.worksheets.count
        s = workbook.worksheets(i) 
        return s if EPCB::master_sheet?(s.name)
      end
      return nil
    end

  end #ExcelSerializer#

  #
  # CSVf[^zグExcelPettyCashBooko͂GeneratorB
  #
  class ExcelGenerator < Generator
    def initialize
      super()
      @template_path = nil
    end

    # ǂݍރt@CƏo͂t@C肷B
    # +dest_file+  +nil+ ̏ꍇ +src_file+ o͐̃pX肷B
    # ܂AIvV +--template+ w肳Ă邩`FbNB
    #
    # === ARGS
    # src_file:: ǂݍExcelPettyCashBookt@C
    # dest_file:: o͂CSVt@C
    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)
      if $options.template.nil?
        raise(OptionUnsatisfiedError,
              "specify --template option" \
              " for subcommand \"#{EPCB::SUBC_EXCEL}\" or \"#{EPCB::SUBC_ALL}\".")
      end
      CLI::ensure_file_exist($options.template)
      @template_path = File.file_system.getAbsolutePathName($options.template)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        # pXK: <JgfBNg>/_<l>_<\[Xt@C>.xls
        prefix = "#{Dir::pwd}/_"
        for i in 1 .. 50000
          path = "#{prefix}#{i.to_s}_#{File.basename(@src_path, ".*")}.xls"
          Log::voutln("Created path = #{path}")
          break unless FileTest.exist?(path)
        end
        @dest_path = File.file_system.getAbsolutePathName(path)
        Log::voutln("dest_path = #{@dest_path}")
      end
      Log::voutln("template_path = #{@template_path}")
      FileUtils.cp(@template_path, @dest_path, :verbose => $options.verbose)
    end
    
    # CSVt@C̃f[^zグāAExcelPettyCashBookɏo͂B
    def execute
      super()
      Log::voutln

      workbook = @eutil.open_workbook_and_activate(@dest_path)
      @parser = CSVParser.new(@src_path)
      while @parser.has_next_line?
        sheet_data = @parser.parse
        Log::voutln("Finished to parse sheet \"#{sheet_data.name}\".\n")
        @serializer = ExcelSerializer.new(workbook, @eutil)
        @serializer.serialize(sheet_data)
      end

      # Sf[^V[g̃f[^vZ
      @eutil.excel.run("CalculateAllForEverySheet")
      workbook.save
    end
  end #ExcelGenerator#

end
