#
# == epcb/csv/csv-serializer
#
# Revision:: $Id$
#
require 'csv'
require 'epcb/csv/common'
require 'epcb/data'

module EPCB
  #
  # MonthDataCSVɏo͂SerializerB
  #
  class CSVSerializer
    # RXgN^B
    # === ARGS
    # file:: f[^o͂FileIuWFNg
    def initialize(file)
      @dest_file = file
    end

    # +sheet_data+RXgN^ŗ^ꂽꏊCSVƂďo͂B
    # === ARGS
    # sheet_data:: CSVɏo͂f[^
    def serialize(sheet_data)
      CSV::Writer.generate(@dest_file, ?,, EPCB::CSV_LINE_SEP) do |csv|
        Log::voutln("Serializing sheet \"#{sheet_data.name}\"")
        if sheet_data.master?
          serialize_master(sheet_data, csv)
        else
          serialize_data(sheet_data, csv)
        end
        Log::voutln("Finished to serialize sheet \"#{sheet_data.name}\"\n")
      end
    end

    protected
    # ̃f[^V[g +sheet_data+ o͂B
    # === ARGS
    # sheet_data:: CSVɏo͂V[g̃f[^
    def serialize_data(sheet_data, csv)
      # V[go
      csv << [ EPCB::CSV_SHEET_PREFIX + sheet_data.name ]
      count = 0
      sheet_data.each do |data|
        Log::voutln("row[#{count}] = [#{data.to_a}]")
        # f[^o
        csv << data.to_a
        count += 1
      end
    end

    # ̃}X^V[g +sheet_data+ o͂B
    # === ARGS
    # sheet_data:: CSVɏo͂}X^V[g̃f[^
    def serialize_master(sheet_data, csv)
      Log::voutln("Use master = #{sheet_data.use.inspect}")
      csv << [ EPCB::CSV_SHEET_PREFIX + sheet_data.name ]
      csv << sheet_data.use
    end
  end #CSVSerializer#
end
