# == epcb/csv/csv-parser
#
# Revision:: $Id$
#
require 'csv'
require 'epcb/csv/common'
require 'epcb/data'

module EPCB
  #
  # AbvO[hf[^i[CSV͂p[TB
  #
  class CSVParser
    # RXgN^B
    # === ARGS
    # src_path:: ͂CSVt@C̃pX
    def initialize(src_path)
      @src_file = File.open(src_path, "r")
      # JRubył͎gȂ߃RgAEg
      #@src_file.binmode
      @line_offset = 0
    end

    # ͂t@Cɂ܂ǂݍłȂs݂邩ǂ肷B
    # === RETURNS
    # ͂t@Cɂ܂ǂݍłȂs݂ꍇ true
    def has_next_line?
      return !@src_file.closed? && !@src_file.eof?
    end

    # RXgN^œnꂽFile͂A1V[g
    # MonthDataCX^XԂB
    #
    # === RETURNS
    # ͌ʂł1V[gMonthData
    def parse
      return parse_with_offset(@line_offset)
    end

    # RXgN^œnꂽFile +line_offset+ ̈ʒu͂A
    # 1V[gMonthDataCX^XԂB
    # === ARGS
    # line_offset:: ͂Jns̈ʒu
    # === RETURNS
    # ͌ʂł1V[gMonthData
    def parse_with_offset(offset)
      sheet_data = nil
      #puts "parse_with_offset: offset = #{offset}"
      while true
        tmp = @src_file.gets
        if tmp.nil?
          #puts "CALL destory()"
          # ͂f[^͂Ȃ̂ŁAdestroyĂ
          destroy
          break
        end

        #puts "tmp: #{EPCB::escape(tmp)}"
        line = tmp.chomp
        row = CSV.parse_line(line, ?,, EPCB::CSV_LINE_SEP)
        # t@CǂݍłAŏ̌A
        # ܂͐Vɐ؂ւꍇ
        if /^\$\$(.+)/ =~ row[0]
          name = $1
          # Vɐ؂ւ
          unless sheet_data.nil?
            # ǂ݂At@C|C^ɖ߂Ă
            size = -(tmp.unpack("C*").size) - 1 # \r̕-1
            @src_file.seek(size, IO::SEEK_CUR)
            # [v𔲂āAsheet_dataԂ
            break
          end
          Log::voutln("Parsing sheet \"#{name}\".")
          # f[^V[g炵̂̏ꍇ
          unless EPCB::master_sheet?(name)
            # MonthDataCX^X쐬Ă
            sheet_data = MonthData.new(name)
          # }X^V[g̏ꍇ
          else
            sheet_data = MasterData.new
          end
        # f[^s̏ꍇ
        else
          # V[g݂ȂŁAf[^sɂȂ藈ԁBO𓊂ׂ?
          next if sheet_data.nil?
          Log::voutln("#{row.inspect}")
          parse_row(row, sheet_data)
        end
        # sItZbgCNg
        offset = offset + 1
        @line_offset = @line_offset + 1
      end
      #puts "offset = #{offset}, @line_offset = #{@line_offset}"
      return sheet_data
    end

    private
    # CSṼf[^s1s͂B
    # === ARGS
    # line:: CSV̍s
    # sheet_data:: ͌ʂi[邽߂MonthData
    def parse_row(row, sheet_data)
      if sheet_data.master?
        row.each do |c|
          sheet_data.use << c
        end
      else
        raise(InvalidCSVDataFormatError, "CSV's row size must be 4. (#{row.to_a.size})") if row.to_a.size != 4
        #       array = Array.new
        #       row.each { |c| array << c.to_s }
        # CSṼf[^s"t,pr,z,l"ƂtH[}bg
        data = EPCB::new_specific_instance("IncomeExpensesData", nil, 
                                           EPCB::TARGET_VERSION, *row)
        sheet_data.add(data)
      end
    end

    def destroy
      begin
        @src_file.close unless @src_file.nil?
      rescue IOError
        # Ȃ
      end
    end
  end #CSVParser#

end
