#
# == epcb/csv/csv-generator
# CSV𐶐@\񋟂B
#
# Revision:: $Id$
#
require 'epcb/data'
require 'epcb/csv/common'
require 'epcb/csv/excel-parser'
require 'epcb/csv/csv-serializer'

module EPCB
  #
  # ExcelPettyCashBookCSVt@C𐶐GeneratorB
  #
  class CSVGenerator < Generator
    # ǂݍރt@CƏo͂t@C肷B
    # +dest_file+ nil ̏ꍇ+src_file+o͐̃pX肷B
    # === ARGS
    # src_file:: ǂݍExcelPettyCashBookt@C
    # dest_file:: o͂CSVt@C
    def setup(src_file, dest_file = nil)
      super(src_file, dest_file)

      if dest_file.nil?
        # \[Xt@Co͐t@C߂
        name = File.basename(src_file, ".*")
        @dest_path = File.file_system.getAbsolutePathName("#{name}.csv")
        Log::voutln("dest_path = #{@dest_path}")
      end
    end

    # ExcelPettyCashBook̃f[^zグāACSVt@Cɏo͂B
    def execute
      workbook = @eutil.open_workbook_and_activate(@src_path)
      @parser = EPCB::new_specific_instance("ExcelParser",
                                            @eutil, nil, @eutil)
      File.open(@dest_path, "wb") do |dest_file|
        @serializer = CSVSerializer.new(dest_file)
        # Excel̃V[gSׂ
        for i in 1 .. workbook.worksheets.count
          sheet = workbook.worksheets(i)
          sheet_data = @parser.parse(sheet)
          @serializer.serialize(sheet_data) unless sheet_data.nil?
        end
      end
    end
  end #CSVGenerator#

end
