#
# == epcb/csv/all-generator
# ÂExcelPettyCashBookVExcelPettyCashBooko͂@\񋟂B
#
# Revision:: $Id$
#
require 'epcb/csv/csv-generator'
require 'epcb/csv/excel-generator'

module EPCB

  # ÂExcelPettyCashBookCSVf[^𐶐āA
  # VExcelPettyCashBookɃf[^ڍsNXB
  class CSVAndExcelGenerator < Generator
    def initialize
      super()
      @csv_generator = CSVGenerator.new
      @excel_generator = ExcelGenerator.new
    end

    def setup(src_file, dest_file = nil)
      @csv_generator.setup(src_file, nil)
      csv_path = @csv_generator.dest_path
      # csv_path̃t@CȂꍇAExcelGenerator#setupŃG[ɂȂ̂ŁA
      # ̃t@C쐬Ă
      FileUtils.touch(csv_path, :verbose => $options.verbose)
      @excel_generator.setup(csv_path, dest_file)
    end

    def execute
      begin
        @csv_generator.execute
      ensure
        @csv_generator.destroy
      end
      @excel_generator.execute
    end

    def destroy
      super()
      begin
        @csv_generator.destroy
        @excel_generator.destroy
      ensure
        if @csv_generator.dest_path != nil &&
            FileTest.exist?(@csv_generator.dest_path) &&
            !$options.leave
          # CSVt@C폜
          FileUtils.rm(@csv_generator.dest_path, :force => true)
        end
      end
    end
  end #CSVAndExcelGenerator#

end
