#
# == epcb/csv/feature
#
# Revision:: $Id$
#
module EPCB
  #
  # ExcelPettyCashBook̃o[WɂāApł}NȂǂقȂ̂
  # ̈Ⴂ𖄂߂邽߂̃NXBo[WɓL̋@\ǉꍇ
  # TuNX쐬ĎB
  #
  class Feature
    # RXgN^B
    # === ARGS
    # excel_util:: ExcelUtil̃CX^X
    def initialize(excel_util)
      @util = excel_util
      @constants_cache = Hash.new
    end

    # ExcelPettyCashBookŒ`Ă萔擾B
    # === ARGS
    # name:: 萔
    def const_of(name)
      value = @constants_cache[name]
      if value.nil?
        value = @util.excel.run("Const_#{name}")
        @constants_cache[name] = value
      end
      return value
    end

    # f[^s萔󔒍sł邩肷B
    # IsEmptyLineContinuedToLimit}NĂԂƂŔ肷B
    # === ARGS
    # line:: 肷s̃ItZbg
    def is_empty_line_continued_to_limit(line)
      if @util.excel.run("IsEmptyLineContinuedToLimit", line) &&
          @util.get_offset(line, const_of("DATE_OFFSET")).value.nil?
        return true
      end
    end

    # ̃V[g+name+}X^V[g̐Oǂ肷B
#     def master_sheet?(name)
#       # $options.master̔͂Ȃ͂
#       return const_of("MASTER_SHEET_NAME") == name
#     end
  end #Feature#

  #
  # 1.0Feature
  #
  class Feature_1_0 < Feature
    def const_of(name)
      value = @constants_cache[name]
      return value unless value.nil?

      case name
      when "VERSION"
        value = "1.0.0"
      when "DEFAULT_BASE_LOCATION"
        value = "A7"
      when "MAX_DATA_LINE"
        value = 400
      when "TEMPLATE_SHEET_NAME"
        value = "^"
      when "MASTER_SHEET_NAME"
        value = "}X^"
      when "DATE_OFFSET"
        value = 0
      when "DAY_OF_WEEK_OFFSET"
        value = 1
      when "USE_OFFSET"
        value = 2
      when "AMOUNT_OF_MONEY_OFFSET"
        value = 3
      else
        return nil
      end
      @constants_cache[name] = value
      return value
    end

  end #Feature_1_0#

  #
  # 1.1Feature
  #
  class Feature_1_1 < Feature
  end #Feature_1_1#

end
