#
# == epcb/csv/common
# epcb-csv̋ʃNX܂Ƃ߂t@CB
#
# Revision:: $Id$
#
require 'parsedate'
require 'epcb/cli'
require 'log'
require 'win32ole-ext'
require 'epcb/csv/feature'

module EPCB
  # CSVExcelPettyCashBook̃o[W
  TARGET_VERSION = "1_1"

  SUBC_CSV = "gencsv"
  SUBC_EXCEL = "genexcel"
  SUBC_ALL = "genall"
  
  # CSṼV[gɂvtBbNX
  CSV_SHEET_PREFIX = "$$"
#   CSV_COL_SEP = ?,
  # CSV̍sZp[^
  CSV_LINE_SEP = "\r\n"
  # }X^V[g
  MASTER_SHEET_NAME = "}X^"

  # \r,\nGXP[v
  def escape(str)
    return str if str.nil?
    s = str.gsub(/\r/, "\\r")
    s = str.gsub(/\n/, "\\n")
    return s
  end

  # }X^V[gǂ肷B
  def master_sheet?(name)
    return (EPCB::MASTER_SHEET_NAME == name)
  end

  # IvV--source-version܂ExcelPettyCashBook
  # ڍsExcelPettyCashBook̃o[W擾B
  def get_source_version(eutil)
    ver = nil
    if $options.source_version.nil?
      # ExcelPettyCashBook̃}No[W擾
      ver = eutil.version_from_workbook
      if ver.nil?
        ver = "1_0"
      else
        ver = EPCB::truncate_minor2(ver)
      end
    else
      ver = $options.source_version
    end
    ver = ver.gsub(/\./, "_")
#    Log::voutln("source version = #{ver}")
    return ver
  end

  # versionɑΉCX^X𐶐B
  # === ARGS
  # class_name:: CX^X̃NX
  # version:: CX^X̃o[W(: "1_0")
  # eutil:: ExcelUtilNX̃CX^XB
  #         +version+ w肵Ăꍇ nil łOKB
  # args:: IuWFNg̃RXgN^ɓn
  def new_specific_instance(class_name, eutil,
                            version = nil, *args)
    if version.nil?
      version = get_source_version(eutil)
    end
    instance = nil
    begin
      instance = eval("#{class_name}_#{version}").new(*args)
    rescue NameError => e
      v = $options.source_version
      v = version if $options.source_version.nil?
      raise(UnknownVersionError, "Unknown source version \"#{v}\"")
    end
    return instance
  end

  # IvVŎw肳ꂽo[WFeatureCX^X𐶐B
  def new_feature(eutil, ver = nil)
    ver = get_source_version(eutil) if ver.nil?
    #Log::voutln("version = #{ver}")
    return EPCB::new_specific_instance("Feature", eutil,
                                       ver, eutil)
  end

  # x.y.z ̃o[W x.y ̕ԂB
  def truncate_minor2(version)
    return nil if version.nil?
    if /^(\d+)\.(\d+)\.(\d+)$/ =~ version
      return "#{$1}.#{$2}"
    end
    return version
  end

  module_function :escape, :master_sheet?, :get_source_version, \
  :new_specific_instance, :new_feature, :truncate_minor2

  #
  # G[NX
  #
  class EPCBError < StandardError ; end

  #
  # IvVȂꍇ̃G[B
  #
  class OptionUnsatisfiedError < EPCBError ; end
  #
  # w肳ꂽo[Wm̂̂ꍇ̃G[B
  #
  class UnknownVersionError < EPCBError ; end
  #
  # CSVt@C̃f[^słꍇ̃G[B
  #
  class InvalidCSVDataFormatError < EPCBError ; end

  #
  # R}hC̃TuR}hɑNXB
  #
  class Subcommand
    attr_reader :command, :klass
    # RXgN^B
    # === ARGS
    # command:: TuR}h
    # klass:: ۂɏsNX
    def initialize(command, klass)
      @command = command
      @klass = klass
    end
  end # class Subcommand #

  #
  # Excel֘Ã[eBeBNX
  #
  class ExcelUtil
    attr_reader :excel

    def initialize()
      @excel = nil
    end

    public
    def self.to_yyyymmdd_format(date_str, sep = "/")
      if date_str.nil? || date_str.empty?
        return nil
      end
      d = ParseDate.parsedate(date_str)
      return "#{d[0]}#{sep}#{d[1]}#{sep}#{d[2]}"
    end

    # ExcelCX^X𐶐
    # === RETURNS
    # ExcelCX^X
    def new_excel
      if @excel.nil?
        @excel = Excel.new(true, true)
      end
      return @excel
    end

    # ̃IuWFNgExcelCX^Xj
    def destroy_excel
      unless @excel.nil?
        @excel.quit
        @excel = nil
      end
    end

    # +path+Excelt@CJăANeBuɂB
    # === ARGS
    # path:: Excelt@C̃pX
    def open_workbook_and_activate(path, display_alerts = true)
      new_excel
      @excel.displayAlerts = display_alerts
      workbook = @excel.workbooks.open(path)
      workbook.activate
      return workbook
    end

    # +name+f[^V[gƂĐ肷B
    def is_valid_data_sheet_name(name)
      new_excel
      return @excel.run("IsValidDataSheetName", name)
    end

    # ANeBuȃV[g+Initialize+}NĂԁB
    def initialize_on_active_sheet()
      new_excel
      @excel.run("Initialize")
    end

    # ANeBuȃV[g+GetOffset+}NĂԁB
    def get_offset(line, column)
      new_excel
      return @excel.run("GetOffset", line, column)
    end

    # ExcelPettyCashBook̃o[W[NubN擾B
    def version_from_workbook
      begin
        new_excel
        return @excel.run("Const_VERSION")
      rescue WIN32OLERuntimeError => e
        return nil
      end
    end
  end #ExcelUtil#

  #
  # t@C𐶐SGeneratorNXB
  # 
  class Generator
    attr_reader :src_path, :dest_path

    def initialize
      @src_path = nil
      @dest_path = nil
      @eutil = ExcelUtil.new
      @parser = nil
      @serialzier = nil
#       @feature = nil
    end

    # ɕKvȑOsB
    def setup(src_file, dest_file = nil)
      CLI::ensure_file_exist(src_file)
      @src_path = File.file_system.getAbsolutePathName(src_file)
      Log::voutln("src_path = #{@src_path}")

      return if dest_file.nil?
      @dest_path = File.file_system.getAbsolutePathName(dest_file)
      Log::voutln("dest_path = #{@dest_path}")
    end

    # 炩̃t@C𐶐BTuNXŃI[oChB
    def execute ; end
    
    # ㏈s\bhB
    def destroy
      @eutil.destroy_excel if @eutil != nil
    end

  end #Generator#

end
