# coding: utf-8
# Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateContainerScanTargetDetails(object):
    """
    The information to update an existing container scan target
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateContainerScanTargetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateContainerScanTargetDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateContainerScanTargetDetails.
        :type description: str

        :param target_registry:
            The value to assign to the target_registry property of this UpdateContainerScanTargetDetails.
        :type target_registry: oci.vulnerability_scanning.models.UpdateContainerScanRegistryDetails

        :param container_scan_recipe_id:
            The value to assign to the container_scan_recipe_id property of this UpdateContainerScanTargetDetails.
        :type container_scan_recipe_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateContainerScanTargetDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateContainerScanTargetDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'target_registry': 'UpdateContainerScanRegistryDetails',
            'container_scan_recipe_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'target_registry': 'targetRegistry',
            'container_scan_recipe_id': 'containerScanRecipeId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._target_registry = None
        self._container_scan_recipe_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateContainerScanTargetDetails.
        User friendly name of container scan target


        :return: The display_name of this UpdateContainerScanTargetDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateContainerScanTargetDetails.
        User friendly name of container scan target


        :param display_name: The display_name of this UpdateContainerScanTargetDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateContainerScanTargetDetails.
        Target description.


        :return: The description of this UpdateContainerScanTargetDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateContainerScanTargetDetails.
        Target description.


        :param description: The description of this UpdateContainerScanTargetDetails.
        :type: str
        """
        self._description = description

    @property
    def target_registry(self):
        """
        Gets the target_registry of this UpdateContainerScanTargetDetails.

        :return: The target_registry of this UpdateContainerScanTargetDetails.
        :rtype: oci.vulnerability_scanning.models.UpdateContainerScanRegistryDetails
        """
        return self._target_registry

    @target_registry.setter
    def target_registry(self, target_registry):
        """
        Sets the target_registry of this UpdateContainerScanTargetDetails.

        :param target_registry: The target_registry of this UpdateContainerScanTargetDetails.
        :type: oci.vulnerability_scanning.models.UpdateContainerScanRegistryDetails
        """
        self._target_registry = target_registry

    @property
    def container_scan_recipe_id(self):
        """
        Gets the container_scan_recipe_id of this UpdateContainerScanTargetDetails.
        ID of the container scan recipe this target applies.


        :return: The container_scan_recipe_id of this UpdateContainerScanTargetDetails.
        :rtype: str
        """
        return self._container_scan_recipe_id

    @container_scan_recipe_id.setter
    def container_scan_recipe_id(self, container_scan_recipe_id):
        """
        Sets the container_scan_recipe_id of this UpdateContainerScanTargetDetails.
        ID of the container scan recipe this target applies.


        :param container_scan_recipe_id: The container_scan_recipe_id of this UpdateContainerScanTargetDetails.
        :type: str
        """
        self._container_scan_recipe_id = container_scan_recipe_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateContainerScanTargetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateContainerScanTargetDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateContainerScanTargetDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateContainerScanTargetDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateContainerScanTargetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateContainerScanTargetDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateContainerScanTargetDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateContainerScanTargetDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
