// LaunchMySQLDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LaunchMySQL.h"
#include "LaunchMySQLDlg.h"
#include <process.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern void ConvertLongToShortFileName(CString LongName, CString &ShortName);
extern void MergeDirFile(CString Directory, CString FileName, CString &Output);
extern void SplitDirFile(CString &Input, CString &Directory, CString &FileName);
extern CLaunchMySQLApp theApp;
extern void WriteToDebugFile(CString myText);

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLDlg dialog

const CString c_SettingsFileName = "MySqlSettings.txt";

	// get persistent information out of the text file
void CLaunchMySQLDlg::ReadSettings()
{
	CString FullFileName;
	MergeDirFile(theApp.m_ProgramDirectory, c_SettingsFileName, FullFileName);
	CStdioFile MyFile;
	if (MyFile.Open(FullFileName, CFile::modeRead | CFile::typeText))
	{
		CString CurrentLine;
		if (MyFile.ReadString(CurrentLine))
			m_Pathname = CurrentLine;

		if (MyFile.ReadString(CurrentLine))
			m_AdminPath = CurrentLine;
		MyFile.Close();
		theApp.m_Pathname = m_Pathname;
		theApp.m_AdminPath = m_AdminPath;
	}
}

	// read persistent information from the text file
void CLaunchMySQLDlg::WriteSettings()
{
	CString FullFileName;
	MergeDirFile(theApp.m_ProgramDirectory, c_SettingsFileName, FullFileName);
	CStdioFile MyFile;
	if (MyFile.Open(FullFileName, CFile::modeCreate | CFile::modeWrite | CFile::typeText))
	{
		CString CurrentLine;

		CurrentLine.Format("%s\n", m_Pathname);
		MyFile.WriteString((char *) LPCTSTR(CurrentLine));

		CurrentLine.Format("%s\n", m_AdminPath);
		MyFile.WriteString((char *) LPCTSTR(CurrentLine));

		MyFile.Close();
		theApp.m_Pathname = m_Pathname;
		theApp.m_AdminPath = m_AdminPath;
	}
}


void CLaunchMySQLDlg::SetConnectStatus()
{
	m_Status.Format("The MySql Server is %srunning", theApp.m_SqlStarted > 0 ? "" : "not ");
	UpdateData(FALSE);
}

CLaunchMySQLDlg::CLaunchMySQLDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLaunchMySQLDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLaunchMySQLDlg)
	//}}AFX_DATA_INIT
	ReadSettings();
	if (m_Pathname.GetLength() == 0)
		MergeDirFile(theApp.m_MySqlDirectory, "mysql.exe", m_Pathname);
	if (m_AdminPath.GetLength() == 0)
		MergeDirFile(theApp.m_MySqlDirectory, "mysqladmin.exe", m_AdminPath);
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLaunchMySQLDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLaunchMySQLDlg)
	DDX_Control(pDX, IDC_TREE_MYSQL, m_TreeCtrl);
	DDX_Text(pDX, IDC_EDIT_PATHNAME, m_Pathname);
	DDX_Text(pDX, IDC_EDIT_PATHNAME2, m_AdminPath);
	DDX_Text(pDX, IDC_STATIC_STATUS, m_Status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLaunchMySQLDlg, CDialog)
	//{{AFX_MSG_MAP(CLaunchMySQLDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_QUERYENDSESSION()
	ON_BN_CLICKED(ID_BUTTON_LAUNCH, OnButtonLaunch)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE, OnButtonBrowse)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE2, OnButtonBrowse2)
	ON_BN_CLICKED(IDSHUTDOWN, OnShutdown)
	ON_BN_CLICKED(IDMINIMIZE, OnMinimize)
	ON_BN_CLICKED(IDSTATUS, OnStatus)
	ON_NOTIFY(TVN_ITEMEXPANDED, IDC_TREE_MYSQL, OnItemexpandedTreeMysql)
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_TREE_MYSQL, OnItemexpandingTreeMysql)
	ON_NOTIFY(NM_CLICK, IDC_TREE_MYSQL, OnClickTreeMysql)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE_MYSQL, OnDblclkTreeMysql)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLaunchMySQLDlg message handlers

BOOL CLaunchMySQLDlg::OnInitDialog()
{
	if (MySqlConnected())
		++theApp.m_SqlStarted;
	CDialog::OnInitDialog();
	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);
	SetConnectStatus();
	return TRUE;
}

void CLaunchMySQLDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CLaunchMySQLDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

const int c_MaxFileNameChars = 16384;

	// invoke a windows predefined file dialog...
void CLaunchMySQLDlg::OnButtonBrowse() 
{
	UpdateData(TRUE);
	CString SearchSpec = "mysql*.exe";

	CString Filters = SearchSpec + " Files (" + SearchSpec + ")|" + SearchSpec + "|All Files (*.*)|*.*||";
	DWORD flags = (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT);

	CFileDialog CFD(TRUE, SearchSpec, m_Pathname, flags, Filters);
	if (CFD.DoModal() == IDOK)
	{
		m_Pathname = CFD.GetPathName();
		WriteSettings();
	}
	UpdateData(FALSE);
}

	// invoke a windows predefined file dialog...
void CLaunchMySQLDlg::OnButtonBrowse2() 
{
	UpdateData(TRUE);
	CString SearchSpec = "mysql*.exe";

	CString Filters = SearchSpec + " Files (" + SearchSpec + ")|" + SearchSpec + "|All Files (*.*)|*.*||";
	DWORD flags = (OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT);

	CFileDialog CFD(TRUE, SearchSpec, m_AdminPath, flags, Filters);
	if (CFD.DoModal() == IDOK)
	{
		m_AdminPath = CFD.GetPathName();
		WriteSettings();
	}
	UpdateData(FALSE);
}


	// this is for the Tree control.  It just remembers
	// who the current parent at each level is.
void CLaunchMySQLDlg::setHTreeParent(HTREEITEM it, int level)
{
	m_ParentArray[level] = it;
}

	// this is for the Tree control.  It gets the current parent
	// at a given level
HTREEITEM CLaunchMySQLDlg::getHTreeParent(int level)
{
	return(m_ParentArray[level]);
}

	// this adds an item to the tree control.  If the item is a
	// parent, it sets the parent array at that level to itself.
	// all nodes beyond level 0 use as their parent the item
	// in the parent array one below their level

void CLaunchMySQLDlg::AddToTree(char *data, int level, int isParent)
{
	HTREEITEM me, parentNode;
	TV_INSERTSTRUCT tvi;

	tvi.item.mask = (TVIF_CHILDREN | TVIF_HANDLE | TVIF_TEXT);
	tvi.hInsertAfter = TVI_LAST;
	if (level > 0)
	{
		parentNode = getHTreeParent(level - 1);
	}
	else
	{
		parentNode = TVI_ROOT;
	}
	tvi.hParent = parentNode;
	tvi.item.pszText = data;
	tvi.item.cChildren = (isParent ? 1 : 0);
	me = m_TreeCtrl.InsertItem(&tvi);
	if (isParent)
		setHTreeParent(me, level);
}

	// display a nice message box explaining what went wrong,
	// where it went wrong, and what to do about it.
	// an enhancement: supply a default rememedy from the error.
void CLaunchMySQLDlg::ShowMySqlError(MYSQL *myData, char *from, char *when, char *remedy)
{
	char *ErrorTable[] =
	{
		"Unknown",
		"Socket Create",
		"Connection",
		"Can't connect to host",
		"Ip Socket",
		"Unknown Host",
		"Server Gone",
		"Version Number Conflict",
		"Out of Memory",
		"Wrong Host Information",
		"Local Host Connection",
		"TCP Connection",
		"Server Handshake",
		"Server Lost",
		"Commands out of sync",
		"Named Pipe Connection",
		"Named Pipe Wait",
		"Named Pipe Open",
		"Named Pipe State"
	};

	int MyError = mysql_errno(myData);
	char *ptr;
	if (MyError >= CR_UNKNOWN_ERROR && MyError <= CR_NAMEDPIPESETSTATE_ERROR)
	{
		ptr = ErrorTable[MyError - CR_UNKNOWN_ERROR];
	}
	else
	{
		CString temp;
		temp.Format("Unknown error %d (0x%X)", MyError, MyError);
		ptr = (char *) LPCTSTR(temp);
	}
	CString message;
	message = "???";
	if (from)
	{
		if (when && remedy)
			message.Format("Error when %s from %s: %s, try %s", when, from, ptr, remedy);
		else if (remedy)
			message.Format("Error from %s: %s, try %s", from, ptr, remedy);
		else if (when)
			message.Format("Error when %s from %s: %s", when, from, ptr);
		else
			message.Format("Error %s: %s", from, ptr);
	}
	else
	{
		if (when && remedy)
			message.Format("Error when %s : %s, try %s", when, ptr, remedy);
		else if (remedy)
			message.Format("Error: %s, try %s", ptr, remedy);
		else if (when)
			message.Format("Error when %s: %s", when, ptr);
		else
			message.Format("Error: %s", ptr);
	}
	AfxMessageBox(message, MB_OK);
}

	// add table information to the tree control
	// currently only a field list and the number of rows
void CLaunchMySQLDlg::AddTableInfoToTree(MYSQL* myData, char *TableName, int BaseLevel)
{
	CString SQL_Statement;
	SQL_Statement.Format("SELECT * FROM %s", TableName);
	if (! mysql_query(myData, (char *) LPCTSTR(SQL_Statement)))
	{
		MYSQL_RES *res = mysql_store_result(myData);
		if (res == NULL)
		{
			ShowMySqlError(myData, "AddTableInfoToTree", "listing tableinfo", NULL);
		}
		else
		{
			my_ulonglong NumRows = mysql_num_rows(res);
			CString temp;
			temp.Format("%d rows", (int) NumRows);
			AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
			MYSQL_FIELD *fd;
			for (int FieldCount = 0; fd = mysql_fetch_field(res); ++FieldCount)
			{
				temp.Format("%s: def: %s, type: 0x%X, len: %d (mx: %d), flags: 0x%X, dec: %d",
					fd->name, fd->def, fd->type, fd->length, fd->max_length, fd->flags, fd->decimals);
				if (stricmp(fd->table, TableName) != 0)
				{
					temp += " table: ";
					temp += fd->table;
				}
				AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
			}
			mysql_free_result(res);
		}
	}
	else
	{
		CString temp;
		temp.Format("Couldn't execute %s on the server !\n", SQL_Statement);
		ShowMySqlError(myData, "AddTableInfoToTree", (char *) LPCTSTR(temp), NULL);
	}
}

	// add database information to the tree control
	// currently only a list of tables
void CLaunchMySQLDlg::AddDbInfoToTree(MYSQL* myData, char *DbName, int BaseLevel)
{
	if (mysql_select_db(myData, DbName) < 0)
	{
		CString temp;
		temp.Format("Can't select the %s database", DbName);
		ShowMySqlError(myData, "AddDbInfoToTree", (char *) LPCTSTR(temp), NULL);
		return;
	}
		//....
	MYSQL_RES *res = mysql_list_tables(myData, "%");
	if (res == NULL)
	{
		ShowMySqlError(myData, "AddDbInfoToTree", "listing tables", NULL);
	}
	else
	{
		MYSQL_ROW row;
		int TableCount = 1;
		while (row = mysql_fetch_row(res))
		{
			char *TableName = (((row[0] == NULL) || (!strlen(row[0]))) ? "NULL" : row[0]);
			AddToTree(TableName, BaseLevel, true);
			AddTableInfoToTree(myData, TableName, BaseLevel + 1);
		}
		mysql_free_result(res);
	}

}

	// add database names to the tree control
void CLaunchMySQLDlg::AddDbToTree(MYSQL* myData, int BaseLevel)
{
	MYSQL_RES *res = mysql_list_dbs(myData, "%");
	if (res == NULL)
	{
		ShowMySqlError(myData, "AddDbToTree", "listing databases", NULL);
		return;
	}
	MYSQL_ROW row;
	int DbCount = 1;
	while (row = mysql_fetch_row(res))
	{
		char *DbName = (((row[0] == NULL) || (!strlen(row[0]))) ? "NULL" : row[0]);
		AddToTree(DbName, BaseLevel, true);
		AddDbInfoToTree(myData, DbName, BaseLevel + 1);
	}
	mysql_free_result(res);
}

	// put information from the MYSQL net member into the tree control
void CLaunchMySQLDlg::AddNetInfoToTree(MYSQL *myData, int BaseLevel)
{
	CString temp;
	temp.Format("NetType %d (0x%X)", myData->net.nettype, myData->net.nettype);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("hPipe %d (0x%X)", myData->net.hPipe, myData->net.hPipe);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("fcntl %d (0x%X)", myData->net.fcntl, myData->net.fcntl);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("buff 0x%X", myData->net.buff);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("buff_end 0x%X", myData->net.buff_end);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("write_pos 0x%X", myData->net.write_pos);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("read_pos 0x%X", myData->net.read_pos);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("last_error %s", myData->net.last_error);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("last_errno %d (0x%X)", myData->net.last_errno, myData->net.last_errno);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("max_packet %d (0x%X)", myData->net.max_packet, myData->net.max_packet);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("timeout %d (0x%X)", myData->net.timeout, myData->net.timeout);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("pkt_nr %d (0x%X)", myData->net.pkt_nr, myData->net.pkt_nr);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("error %d (0x%X)", myData->net.error, myData->net.error);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("return_errno %d (0x%X)", myData->net.return_errno, myData->net.return_errno);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("compress %d (0x%X)", myData->net.compress, myData->net.compress);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("remain_in_buf %d (0x%X)", myData->net.remain_in_buf, myData->net.remain_in_buf);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("length %d (0x%X)", myData->net.length, myData->net.length);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("buf_length %d (0x%X)", myData->net.buf_length, myData->net.buf_length);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("where_b %d (0x%X)", myData->net.where_b, myData->net.where_b);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("more %d (0x%X)", myData->net.more, myData->net.more);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("save_char %d (0x%X)", myData->net.save_char, myData->net.save_char);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
}

	// put information from the MYSQL options member into the tree control
void CLaunchMySQLDlg::AddOptionsToTree(MYSQL *myData, int BaseLevel)
{
	CString temp;
	temp.Format("connect_timeout %d", myData->options.connect_timeout);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("client_flag %d (0x%X)", myData->options.client_flag, myData->options.client_flag);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("compress %d (0x%X)", myData->options.compress, myData->options.compress);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("named_pipe %d (0x%X)", myData->options.named_pipe, myData->options.named_pipe);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("port %d (0x%X)", myData->options.port, myData->options.port);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("host %s", myData->options.host);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("init_command %s", myData->options.init_command);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("user %s", myData->options.user);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("password %s", myData->options.password);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("unix_socket %s", myData->options.unix_socket);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("db %s", myData->options.db);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("my_cnf_file %s", myData->options.my_cnf_file);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
	temp.Format("my_cnf_group %s", myData->options.my_cnf_group);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
}

	// put information from the MYSQL members into the tree control
void CLaunchMySQLDlg::AddMyDataInfoToTree(MYSQL *myData, int BaseLevel)
{
	CString temp;
	temp.Format("Client:  %s", mysql_get_client_info());
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("host %s", myData->host);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("user %s", myData->user);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("passwd %s", myData->passwd);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("unix_socket %s", myData->unix_socket);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("server_version %s", myData->server_version);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("host_info %s", myData->host_info);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("info %s", myData->info);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("db %s", myData->db);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);

    temp.Format("port %d (0x%X)", myData->port, myData->port);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("client_flag %d (0x%X)", myData->client_flag, myData->client_flag);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("server_capabilities %d (0x%X)", myData->server_capabilities, myData->server_capabilities);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("protocol_version %d (0x%X)", myData->protocol_version, myData->protocol_version);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("field_count %d", myData->field_count);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("thread_id %d (0x%X)", myData->thread_id, myData->thread_id);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);

    temp.Format("packet_length %d", myData->packet_length);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);
    temp.Format("status %d (0x%X)", myData->status, myData->status);
	AddToTree((char *) LPCTSTR(temp), BaseLevel, false);

	AddToTree(" Options", BaseLevel, true);
	AddOptionsToTree(myData, BaseLevel + 1);

	AddToTree(" Net", BaseLevel, true);
	AddNetInfoToTree(myData, BaseLevel + 1);
}

	// put the current server threads into the tree control
void CLaunchMySQLDlg::AddMySqlProcessToTree(MYSQL *myData, int BaseLevel)
{
	MYSQL_RES *res;
	res = mysql_list_processes(myData);
	if (res)
	{
		const int c_MaxFields = 100;
		MYSQL_FIELD *fd;
		MYSQL_FIELD *FieldArray[c_MaxFields];
		for (int FieldCount = 0; (fd = mysql_fetch_field(res)) && FieldCount < 30; ++FieldCount)
			FieldArray[FieldCount] = fd;
		int ProcessNumber = 1;
		MYSQL_ROW row;
		while (row = mysql_fetch_row(res))
		{
			int TheOtherFieldCount = mysql_num_fields(res);
			if (TheOtherFieldCount != FieldCount)
			{
				TRACE("Interesting, field count mismatch (%d by fetch, %d by num_fields)\n",
					FieldCount, TheOtherFieldCount);
			}
			CString temp;
			temp.Format("Process #%ld", ProcessNumber);
			AddToTree((char *) LPCTSTR(temp), BaseLevel, true);
			++ProcessNumber;
				// make sure we don't overstep the field array..
			if (TheOtherFieldCount > c_MaxFields)
				TheOtherFieldCount = c_MaxFields;
			for (int FieldIndex = 0; FieldIndex < TheOtherFieldCount; ++FieldIndex)
			{
				temp.Format("%s:  %s", FieldArray[FieldIndex]->name,
					(((row[FieldIndex] == NULL) || (!strlen(row[FieldIndex]))) ? "NULL" : row[FieldIndex]));
				AddToTree((char *) LPCTSTR(temp), BaseLevel + 1, false);
			}
		}
		mysql_free_result(res);
	}
	else
	{
		ShowMySqlError(myData, "AddMySqlProcessToTree", "retrieving process list", NULL);
	}
}

	// find out if we have a connection
bool CLaunchMySQLDlg::MySqlConnected()
{
	MYSQL *myData;

	myData = mysql_init((MYSQL*) 0);
	if (!myData)
		return(false);
	if (!mysql_real_connect(myData, NULL, NULL, NULL, NULL, MYSQL_PORT,
		   NULL, 0))
		return(false);
	mysql_close(myData);
	return(true);
}

	// populate that lovely tree control
void CLaunchMySQLDlg::PopulateTree()
{
	m_TreeCtrl.DeleteAllItems();
	MYSQL *myData;

	myData = mysql_init((MYSQL*) 0);
	if (!myData)
	{
		AddToTree("mysql_init failed, try pressing the start button.", 0, false);
		return;
	}
	if (!mysql_real_connect(myData, NULL, NULL, NULL, NULL, MYSQL_PORT,
		   NULL, 0))
	{
		ShowMySqlError(myData, "PopulateTree", "mysql_real_connect failed", "pressing the start button");
		return;
	}
	AddToTree(mysql_stat(myData), 0, false);

	AddToTree("MySQL Databases", 0, true);
	AddDbToTree(myData, 1);

	AddToTree("MySQL Processes", 0, true);
	AddMySqlProcessToTree(myData, 1);

	AddToTree("MySQL Status", 0, true);
	AddMyDataInfoToTree(myData, 1);

	mysql_close(myData);
}

	// for later...
void CLaunchMySQLDlg::OnItemexpandedTreeMysql(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

	// for later...
void CLaunchMySQLDlg::OnItemexpandingTreeMysql(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

	// for later...
void CLaunchMySQLDlg::OnClickTreeMysql(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

	// for later...
void CLaunchMySQLDlg::OnDblclkTreeMysql(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

	// this function is invoked when the 'launch' button is pressed
void CLaunchMySQLDlg::OnButtonLaunch() 
{
	WriteSettings();
	theApp.StartMySqlServer();
	SetConnectStatus();
}

	// this function is invoked when the 'shutdown' button is pressed
void CLaunchMySQLDlg::OnShutdown() 
{
	WriteSettings();
	theApp.ShutdownMySqlServer(true);
	SetConnectStatus();
}

	// this function is invoked when the 'minimize' button is pressed
void CLaunchMySQLDlg::OnMinimize()
{
	WINDOWPLACEMENT wp;
	GetWindowPlacement(&wp);
	wp.flags = 0;
	wp.showCmd = SW_MINIMIZE;
	SetWindowPlacement(&wp);
}

	// this function is invoked when the 'status' button is pressed
void CLaunchMySQLDlg::OnStatus() 
{
	if (theApp.m_SqlStarted > 0)
		PopulateTree();
	else
		AfxMessageBox("You have to start SQL first...", MB_OK);
}

	// this function is invoked when the system is shut down
BOOL CLaunchMySQLDlg::OnQueryEndSession(void)
{
	if (theApp.ShutdownMySqlServer(true))
		return TRUE;
	return(FALSE);
}

	// this function is invoked when the close button is pressed
void CLaunchMySQLDlg::OnOK() 
{
	WriteSettings();
	CDialog::OnOK();
}
