#include "stdafx.h"
#include "LaunchMySQL.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CLaunchMySQLApp theApp;
CString DbgFileName = "Debug.txt";
CStdioFile DbgFile;
bool DbgFileOpened = false;

void CreateDebugFile()
{
	if (!DbgFileOpened)
	{
		CString FullDbgFileName = theApp.m_ProgramDirectory + '\\' + DbgFileName;
		if (DbgFile.Open(FullDbgFileName,
			CFile::modeCreate | CFile::modeWrite | CFile::typeText))
		{
			DbgFileOpened = true;
		}
	}
}

void AppendDebugFile()
{
	if (!DbgFileOpened)
	{
		CString FullDbgFileName = theApp.m_ProgramDirectory + '\\' + DbgFileName;
		DbgFileOpened = (DbgFile.Open(FullDbgFileName,
			CFile::modeNoTruncate | CFile::modeWrite | CFile::typeText) != 0);
		if (DbgFileOpened)
		{
			DbgFile.SeekToEnd();
		}
		else
		{
			CreateDebugFile();
		}
	}
}

void CloseDebugFile()
{
	if (DbgFileOpened)
	{
		DbgFile.Close();
		DbgFileOpened = false;
	}
}

void WriteToDebugFile(CString myText)
{
	bool SaveStatus = DbgFileOpened;
	if (!DbgFileOpened)
		AppendDebugFile();
	if (DbgFileOpened)
	{
		TRACE(myText);
		DbgFile.WriteString((char *) (LPCTSTR) myText);
		if (!SaveStatus)
			CloseDebugFile();
	}
}

