/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.HelpOptionsParser;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.CommandLineOptionsParser;
import com.mysql.management.util.InitializeUser;
import com.mysql.management.util.ListToString;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.ProcessUtil;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Threads;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public final class MysqldResource
implements MysqldResourceI {
    public static final String MYSQL_C_MXJ = "mysql-c.mxj";
    public static final String DATA = "data";
    private String versionString;
    private Map options;
    private Shell shell;
    private final File baseDir;
    private final File dataDir;
    private final File pidFile;
    private final File portFile;
    private String msgPrefix;
    private String pid;
    private Properties platformProperties;
    private Properties connectorMxjProperties;
    private String osName_osArch;
    private PrintStream out;
    private PrintStream err;
    private Exception trace;
    private int killDelay;
    private List completionListensers;
    private boolean readyForConnections;
    private String windowsKillCommand;
    private HelpOptionsParser optionParser;
    private Utils utils;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;

    public MysqldResource() {
        this(null, null, null, null, null, null);
    }

    public MysqldResource(File baseDir) {
        this(baseDir, null, null, null, null, null);
    }

    public MysqldResource(File baseDir, File dataDir) {
        this(baseDir, dataDir, null, null, null, null);
    }

    public MysqldResource(File baseDir, File dataDir, String mysqlVersionString) {
        this(baseDir, dataDir, mysqlVersionString, null, null, null);
    }

    public MysqldResource(File baseDir, File dataDir, String mysqlVersionString, PrintStream out, PrintStream err) {
        this(baseDir, dataDir, mysqlVersionString, out, err, null);
    }

    MysqldResource(File pBaseDir, File pDataDir, String pMysqlVersionString, PrintStream pOut, PrintStream pErr, Utils pUtils) {
        this.out = pOut != null ? pOut : System.out;
        this.err = pErr != null ? pErr : System.err;
        this.utils = pUtils != null ? pUtils : new Utils();
        this.platformProperties = this.utils.streams().loadProperties("platform-map.properties", pErr);
        this.connectorMxjProperties = this.utils.streams().loadProperties("connector-mxj.properties", pErr);
        this.baseDir = this.utils.files().validCononicalDir(pBaseDir, this.utils.files().tmp(MYSQL_C_MXJ));
        this.dataDir = this.utils.files().validCononicalDir(pDataDir, new File(this.baseDir, DATA));
        this.optionParser = new HelpOptionsParser(this.err, this.utils);
        this.killDelay = this.getKillDelyFromProperties(this.connectorMxjProperties);
        this.windowsKillCommand = this.getWindowsKillCommand(this.connectorMxjProperties);
        String className = this.utils.str().shortClassName(this.getClass());
        this.pidFile = this.utils.files().cononical(new File(this.dataDir, String.valueOf(className) + ".pid"));
        this.portFile = new File(this.dataDir, String.valueOf(className) + ".port");
        this.setVersion(false, pMysqlVersionString);
        this.msgPrefix = "[" + className + "] ";
        this.options = new HashMap();
        this.setShell(null);
        this.setOsAndArch(System.getProperty("os.name"), System.getProperty("os.arch"));
        this.completionListensers = new ArrayList();
        this.initTrace();
    }

    private void initTrace() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.trace = new Exception();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void start(String string, Map map) {
        void mysqldArgs;
        void threadName;
        String string2 = string;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.start((String)threadName, (Map)mysqldArgs, false);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void start(String string, Map map, boolean bl) {
        String string2 = string;
        Map map2 = map;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string2, map2, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.getShell() != null || this.processRunning()) {
            this.printMessage("mysqld already running (process: " + this.pid() + ")");
        } else {
            void threadName;
            void populateAllOptions;
            void pMysqldArgs;
            final HashMap<String, String> mysqldArgs = new HashMap<String, String>((Map<String, String>)pMysqldArgs);
            int port = this.parseInt(new Object(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                public String toString() {
                    String string;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
                    Object portArg = mysqldArgs.get("port");
                    String string2 = portArg == null ? null : portArg.toString();
                    String string3 = string = string2;
                    Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
                    return string2;
                }

                static {
                    Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource$1"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.management.MysqldResource$1----java.lang.String-"), 179);
                }
            }, 3306);
            mysqldArgs.put("port", "" + port);
            mysqldArgs.remove("mysql-version");
            String initUserProp = (String)mysqldArgs.remove("initialize-user");
            boolean initUser = Boolean.valueOf(initUserProp);
            String user = (String)mysqldArgs.remove("initialize-user.user");
            String password = (String)mysqldArgs.remove("initialize-user.password");
            this.setKillDelay(this.parseInt(mysqldArgs.remove("kill-delay"), this.killDelay));
            if (populateAllOptions != false) {
                this.options = this.optionParser.getOptionsFromHelp(this.getHelp(mysqldArgs));
            } else {
                this.options = new HashMap();
                this.options.putAll(mysqldArgs);
            }
            this.out.flush();
            this.addCompletionListenser(new Runnable(){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                public void run() {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
                    MysqldResource.access$0(MysqldResource.this, false);
                    MysqldResource.this.setShell(null);
                    MysqldResource.access$1(MysqldResource.this).remove(this);
                    Object var2_2 = null;
                    Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
                }

                static {
                    Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource$2"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-com.mysql.management.MysqldResource$2----void-"), 210);
                }
            });
            this.setShell(this.exec((String)threadName, mysqldArgs, this.out, this.err, true));
            this.reportPid();
            this.utils.files().writeString(this.portFile, String.valueOf(port) + this.utils.str().newLine());
            boolean ready = this.canConnectToServer(port, this.killDelay);
            this.setReadyForConnection(ready);
            if (initUser) {
                try {
                    new InitializeUser(port, user, password, this.err).initializeUser();
                }
                catch (Throwable t) {
                    t.printStackTrace(this.err);
                }
            }
        }
        Object var17_17 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var17_17, joinPoint);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean canConnectToServer(int var1_1, int var2_2) {
        block21: {
            var14_3 = var1_1;
            var15_4 = var2_2;
            var13_5 = Factory.makeJP((JoinPoint.StaticPart)MysqldResource.ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)var14_3), (Object)Conversions.intObject((int)var15_4));
            Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(var13_5);
            triesBeforeGivingUp = 1 + milisecondsBeforeGivingUp / 1000 * 4;
            v0 = this.utils.str();
            v1 = MysqldResource.class$0;
            if (v1 == null) {
                try {
                    v1 = MysqldResource.class$0 = Class.forName("com.mysql.jdbc.Driver");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
            }
            v0.classForName(v1.getName());
            conn = null;
            bogusUser = "Connector/MXJ";
            password = "Bogus Password";
            url = "jdbc:mysql://127.0.0.1:" + (int)port + "/test" + "?connectTimeout=150";
            i = 0;
            while (i < triesBeforeGivingUp) {
                block24: {
                    try {
                        conn = DriverManager.getConnection(url, bogusUser, password);
                        var10_12 = null;
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(this.err);
                        }
                        v3 = var16_14 = true;
                        break block21;
                    }
                    catch (SQLException e) {
                        block22: {
                            block23: {
                                try {
                                    if (e.getErrorCode() != 1045) break block22;
                                    var10_12 = null;
                                }
                                catch (Throwable var11_16) {
                                    var10_12 = null;
                                    ** try [egrp 5[TRYBLOCK] [6 : 198->213)] { 
lbl46:
                                    // 1 sources

                                    if (conn == null) throw var11_16;
                                    conn.close();
                                    throw var11_16;
lbl49:
                                    // 1 sources

                                    catch (Exception e) {
                                        e.printStackTrace(this.err);
                                    }
                                    throw var11_16;
                                }
                                ** try [egrp 5[TRYBLOCK] [6 : 198->213)] { 
lbl53:
                                // 1 sources

                                if (conn != null) {
                                    conn.close();
                                }
                                break block23;
lbl56:
                                // 1 sources

                                catch (Exception e) {
                                    e.printStackTrace(this.err);
                                }
                            }
                            v3 = var16_14 = true;
                            break block21;
                        }
                        var10_12 = null;
                    }
                    ** try [egrp 5[TRYBLOCK] [6 : 198->213)] { 
lbl67:
                    // 1 sources

                    if (conn != null) {
                        conn.close();
                    }
                    break block24;
lbl70:
                    // 1 sources

                    catch (Exception e) {
                        e.printStackTrace(this.err);
                    }
                }
                this.utils.threads().pause(100);
                ++i;
            }
            v3 = var16_14 = false;
        }
        v4 = var17_17 = v3;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)var17_17), var13_5);
        return var16_14;
    }

    /*
     * WARNING - void declaration
     */
    private void setReadyForConnection(boolean bl) {
        void ready;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.readyForConnections = ready;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public synchronized boolean isReadyForConnections() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl3 = bl2 = (bl = this.readyForConnections);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    private void reportPid() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int CYCLE_DELAY = this.killDelay / 100;
        boolean printed = false;
        int i = 0;
        while (!printed && i < 100) {
            if (this.pidFile.exists() && this.pidFile.length() > 0L) {
                this.utils.threads().pause(100);
                this.printMessage("mysqld running as process: " + this.pid());
                this.out.flush();
                printed = true;
            }
            this.utils.threads().pause(CYCLE_DELAY);
            ++i;
        }
        this.reportIfNoPidfile(printed);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * Unable to fully structure code
     */
    synchronized String pid() {
        var1_1 = Factory.makeJP((JoinPoint.StaticPart)MysqldResource.ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(var1_1);
        if (this.pid != null) ** GOTO lbl8
        if (!this.pidFile.exists()) {
            v0 = var2_2 = "No PID";
        } else {
            this.pid = this.utils.files().asString(this.pidFile).trim();
lbl8:
            // 2 sources

            v0 = var2_2 = this.pid;
        }
        v1 = var3_3 = v0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    void reportIfNoPidfile(boolean bl) {
        void pidFileFound;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (pidFileFound == false) {
            this.printWarning("mysqld pid-file not found:  " + this.pidFile);
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public synchronized void shutdown() {
        boolean haveShell;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = haveShell = this.getShell() != null;
        if (!this.pidFile.exists() && !haveShell) {
            this.printMessage("Mysqld not running. No file: " + this.pidFile);
        } else {
            this.printMessage("stopping mysqld (process: " + this.pid() + ")");
            this.issueNormalKill();
            if (this.processRunning()) {
                this.issueForceKill();
            }
            if (this.shellRunning()) {
                this.destroyShell();
            }
            this.setShell(null);
            if (this.processRunning()) {
                this.printWarning("Process " + this.pid + "still running; not deleting " + this.pidFile);
            } else {
                this.utils.threads().pause(150);
                this.pidFile.delete();
                this.pid = null;
                this.portFile.delete();
                this.utils.threads().pause(150);
                if (this.pidFile.exists()) {
                    this.printMessage(this.pidFile + " still exits.");
                }
                if (this.portFile.exists()) {
                    this.printMessage(this.portFile + " still exits.");
                }
            }
            this.setReadyForConnection(false);
            if (!this.options.isEmpty()) {
                this.printMessage("clearing options");
                this.options.clear();
            }
            this.printMessage("shutdown complete");
            this.out.flush();
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    void destroyShell() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String shellName = this.getShell().getName();
        this.printWarning("attempting to destroy thread " + shellName);
        this.getShell().destroyProcess();
        this.waitForShellToDie();
        String msg = String.valueOf(this.shellRunning() ? "not " : "") + "destroyed.";
        this.printWarning(String.valueOf(shellName) + " " + msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    void issueForceKill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.printWarning("attempting to \"force kill\" " + this.pid());
        new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils, this.windowsKillCommand).forceKill();
        this.waitForProcessToDie();
        if (this.processRunning()) {
            String msg = String.valueOf(this.processRunning() ? "not " : "") + "killed.";
            this.printWarning(String.valueOf(this.pid()) + " " + msg);
        } else {
            this.printMessage("force kill " + this.pid() + " issued.");
        }
        Object var3_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
    }

    private void issueNormalKill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (!this.pidFile.exists()) {
            this.printWarning("Not running? File not found: " + this.pidFile);
        } else {
            new ProcessUtil(this.pid(), this.err, this.err, this.baseDir, this.utils, this.windowsKillCommand).killNoThrow();
            this.waitForProcessToDie();
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private void waitForProcessToDie() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                this.utils.threads().pause(250);
            }
            if (!this.processRunning()) break;
        } while (System.currentTimeMillis() < giveUp);
        Object var4_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_3, joinPoint);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private void waitForShellToDie() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        long giveUp = System.currentTimeMillis() + (long)this.killDelay;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                this.utils.threads().pause(250);
            }
            if (!this.shellRunning()) break;
        } while (System.currentTimeMillis() < giveUp);
        Object var4_3 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_3, joinPoint);
    }

    public synchronized Map getServerOptions() {
        HashMap hashMap;
        HashMap hashMap2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.options.isEmpty()) {
            this.options = this.optionParser.getOptionsFromHelp(this.getHelp(new HashMap()));
            this.options.put("basedir", this.baseDir.getPath());
            this.options.put("datadir", this.dataDir.getPath());
        }
        HashMap hashMap3 = hashMap2 = (hashMap = new HashMap(this.options));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(hashMap2, joinPoint);
        return hashMap;
    }

    public synchronized boolean isRunning() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl3 = bl2 = !this.shellRunning() && !this.processRunning() ? (bl = false) : (bl = true);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    private boolean processRunning() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl3 = bl2 = !this.pidFile.exists() ? (bl = false) : (bl = new ProcessUtil(this.pid(), this.out, this.err, this.baseDir, this.utils, this.windowsKillCommand).isRunning());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    private boolean shellRunning() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl3 = bl2 = this.getShell() != null && this.getShell().isAlive() ? (bl = true) : (bl = false);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    public synchronized String getVersion() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = string2 = (string = this.versionString);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    private String getVersionDir() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = string2 = (string = this.getVersion().replaceAll("\\.", "-"));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setVersion(boolean bl, String string) {
        void mysqlVersionString;
        void checkRunning;
        boolean bl2 = bl;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (checkRunning != false && this.isRunning()) {
            throw new IllegalStateException("Already running");
        }
        this.versionString = mysqlVersionString == null || mysqlVersionString.equals("") ? String.valueOf(System.getProperty("mysql-version", this.connectorMxjProperties.getProperty("mysql-version"))) : mysqlVersionString;
        this.versionString = this.versionString.trim();
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setVersion(String string) {
        void mysqlVersionString;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.setVersion(true, (String)mysqlVersionString);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void printMessage(String string) {
        void msg;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.println(this.out, (String)msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void printWarning(String string) {
        void msg;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.println(this.err, "");
        this.println(this.err, (String)msg);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void println(PrintStream printStream, String string) {
        void msg;
        void stream;
        PrintStream printStream2 = printStream;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)printStream2, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        stream.println(String.valueOf(this.msgPrefix) + (String)msg);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final String getWindowsKillCommand(Properties properties) {
        String string;
        void props;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String key = "windows-kill-command";
        String defaultVal = "kill.exe";
        String fileVal = props.getProperty(key, defaultVal);
        String val = System.getProperty(key, fileVal).trim();
        String string2 = val.length() > 0 ? val : defaultVal;
        String string3 = string = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    final void setOsAndArch(String string, String string2) {
        void osArch;
        void osName;
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)string3, (Object)string4);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String key = this.stripUnwantedChars(String.valueOf(osName) + "-" + (String)osArch);
        this.osName_osArch = this.platformProperties.getProperty(key, key);
        Object var7_7 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var7_7, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    String stripUnwantedChars(String string) {
        void str;
        String string2;
        String string3;
        String string4 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string4);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string5 = string3 = (string2 = str.replace(' ', '_').replace('/', '_').replace('\\', '_'));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private Shell exec(String string, Map map, PrintStream printStream, PrintStream printStream2, boolean bl) {
        Shell shell;
        Shell shell2;
        void withListeners;
        void errStream;
        void threadName;
        void outStream;
        void mysqldArgs;
        String string2 = string;
        Map map2 = map;
        PrintStream printStream3 = printStream;
        PrintStream printStream4 = printStream2;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{string2, map2, printStream3, printStream4, Conversions.booleanObject((boolean)bl2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.deployFiles();
        this.adjustParameterMap((Map)mysqldArgs);
        Object[] args = this.constructArgs((Map)mysqldArgs);
        outStream.println(new ListToString().toString(args));
        Shell launch = this.utils.shellFactory().newShell((String[])args, (String)threadName, (PrintStream)outStream, (PrintStream)errStream);
        if (withListeners != false) {
            int i = 0;
            while (i < this.completionListensers.size()) {
                Runnable listener = (Runnable)this.completionListensers.get(i);
                launch.addCompletionListener(listener);
                ++i;
            }
        }
        launch.setDaemon(true);
        this.printMessage("launching mysqld (" + (String)threadName + ")");
        launch.start();
        Shell shell3 = shell2 = (shell = launch);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(shell2, joinPoint);
        return shell;
    }

    public void deployFiles() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.makeMysqld();
        this.ensureEssentialFilesExist();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void adjustParameterMap(Map map) {
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureDir((Map)mysqldArgs, this.baseDir, "basedir");
        this.ensureDir((Map)mysqldArgs, this.dataDir, "datadir");
        mysqldArgs.put("pid-file", this.pidFile.getPath());
        this.ensureSocket((Map)mysqldArgs);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    File makeMysqld() {
        File file;
        File file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File mysqld = this.getMysqldFilePointer();
        if (!mysqld.exists()) {
            mysqld.getParentFile().mkdirs();
            this.utils.streams().createFileFromResource(this.getResourceName(), mysqld);
        }
        this.utils.files().addExecutableRights(mysqld, this.out, this.err);
        File file3 = file2 = (file = mysqld);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file2, joinPoint);
        return file;
    }

    String getResourceName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String dir = this.os_arch();
        String name = this.executableName();
        String string3 = string2 = (string = String.valueOf(this.getVersionDir()) + "/" + dir + "/" + name);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    String os_arch() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String string3 = string2 = (string = this.osName_osArch);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    private String executableName() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String mysqld = "mysqld";
        String string2 = this.isWindows() ? String.valueOf(mysqld) + "-nt.exe" : mysqld;
        String string3 = string = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string2;
    }

    boolean isWindows() {
        boolean bl;
        boolean bl2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl3 = bl2 = (bl = this.osName_osArch.startsWith("Win"));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    File getMysqldFilePointer() {
        File file;
        File file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File bin = new File(this.baseDir, "bin");
        File file3 = file2 = (file = new File(bin, this.executableName()));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file2, joinPoint);
        return file;
    }

    void ensureEssentialFilesExist() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.utils.streams().expandResourceJar(this.dataDir, String.valueOf(this.getVersionDir()) + "/" + "data_dir.jar");
        this.utils.streams().expandResourceJar(this.baseDir, String.valueOf(this.getVersionDir()) + "/" + this.shareJar());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    void ensureSocket(Map map) {
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String socketString = (String)mysqldArgs.get("socket");
        if (socketString == null) {
            mysqldArgs.put("socket", "mysql.sock");
        }
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureDir(Map map, File file, String string) {
        File asConnonical;
        void expected;
        void key;
        void mysqldArgs;
        Map map2 = map;
        File file2 = file;
        String string2 = string;
        Object[] objectArray = new Object[]{map2, file2, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String dirString = (String)mysqldArgs.get(key);
        if (dirString != null && !expected.equals(asConnonical = this.utils.files().validCononicalDir(new File(dirString)))) {
            String msg = String.valueOf(dirString) + " not equal to " + expected;
            throw new IllegalArgumentException(msg);
        }
        mysqldArgs.put(key, this.utils.files().getPath((File)expected));
        Object var12_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var12_12, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    String[] constructArgs(Map map) {
        String[] stringArray;
        String[] stringArray2;
        void mysqldArgs;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.utils.files().getPath(this.getMysqldFilePointer()));
        strs.add("--no-defaults");
        if (this.isWindows()) {
            strs.add("--console");
        }
        Iterator it = mysqldArgs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            StringBuffer buf = new StringBuffer("--");
            buf.append(key);
            if (value != null) {
                buf.append("=");
                buf.append(value);
            }
            strs.add(buf.toString());
        }
        String[] stringArray3 = stringArray2 = (stringArray = this.utils.str().toStringArray(strs));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(stringArray2, joinPoint);
        return stringArray;
    }

    protected void finalize() throws Throwable {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.getShell() != null) {
            this.printWarning("resource released without closure.");
            this.trace.printStackTrace(this.err);
        }
        super.finalize();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    String shareJar() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        String shareJar = "share_dir.jar";
        if (this.isWindows()) {
            shareJar = "win_" + shareJar;
        }
        String string3 = string2 = (string = shareJar);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    void setShell(Shell shell) {
        void shell2;
        Shell shell3 = shell;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)shell3);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.shell = shell2;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    Shell getShell() {
        Shell shell;
        Shell shell2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        Shell shell3 = shell2 = (shell = this.shell);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(shell2, joinPoint);
        return shell;
    }

    public File getBaseDir() {
        File file;
        File file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File file3 = file2 = (file = this.baseDir);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file2, joinPoint);
        return file;
    }

    public File getDataDir() {
        File file;
        File file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File file3 = file2 = (file = this.dataDir);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file2, joinPoint);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    int getKillDelyFromProperties(Properties properties) {
        void props;
        int n;
        int n2;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int n3 = n2 = (n = this.parseInt(new Object((Properties)props){
            private final /* synthetic */ Properties val$props;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
            {
                this.val$props = properties;
            }

            public String toString() {
                String string;
                String string2;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
                String string3 = string2 = (string = System.getProperty("kill-delay", this.val$props.getProperty("kill-delay", "300000")));
                Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
                return string;
            }

            static {
                Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource$3"));
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.management.MysqldResource$3----java.lang.String-"), 653);
            }
        }, 300000));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setKillDelay(int n) {
        void millis;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.killDelay = millis;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addCompletionListenser(Runnable runnable) {
        void listener;
        Runnable runnable2 = runnable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)runnable2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.completionListensers.add(listener);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private String getHelp(Map map) {
        String string;
        String string2;
        void params;
        Map map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object)map2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream capturedOut = new PrintStream(bos);
        params.put("help", null);
        params.put("verbose", null);
        this.exec("getOptions", (Map)params, capturedOut, capturedOut, false).join();
        params.remove("help");
        params.remove("verbose");
        this.utils.threads().pause(500);
        capturedOut.flush();
        capturedOut.close();
        String string3 = string2 = (string = new String(bos.toByteArray()));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    public synchronized int getPort() {
        int n;
        int n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int n3 = n2 = this.isRunning() && this.portFile.exists() ? (n = this.parseInt(new Object(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public String toString() {
                String string;
                String string2;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
                String string3 = string2 = (string = MysqldResource.access$2(MysqldResource.this).files().asString(MysqldResource.access$3(MysqldResource.this)));
                Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(string2, joinPoint);
                return string;
            }

            static {
                Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource$4"));
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.management.MysqldResource$4----java.lang.String-"), 691);
            }
        }, 0)) : (n = 0);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    int parseInt(Object object, int n) {
        void defaultVal;
        void parseMe;
        int n2;
        int n3;
        Object object2 = object;
        int n4 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object)object2, (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int n5 = n3 = (n2 = this.utils.str().parseInt(parseMe, (int)defaultVal, this.err));
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n3), joinPoint);
        return n2;
    }

    static void printUsage(PrintStream printStream) {
        PrintStream out;
        PrintStream printStream2 = printStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, null, null, (Object)printStream2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer stringBuffer = new StringBuffer("java ");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.mysql.management.MysqldResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String command = stringBuffer.append(clazz.getName()).toString();
        String basedir = " --basedir";
        String datadir = " --datadir";
        out.println("Usage to start: ");
        out.println(String.valueOf(command) + " [ server options ]");
        out.println();
        out.println("Usage to shutdown: ");
        out.println(String.valueOf(command) + " --shutdown [" + basedir + "=/full/path/to/basedir ]");
        out.println();
        out.println("Common server options include:");
        out.println(String.valueOf(basedir) + "=/full/path/to/basedir");
        out.println(String.valueOf(datadir) + "=/full/path/to/datadir");
        out.println(" --socket=/full/path/to/socketfile");
        out.println();
        out.println("Example:");
        out.println(String.valueOf(command) + basedir + "=/home/duke/dukeapp/db" + datadir + "=/data/dukeapp/data" + " --max_allowed_packet=65000000");
        out.println(String.valueOf(command) + " --shutdown" + basedir + "=/home/duke/dukeapp/db");
        out.println();
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    public static void main(String[] stringArray) {
        String[] args;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, null, null, (Object)stringArray2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        CommandLineOptionsParser clop = new CommandLineOptionsParser(args);
        if (clop.containsKey("help")) {
            MysqldResource.printUsage(System.out);
        } else {
            PrintStream out = System.out;
            PrintStream err = System.err;
            if (clop.containsKey("silent")) {
                clop.remove("silent");
                NullPrintStream devNull = new NullPrintStream();
                out = devNull;
                err = devNull;
            }
            MysqldResource mysqld = new MysqldResource(clop.getBaseDir(), clop.getDataDir(), clop.getVersion(), out, err);
            Integer newKillDelay = clop.getKillDelay(err);
            if (newKillDelay != null) {
                mysqld.setKillDelay(newKillDelay);
            }
            if (clop.isShutdown()) {
                mysqld.shutdown();
            } else {
                mysqld.start(new Threads().newName(), clop.asMap());
            }
        }
        Object var8_8 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var8_8, joinPoint);
    }

    static /* synthetic */ void access$0(MysqldResource mysqldResource, boolean bl) {
        MysqldResource mysqldResource2 = mysqldResource;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, null, null, (Object)mysqldResource2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        mysqldResource.setReadyForConnection(bl);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    static /* synthetic */ List access$1(MysqldResource mysqldResource) {
        List list;
        List list2;
        MysqldResource mysqldResource2 = mysqldResource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, null, null, (Object)mysqldResource2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        List list3 = list2 = (list = mysqldResource.completionListensers);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(list2, joinPoint);
        return list;
    }

    static /* synthetic */ Utils access$2(MysqldResource mysqldResource) {
        Utils utils;
        Utils utils2;
        MysqldResource mysqldResource2 = mysqldResource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, null, null, (Object)mysqldResource2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        Utils utils3 = utils2 = (utils = mysqldResource.utils);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(utils2, joinPoint);
        return utils;
    }

    static /* synthetic */ File access$3(MysqldResource mysqldResource) {
        File file;
        File file2;
        MysqldResource mysqldResource2 = mysqldResource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, null, null, (Object)mysqldResource2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File file3 = file2 = (file = mysqldResource.portFile);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(file2, joinPoint);
        return file;
    }

    static {
        Factory factory = new Factory("MysqldResource.java", Class.forName("com.mysql.management.MysqldResource"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-initTrace-com.mysql.management.MysqldResource----void-"), 157);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-start-com.mysql.management.MysqldResource-java.lang.String:java.util.Map:-threadName:mysqldArgs:--void-"), 165);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-destroyShell-com.mysql.management.MysqldResource----void-"), 359);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-issueForceKill-com.mysql.management.MysqldResource----void-"), 368);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-issueNormalKill-com.mysql.management.MysqldResource----void-"), 382);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-waitForProcessToDie-com.mysql.management.MysqldResource----void-"), 393);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-waitForShellToDie-com.mysql.management.MysqldResource----void-"), 400);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getServerOptions-com.mysql.management.MysqldResource----java.util.Map-"), 407);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-isRunning-com.mysql.management.MysqldResource----boolean-"), 416);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-processRunning-com.mysql.management.MysqldResource----boolean-"), 420);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-shellRunning-com.mysql.management.MysqldResource----boolean-"), 428);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getVersion-com.mysql.management.MysqldResource----java.lang.String-"), 432);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-start-com.mysql.management.MysqldResource-java.lang.String:java.util.Map:boolean:-threadName:pMysqldArgs:populateAllOptions:--void-"), 169);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getVersionDir-com.mysql.management.MysqldResource----java.lang.String-"), 436);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("22-setVersion-com.mysql.management.MysqldResource-boolean:java.lang.String:-checkRunning:mysqlVersionString:--void-"), 440);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setVersion-com.mysql.management.MysqldResource-java.lang.String:-mysqlVersionString:--void-"), 456);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-printMessage-com.mysql.management.MysqldResource-java.lang.String:-msg:--void-"), 460);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-printWarning-com.mysql.management.MysqldResource-java.lang.String:-msg:--void-"), 464);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-println-com.mysql.management.MysqldResource-java.io.PrintStream:java.lang.String:-stream:msg:--void-"), 469);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getWindowsKillCommand-com.mysql.management.MysqldResource-java.util.Properties:-props:--java.lang.String-"), 474);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-setOsAndArch-com.mysql.management.MysqldResource-java.lang.String:java.lang.String:-osName:osArch:--void-"), 483);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-stripUnwantedChars-com.mysql.management.MysqldResource-java.lang.String:-str:--java.lang.String-"), 488);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-exec-com.mysql.management.MysqldResource-java.lang.String:java.util.Map:java.io.PrintStream:java.io.PrintStream:boolean:-threadName:mysqldArgs:outStream:errStream:withListeners:--com.mysql.management.util.Shell-"), 492);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-canConnectToServer-com.mysql.management.MysqldResource-int:int:-port:milisecondsBeforeGivingUp:--boolean-"), 234);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-deployFiles-com.mysql.management.MysqldResource----void-"), 517);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-adjustParameterMap-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--void-"), 522);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-makeMysqld-com.mysql.management.MysqldResource----java.io.File-"), 529);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getResourceName-com.mysql.management.MysqldResource----java.lang.String-"), 539);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-os_arch-com.mysql.management.MysqldResource----java.lang.String-"), 546);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-executableName-com.mysql.management.MysqldResource----java.lang.String-"), 550);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isWindows-com.mysql.management.MysqldResource----boolean-"), 555);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getMysqldFilePointer-com.mysql.management.MysqldResource----java.io.File-"), 559);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-ensureEssentialFilesExist-com.mysql.management.MysqldResource----void-"), 564);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-ensureSocket-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--void-"), 571);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setReadyForConnection-com.mysql.management.MysqldResource-boolean:-ready:--void-"), 265);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-ensureDir-com.mysql.management.MysqldResource-java.util.Map:java.io.File:java.lang.String:-mysqldArgs:expected:key:--void-"), 579);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-constructArgs-com.mysql.management.MysqldResource-java.util.Map:-mysqldArgs:--[Ljava.lang.String;-"), 592);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-finalize-com.mysql.management.MysqldResource---java.lang.Throwable:-void-"), 617);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-shareJar-com.mysql.management.MysqldResource----java.lang.String-"), 625);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setShell-com.mysql.management.MysqldResource-com.mysql.management.util.Shell:-shell:--void-"), 633);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getShell-com.mysql.management.MysqldResource----com.mysql.management.util.Shell-"), 637);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getBaseDir-com.mysql.management.MysqldResource----java.io.File-"), 641);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDataDir-com.mysql.management.MysqldResource----java.io.File-"), 645);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getKillDelyFromProperties-com.mysql.management.MysqldResource-java.util.Properties:-props:--int-"), 649);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-setKillDelay-com.mysql.management.MysqldResource-int:-millis:--void-"), 660);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-isReadyForConnections-com.mysql.management.MysqldResource----boolean-"), 269);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-addCompletionListenser-com.mysql.management.MysqldResource-java.lang.Runnable:-listener:--void-"), 664);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getHelp-com.mysql.management.MysqldResource-java.util.Map:-params:--java.lang.String-"), 668);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getPort-com.mysql.management.MysqldResource----int-"), 687);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-parseInt-com.mysql.management.MysqldResource-java.lang.Object:int:-parseMe:defaultVal:--int-"), 699);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-printUsage-com.mysql.management.MysqldResource-java.io.PrintStream:-out:--void-"), 704);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-main-com.mysql.management.MysqldResource-[Ljava.lang.String;:-args:--void-"), 729);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$0-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:boolean:-arg0:arg1:--void-"), 265);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$1-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:-arg0:--java.util.List-"), 91);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$2-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:-arg0:--com.mysql.management.util.Utils-"), 100);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8-access$3-com.mysql.management.MysqldResource-com.mysql.management.MysqldResource:-arg0:--java.io.File-"), 71);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reportPid-com.mysql.management.MysqldResource----void-"), 273);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("20-pid-com.mysql.management.MysqldResource----java.lang.String-"), 291);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-reportIfNoPidfile-com.mysql.management.MysqldResource-boolean:-pidFileFound:--void-"), 302);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-shutdown-com.mysql.management.MysqldResource----void-"), 311);
    }
}

