/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.BindingKey;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.ITypeParameter;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchPattern
extends SearchPattern {
    boolean isCaseSensitive;
    int matchMode;
    int matchCompatibility;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_COMPATIBILITY_MASK = 112;
    char[][] typeSignatures;
    private char[][][] typeArguments;
    private int flags = 0;
    static final int HAS_TYPE_ARGUMENTS = 1;

    protected JavaSearchPattern(int patternKind, int matchRule) {
        super(matchRule);
        this.kind = patternKind;
        int rule = this.getMatchRule();
        this.isCaseSensitive = (rule & 8) != 0;
        this.matchCompatibility = rule & 0x70;
        this.matchMode = rule & 7;
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    boolean isEquivalentMatch() {
        return (this.matchCompatibility & 0x20) != 0;
    }

    char[][] extractMethodArguments(IMethod method) {
        int length;
        BindingKey key;
        String[] argumentsSignatures = null;
        if (!method.isResolved() || !(key = new BindingKey(method.getKey())).isParameterizedType()) {
            try {
                int length2;
                ITypeParameter[] parameters = method.getTypeParameters();
                int n = length2 = parameters == null ? 0 : parameters.length;
                if (length2 > 0) {
                    char[][] arguments = new char[length2][];
                    int i = 0;
                    while (i < length2) {
                        arguments[i] = Signature.createTypeSignature(parameters[i].getElementName(), false).toCharArray();
                        ++i;
                    }
                    return arguments;
                }
            }
            catch (JavaModelException parameters) {
                // empty catch block
            }
            return null;
        }
        argumentsSignatures = key.getTypeArguments();
        int n = length = argumentsSignatures == null ? 0 : argumentsSignatures.length;
        if (length > 0) {
            char[][] methodArguments = new char[length][];
            int i = 0;
            while (i < length) {
                methodArguments[i] = argumentsSignatures[i].toCharArray();
                CharOperation.replace(methodArguments[i], new char[]{'$', '/'}, '.');
                ++i;
            }
            return methodArguments;
        }
        return null;
    }

    final char[][][] getTypeArguments() {
        return this.typeArguments;
    }

    public final boolean hasSignatures() {
        return this.typeSignatures != null && this.typeSignatures.length > 0;
    }

    public final boolean hasTypeArguments() {
        return (this.flags & 1) != 0;
    }

    public final boolean hasTypeParameters() {
        return !this.hasSignatures() && this.hasTypeArguments();
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this.isCaseSensitive);
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    protected StringBuffer print(StringBuffer output) {
        output.append(", ");
        if (this.hasTypeArguments() && this.hasSignatures()) {
            output.append("signature:\"");
            output.append(this.typeSignatures[0]);
            output.append("\", ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                output.append("exact match,");
                break;
            }
            case 1: {
                output.append("prefix match,");
                break;
            }
            case 2: {
                output.append("pattern match,");
            }
        }
        if (this.isCaseSensitive()) {
            output.append(" case sensitive");
        } else {
            output.append(" case insensitive");
        }
        if ((this.matchCompatibility & 0x10) != 0) {
            output.append(", erasure only");
        }
        if ((this.matchCompatibility & 0x20) != 0) {
            output.append(", equivalent oronly");
        }
        return output;
    }

    final void setTypeArguments(char[][][] typeArguments) {
        this.typeArguments = typeArguments;
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            int i = 0;
            while (i < length) {
                if (this.typeArguments[i] != null && this.typeArguments[i].length > 0) {
                    this.flags |= 1;
                    break;
                }
                ++i;
            }
        }
    }

    void storeTypeSignaturesAndArguments(IType type) {
        BindingKey key;
        if (type.isResolved() && (key = new BindingKey(type.getKey())).isParameterizedType()) {
            String signature = key.internalToSignature();
            this.typeSignatures = Util.splitTypeLevelsSignature(signature);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        } else {
            char[][][] typeParameters = new char[10][][];
            int ptr = -1;
            boolean hasParameters = false;
            try {
                IJavaElement parent = type;
                ITypeParameter[] parameters = null;
                while (parent != null && parent.getElementType() == 7) {
                    IType parentType;
                    int length;
                    if (++ptr > typeParameters.length) {
                        char[][][] cArray = typeParameters;
                        typeParameters = new char[typeParameters.length + 10][][];
                        System.arraycopy(cArray, 0, typeParameters, 0, ptr);
                    }
                    int n = length = (parameters = (parentType = parent).getTypeParameters()) == null ? 0 : parameters.length;
                    if (length > 0) {
                        hasParameters = true;
                        typeParameters[ptr] = new char[length][];
                        int i = 0;
                        while (i < length) {
                            typeParameters[ptr][i] = Signature.createTypeSignature(parameters[i].getElementName(), false).toCharArray();
                            ++i;
                        }
                    }
                    parent = parent.getParent();
                }
            }
            catch (JavaModelException jme) {
                return;
            }
            if (hasParameters) {
                if (++ptr < typeParameters.length) {
                    char[][][] cArray = typeParameters;
                    typeParameters = new char[ptr][][];
                    System.arraycopy(cArray, 0, typeParameters, 0, ptr);
                }
                this.setTypeArguments(typeParameters);
            }
        }
    }

    public final String toString() {
        return this.print(new StringBuffer(30)).toString();
    }
}

