/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IField;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryMember;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.Member;
import org.aspectj.org.eclipse.jdt.internal.core.ResolvedBinaryField;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(JavaElement parent, String name) {
        super(parent, name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryField)) {
            return false;
        }
        return super.equals(o);
    }

    public Object getConstant() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return Member.convertConstant(info.getConstant());
    }

    public int getFlags() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return info.getModifiers();
    }

    public int getElementType() {
        return 8;
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    public String getTypeSignature() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return new String(ClassFile.translatedName(info.getTypeName()));
    }

    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    public boolean isResolved() {
        return false;
    }

    public JavaElement resolved(Binding binding) {
        ResolvedBinaryField resolvedHandle = new ResolvedBinaryField(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

