/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxClassInfo_CreateObject, "CreateObject() -> Object\n"
"\n"
"Creates an object of the appropriate kind.");

extern "C" {static PyObject *meth_wxClassInfo_CreateObject(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_CreateObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
             ::wxObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CreateObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxObject,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_CreateObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_GetBaseClassName1, "GetBaseClassName1() -> Char\n"
"\n"
"Returns the name of the first base class (NULL if none).");

extern "C" {static PyObject *meth_wxClassInfo_GetBaseClassName1(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_GetBaseClassName1(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
            const  ::wxChar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBaseClassName1();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_FromWideChar(sipRes,(Py_ssize_t)wcslen(sipRes));
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_GetBaseClassName1, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_GetBaseClassName2, "GetBaseClassName2() -> Char\n"
"\n"
"Returns the name of the second base class (NULL if none).");

extern "C" {static PyObject *meth_wxClassInfo_GetBaseClassName2(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_GetBaseClassName2(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
            const  ::wxChar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBaseClassName2();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_FromWideChar(sipRes,(Py_ssize_t)wcslen(sipRes));
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_GetBaseClassName2, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_GetClassName, "GetClassName() -> Char\n"
"\n"
"Returns the string form of the class name.");

extern "C" {static PyObject *meth_wxClassInfo_GetClassName(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_GetClassName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
            const  ::wxChar*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClassName();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_FromWideChar(sipRes,(Py_ssize_t)wcslen(sipRes));
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_GetClassName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_GetSize, "GetSize() -> int\n"
"\n"
"Returns the size of the class.");

extern "C" {static PyObject *meth_wxClassInfo_GetSize(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_GetSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSize();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_GetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_IsDynamic, "IsDynamic() -> bool\n"
"\n"
"Returns true if this class info can create objects of the associated\n"
"class.");

extern "C" {static PyObject *meth_wxClassInfo_IsDynamic(PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_IsDynamic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClassInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsDynamic();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_IsDynamic, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_IsKindOf, "IsKindOf(info) -> bool\n"
"\n"
"Returns true if this class is a kind of (inherits from) the given\n"
"class.");

extern "C" {static PyObject *meth_wxClassInfo_IsKindOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_IsKindOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxClassInfo* info;
        const  ::wxClassInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_info,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxClassInfo, &sipCpp, sipType_wxClassInfo, &info))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsKindOf(info);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_IsKindOf, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClassInfo_FindClass, "FindClass(className) -> ClassInfo\n"
"\n"
"Finds the wxClassInfo object for a class with the given name.");

extern "C" {static PyObject *meth_wxClassInfo_FindClass(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClassInfo_FindClass(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* className;
        int classNameState = 0;

        static const char *sipKwdList[] = {
            sipName_className,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &className, &classNameState))
        {
             ::wxClassInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxClassInfo::FindClass(*className);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(className), sipType_wxString, classNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxClassInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClassInfo, sipName_FindClass, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxClassInfo(void *, int);}
static void release_wxClassInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxClassInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxClassInfo(sipSimpleWrapper *);}
static void dealloc_wxClassInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxClassInfo(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxClassInfo[] = {
    {sipName_CreateObject, meth_wxClassInfo_CreateObject, METH_VARARGS, doc_wxClassInfo_CreateObject},
    {sipName_FindClass, SIP_MLMETH_CAST(meth_wxClassInfo_FindClass), METH_VARARGS|METH_KEYWORDS, doc_wxClassInfo_FindClass},
    {sipName_GetBaseClassName1, meth_wxClassInfo_GetBaseClassName1, METH_VARARGS, doc_wxClassInfo_GetBaseClassName1},
    {sipName_GetBaseClassName2, meth_wxClassInfo_GetBaseClassName2, METH_VARARGS, doc_wxClassInfo_GetBaseClassName2},
    {sipName_GetClassName, meth_wxClassInfo_GetClassName, METH_VARARGS, doc_wxClassInfo_GetClassName},
    {sipName_GetSize, meth_wxClassInfo_GetSize, METH_VARARGS, doc_wxClassInfo_GetSize},
    {sipName_IsDynamic, meth_wxClassInfo_IsDynamic, METH_VARARGS, doc_wxClassInfo_IsDynamic},
    {sipName_IsKindOf, SIP_MLMETH_CAST(meth_wxClassInfo_IsKindOf), METH_VARARGS|METH_KEYWORDS, doc_wxClassInfo_IsKindOf}
};

sipVariableDef variables_wxClassInfo[] = {
    {PropertyVariable, sipName_Size, &methods_wxClassInfo[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ClassName, &methods_wxClassInfo[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BaseClassName2, &methods_wxClassInfo[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BaseClassName1, &methods_wxClassInfo[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxClassInfo, "This class stores meta-information about classes.");


sipClassTypeDef sipTypeDef__core_wxClassInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxClassInfo,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_ClassInfo,
        {0, 0, 1},
        8, methods_wxClassInfo,
        0, SIP_NULLPTR,
        4, variables_wxClassInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxClassInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxClassInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxClassInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
